/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * jgr_func.c 
 */

#include <stdio.h>
#include <math.h>
#include <pm.h>
#include <defaults.h>
#include <symbols.h>
#include <constants.h>
#include <math_utils.h>
#include <continue.h>


int
jgr_init(n_aug_varb,max_iters,xr,fpar,state,parameters)
int	*n_aug_varb, max_iters;
double	***xr, **fpar, *state, *parameters;
{
  int		i, i1=1, i2=1, nvar, index=0;
  double	*dwork, *wr, *wi, **eig_vec, min, mag=0.0, magsign;
/*		sqrt(), fabs(), copysign(); */
  int           n_varbs  = *((int *) pm( GET, "Model.Varb_Dim", NULL )) - 1; 
  int           n_params = *((int *) pm( GET, "Model.Param_Dim", NULL ));

  *n_aug_varb   =       2*n_varbs+1;
  nvar          =       n_varbs + (*n_aug_varb) + Cont_Sel[Cont_Cur_Choice].Num_Req_Param;

  cont_alloc( max_iters, n_varbs, n_params, nvar, xr, fpar );

  update_cont_state( (*xr)[0], state, parameters, n_varbs, *n_aug_varb, n_params );

  for(i=1; i<= n_params; i++) (*fpar)[i] = parameters[i-1];

  wr = cont_ds.r_workspace;
  wi = wr + 2*n_varbs + 2;
  dwork = wi + 2*n_varbs + 2;

  eig_vec = dmatrix(0,n_varbs,0,n_varbs);
  get_Dxf( cont_ds.jacobian_wrt_x, n_varbs, state, parameters );

  get_eigenvec(cont_ds.jacobian_wrt_x, n_varbs, wr, wi, eig_vec);

  min = fabs(wr[0]);			/* which eigenvalue is closest to being */
  for(i=1; i<n_varbs; i++)		/* purely imaginary?                    */
    if( fabs(wr[i]) < min )
      {
       min = fabs(wr[i]);
       index = i;			/* index is referenced starting from -> 0 <- */
      }

  for(i=1; i<=n_varbs; i++)				/* get real and imag parts of eigenvectors */
    {
     (*xr)[0][i+n_varbs] = eig_vec[i][index+1];
     (*xr)[0][i+2*n_varbs] = eig_vec[i][index+2];
    }
  (*xr)[0][3*n_varbs+1] = wi[index];		/* get magnitude of "purely imag" eigenvalue */	

  for(i=1; i<=n_varbs; i++)
     mag += ((*xr)[0][i+n_varbs])*((*xr)[0][i+2*n_varbs]);	/* if (u+vi) is eigenvector, normalize */
  magsign=copysign(1.0,mag);					/* u & v so u*v=1                      */
  mag = sqrt(fabs(mag));
  for(i=1; i<=n_varbs; i++)
      (*xr)[0][i+n_varbs] /= mag;
  if ( magsign< 0.0 )
     {
      mag *= -1.0;						/* may need to choose cmplx conj vector */
      (*xr)[0][3*n_varbs+1] *= -1.0;
     }

  for(i=1; i<=n_varbs; i++)
      (*xr)[0][i+2*n_varbs] /= mag;

  for(i=2; i<=n_varbs; i++) 					/* what are the 2 largest components? */
    {
     if ( fabs(eig_vec[i][index+1]) > fabs(eig_vec[i1][index+1]) ) i1 = i;
     if ( fabs(eig_vec[i][index+1]) < fabs(eig_vec[i1][index+1]) ) i2 = i;
    }
  for(i=1; i<=n_varbs; i++)
     if ( fabs(eig_vec[i][index+1]) > fabs(eig_vec[i2][index+1]) && i != i1 ) i2 = i;

  for(i=1; i<=n_varbs; i++) (*fpar)[i+n_params] = 0.0;

  (*fpar)[i1+n_params] = (*xr)[0][i2+n_varbs]/( (*xr)[0][i1+n_varbs]*(*xr)[0][i2+n_varbs]);	/* set normalizing vector */
  (*fpar)[i2+n_params] = -(*xr)[0][i1+n_varbs]/( (*xr)[0][i1+n_varbs]*(*xr)[0][i2+n_varbs]);    /* orthog to eigenvector real part */

  free_dmatrix(eig_vec,0,n_varbs,0,n_varbs);
  return(0);
}


int
jgr_update(x,parm,n_aug_varb)
int	n_aug_varb;
double	*x, *parm;
{
/*
  int		i, max_index, index;
  double	max, fabs();
  int           n_varbs  = *((int *) pm( GET, "Model.Varb_Dim", NULL )) - 1; 
  int           n_params = *((int *) pm( GET, "Model.Param_Dim", NULL ));
  
  double	*wr, *wi, **eig_vec;
 */

  return(0);

}



int  
jgr_func(nvar,fpar,ipar,x,fx)
int	nvar, *ipar;
double	*fpar, *fx, *x;
{
  int             (*function)(double *fx, double *x, double *p);
  int		  ierror=0, i;
  int             n_varb = *((int *) pm( GET, "Model.Varb_Dim", NULL )) - 1;
  int             n_params = *((int *) pm( GET, "Model.Param_Dim", NULL ));
  double          *state, *params, *dwork;

  state = cont_ds.r_workspace;
  params = state + n_varb + 1;
  dwork = params + n_params + 1;


  function = (void *) pm( GET, "Model.DS_Def", NULL );
  for(i=0; i<n_params; i++) params[i] = fpar[i+1];

  update_ds_state( x, state, params, n_varb, 2*n_varb+1, n_params );
  function( &fx[1], state, params);

  get_Dxf( cont_ds.jacobian_wrt_x, n_varb, state, params );

  jgr_aug_func( &fx[n_varb+1], x, fpar ); 

  return(ierror);
}



int
jgr_aug_func( g_vector, x, fpar )
double	*g_vector, *x, *fpar;
{
  int		i;
  int           n_varb  = *((int *) pm( GET, "Model.Varb_Dim", NULL )) - 1;
  int           n_param = *((int *) pm( GET, "Model.Param_Dim", NULL ));

/* x[1] and fpar[1] are the first values! */

  multAv( &(g_vector[0]), cont_ds.jacobian_wrt_x, n_varb, n_varb, &(x[n_varb+1]) );
  multAv( &(g_vector[n_varb]), cont_ds.jacobian_wrt_x, n_varb, n_varb, &(x[2*n_varb+1]) );

  g_vector[2*n_varb] = -1.0;
  g_vector[2*n_varb+1] = 0.0;
  for(i=0; i<n_varb; i++)
    {
     g_vector[i] += x[3*n_varb+1]*x[2*n_varb+1+i];
     g_vector[n_varb+i] -= x[3*n_varb+1]*x[n_varb+1+i];
     g_vector[2*n_varb] += x[n_varb+1+i]*x[2*n_varb+1+i];
     g_vector[2*n_varb+1] += x[n_varb+1+i]*fpar[n_param+1+i]; 
    }

  return(0);

}



int
jgr_dfunc(nvar,fpar,ipar,x,fprime)
int	nvar, *ipar;
double	*fpar, *x, **fprime;
{
  int		  ierror=0;
/*  int i;
  double	  *state, *param, *omega;
  int             n_varb = *((int *) pm( GET, "Model.Varb_Dim", NULL )) - 1;
  int             n_params = *((int *) pm( GET, "Model.Param_Dim", NULL ));

  double		*dvector();
 */
  return(ierror);
}

#define TINY   1.e-6


int
jgr_check( color, n_varb, state, param )
int		n_varb, *color;
double		*state, *param;
{
  int   ierror=0;
   int          i, j, mode, *iwork;
   int          hopf=FALSE, nsn=FALSE, degen=FALSE;
   int          n_params = *((int *) pm( GET, "Model.Param_Dim", NULL ));
   double       *wr, *wi, *dwork;


/*
  color[2] = MED_POINT;
  if( !cont_ds.Check_Switch )
     {   
      color[1] = 1;
     }   
  else
     { 
      color[1] = SYS_GREEN;
     }
 */

   color[1] = 1;
   if ( *((int *)pm(GET, "Cont.Search", NULL)) )
     color[2] = MED_TRI;
   else
     color[2] = MED_POINT;
   if( !cont_ds.Check_Switch ) return(ierror);
 
   iwork = cont_ds.i_workspace;
   wr = cont_ds.r_workspace;
   wi = wr + n_varb + 1;
   dwork = wi + n_varb + 1;
   
   get_Dxf( cont_ds.jacobian_wrt_x, n_varb, state, param ); 
   ierror = get_eigenval( cont_ds.jacobian_wrt_x, n_varb, wr, wi); /* fjw */

   if(ierror != 0) return(ierror);
 
   if(cont_ds.Debug_Level > 0)
     {
      fprintf(stderr,"\nstate = ");
      for(i=0; i<n_varb; i++) fprintf(stderr," %g",state[i]);
      fprintf(stderr,"\nparam = ");
      for(i=0; i<n_params; i++) fprintf(stderr," %g",param[i]);
      for(i=0; i<n_varb; i++) fprintf(stderr,"\neig(%d) = (%g,%g)",i, wr[i],wi[i]);
     }
    
   if ( *((int *) pm( GET, "Model.Mapping_Flag", NULL )) )
     {                          /* fjw 8/11/92. Determine type for mapping */
       mode = TRUE;
       for(i=0; i<n_varb && mode; i++)
         for(j=i+1; j<n_varb && mode; j++)
           if( (fabs(fabs(wr[i]*wr[j] - wi[i]*wi[j]) - 1.0) < TINY) 
              && (fabs(wi[i]*wr[j] + wr[i]*wi[j] )< TINY) )/* i,j s.t. product o
f e-vals = 1.0 */
             mode = FALSE;
 
       if (!mode)               /* sucessful detection */
         {
           i--; j--;            /* correct for going too far */
           if( fabs(wr[i] + wr[j]) - 2.0 < TINY ) /* test selected i,j pair */
             {
               hopf = TRUE;
               color[1] = 10;   /* SYS_CYAN */
             }
           else if( fabs(wr[i] + wr[j]) - 2.0 > TINY )
             {
               nsn = TRUE;
               color[1] = 6;    /* SYS_ORANGE */
             }
           else 
             {
               degen = TRUE;
               color[1] = 12;   /* SYS_MAGENTA */
             }
         }
       else
         {
           fprintf(stderr,"\nProblem in hopf?\n");
           for(i=0; i<n_varb; i++) fprintf(stderr,"\neig(%d) = (%g,%g)",i, wr[i]
,wi[i]);
         }
     }
   else                         /* determine type for vector field */
     {
       for(i=0; i<n_varb; i++)
         {
           if( fabs(wr[i]) < TINY && fabs(wi[i])>TINY )
             {
               hopf = TRUE;
               break;
             }
           if( fabs(wr[i])+fabs(wi[i]) < TINY )
             {
               degen=TRUE;
               break;
             }
           for(j=i; j<n_varb; j++)
             {
               if( fabs(wr[i]) > TINY && (wr[i]+wr[j])<TINY &&
                  (wi[i]+wi[j])<TINY &&  fabs(wi[i])<TINY     )
                 {
                   nsn = TRUE;
                   break;
                 }
             }
           if( nsn || hopf || degen ) break;
         }
       if(hopf) color[1] = 10;  /* SYS_CYAN */
       if(degen) color[1] = 12; /* SYS_MAGENTA */
       if(nsn) color[1] = 6;    /* SYS_ORANGE */
     }

  return(ierror);
}

