/* $Id: TopLevel.c,v 1.10 1995/06/12 17:03:30 venkat Exp $ */
/* $Log: TopLevel.c,v $
 * Revision 1.10  1995/06/12 17:03:30  venkat
 * Made the Pixmap resources as "None" instead of NULL. This does not CopyFromParent
 * but uses the corresponding Pixel resources instead. These resources are set at startup
 * as fallback resources for the application.
 *
 * Revision 1.9  1995/05/19  22:20:26  venkat
 * Some more color specific debugging statements for interim
 * solution finding effort for the XCreateWindow/BadMatch error in
 * SGI/IRIX 5.3: Problem surfaced in BETA2-0-P5
 *
 * Revision 1.8  1995/05/17  23:40:47  venkat
 * The width and height are set for the purpose of debugging.
 * This is because we need the shell's color based resources as well as
 * the corresponding window attribs. In order to realize the shell we need at least
 * a non-zero width/height shell
 *
 * Revision 1.7  1995/04/12  18:21:02  venkat
 * Added interface function XoWMPositionHack() which deals with the
 * toplevel shell's positioning interactions with the window manager.
 *
 * Revision 1.6  1995/04/05  19:05:17  venkat
 * Added WMShell resource XtNinput with value set to
 * true while creating application shell widget for non-pointer
 * -following keyboard focus window managers such as fvwm. This
 * hint is ignored by pointer-following kb focus window managers
 * such as twm and so is generalized this version works with all
 * window managers.
 *
 * Revision 1.5  1995/04/04  01:05:32  venkat
 * The Shell's color specific resources including
 * pixmaps are set in the call to XtVaAppCreateShell().
 *
 * Revision 1.4  1995/02/24  20:25:01  venkat
 * Changed name to XoGetUsedColormap()
 *
 * Revision 1.3  1995/02/18  00:37:23  venkat
 * Included the XtNcolormap resource in creating the
 * top level shell.
 *
 * Revision 1.2  1994/03/22  15:13:58  bhalla
 * Attempts to handle incorrect widget placement under twm. Later moved to
 * widg/xform.c
 *
 * Revision 1.1  1994/01/13  18:34:14  bhalla
 * Initial revision
 * */
/*
 * Routines for the maintenance of top level shell widgets.
 */
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xatom.h>
#include "StringDefs.h"


typedef struct _ShellElement {
  Widget shell;
  struct _ShellElement *next;
} ShellElement;


ShellElement *shellList;


Widget XgCreateTopLevelShell (name)
	char * name;
{
  ShellElement *new;
#ifdef BROKEN 
  XWMHints	wm_hints;
#endif
Visual* XoGetUsedVisual();
Colormap XoGetUsedColormap();
int 	XoGetUsedDepth();

  new = (ShellElement *) malloc (sizeof (ShellElement));
  new->next  = shellList;
  /* This version gives each shell the correct name but makes
  ** it hard to assign resources :
  **
  new->shell = XtVaAppCreateShell(name, "Genesis", topLevelShellWidgetClass,
				  XgDisplay(),
				  XtNmappedWhenManaged,False,
				  NULL);
  */

  /* This version calls everything 'genesis' but resources are easier
  ** to specify
	
	Venkat:- The pixmap resources need not be set but it doesnt hurt to put it in there
		 In some mysterious way the pixmaps were being set to invalid values
		 if the default visual was not used 
  */
  new->shell = XtVaAppCreateShell("genesis", "Genesis", topLevelShellWidgetClass,
				  XgDisplay(),
				  XtNmappedWhenManaged, False,
				  XtNallowShellResize, True,
				  XtNinput, True,
				  XtNcolormap, XoGetUsedColormap(),
				  XtNvisual, XoGetUsedVisual(),
				  XtNdepth, XoGetUsedDepth(),
				  XtNbackgroundPixmap, None,
				  XtNborderPixmap, None,
				  XtNx, 0,
				  XtNy, 0,
#ifdef XOCOLOR_DEBUG
				  XtNwidth, 300,
				  XtNheight, 375,
#endif
				  NULL);
#ifdef BROKEN 
  XSetIconName(XgDisplay(), XtWindow(new->shell), name);
  wm_hints.flags = InputHint;
  wm_hints.input = True;
  XSetWMHints(XgDisplay(), XtWindow(new->shell), &wm_hints);
#endif
  return new->shell;
}

XoWMPositionHack(toplevelshell,xpos,ypos)
 Widget   toplevelshell;
 Position xpos;
 Position ypos;
{
  XSizeHints hints;

  hints.flags = USPosition;
  hints.x = xpos;
  hints.y = ypos; 
  XSetSizeHints(XgDisplay(),XtWindow(toplevelshell),&hints,
				XA_WM_NORMAL_HINTS);	
}
