/*
** $Id: conc_struct.h,v 1.2 1997/05/28 21:05:25 dhb Exp $
** $Log: conc_struct.h,v $
** Revision 1.2  1997/05/28 21:05:25  dhb
** Complete update from Antwerp GENESIS
**
** Revision 1.1  1992/12/11  19:02:44  dhb
** Initial revision
**
*/

/* Version EDS21d 97/03/18, Erik De Schutter, BBF-UIA 8/94-3/97 */
/* Because of its idiosyncrasies difpool_type has been deleted.  
** difshell_type has same functionality and is much more general */

#include "struct_defs.h"

/*
*************************************
**         CONCENTRATION           **
*************************************
*/

typedef struct concpool_type Cpool;
typedef struct difshell_type Dshell;
typedef struct taupump_type Tpump;
typedef struct mmpump_type Mpump;
typedef struct fixbuffer_type Fbuffer;
typedef struct difbuffer_type Dbuffer;
typedef struct dif2buffer_type D2buffer;
typedef struct fura2_type Fura2;

struct concpool_type {
    SEGMENT_TYPE
	/* computed variables */
	double	C;
	double	prev_C;
	/* user parameters */
	float	Ceq;
	float	leak;
	short	shape_mode;	/* SHELL, SLAB or USERDEF */
	float	len;
	float   dia;
	float	thick;
	/* semi-private parameters */
	float	vol;
};

struct difshell_type {
    SEGMENT_TYPE
	/* computed variables */
	double	C;
	double	prev_C;
	/* user parameters */
	float	Ceq;
	float	D;
	float	val;
	float	leak;
	short	shape_mode;	/* SHELL, SLAB or USERDEF */
	float	len;
	float   dia;
	float	thick;
	/* semi-private parameters */
	float	vol;
	float	surf_up;
	float	surf_down;
};

struct taupump_type {
	SEGMENT_TYPE
	double	kP;
	float	Ceq;
	float	T_A;
	float	T_B;
	float	T_V;
	float	T_C;
};

struct mmpump_type {
	SEGMENT_TYPE
	double  Ik;
	float	vmax;
	float	val;
	float	Kd;
	double	mmconst;
};

#define FIXBUFFER_TYPE \
	double	Bfree;	\
	double	Bbound; \
	double	prev_free;	\
	double	prev_bound; \
	float	Btot;	\
	float	kBf;	\
	float	kBb;

struct fixbuffer_type {
	SEGMENT_TYPE
	/* computed variables */
	FIXBUFFER_TYPE
};

struct difbuffer_type {
	SEGMENT_TYPE
	/* computed variables */
	FIXBUFFER_TYPE
	/* user parameters */
	float	D;
	short	shape_mode;	/* SHELL, SLAB or USERDEF */
	float	len;
	float   dia;
	float	thick;
	/* semi-private parameters */
	float	vol;
	float	surf_up;
	float	surf_down;
};
struct dif2buffer_type {
	SEGMENT_TYPE
	/* computed variables */
	FIXBUFFER_TYPE
	/* user parameters */
	float	Dfree;
	float	Dbound;
	short	shape_mode;	/* SHELL, SLAB or USERDEF */
	float	len;
	float   dia;
	float	thick;
	/* semi-private parameters */
	float	vol;
	float	surf_up;
	float	surf_down;
};

struct fura2_type {
	SEGMENT_TYPE
	/* computed variables */
	double  F340;
	double  F380;
	double  ratio;
};

