static char rcsid[] = "$Id: compt_update.c,v 1.3 1997/05/28 22:27:14 dhb Exp $";

/*  Version EDS20i 95/06/08, Erik De Schutter, December 1991-March 1994
** Upinder S. Bhalla Caltech May-December 1991 */

#include "hines_ext.h"

/*
** $Log: compt_update.c,v $
** Revision 1.3  1997/05/28 22:27:14  dhb
** Update from Antwerp GENESIS 21e
**
** Revision 1.2  1995/07/21  23:56:20  dhb
** Changed Ca_shell_type to Ca_concen_type.
**
** Revision 1.1  1992/12/11  19:03:06  dhb
** Initial revision
*/


/* Simple function for putting data values back into elements */
do_compt_update(hsolve)
	Hsolve	*hsolve;
{
	int i;
	struct compartment_type **compts;
	int ncompts = hsolve->ncompts;
	int	*elmnum;
	double *results;
	double *v;

	compts = (struct compartment_type **)(hsolve->compts);
	elmnum = hsolve->elmnum;
	results = hsolve->results;

	if (BaseObject(hsolve)->method == CRANK_INT) {
		for(i=0;i<ncompts;i++) {
			v = &(compts[elmnum[i]]->Vm);
			*v = 2.0*results[i]-(*v);
		}
	} else { /* BEULER by default */
		for(i=0;i<ncompts;i++) {
			compts[elmnum[i]]->Vm = results[i];
		}
	}
}
