static char rcsid[] = "$Id: out_ascfile.c,v 1.3 1997/07/18 19:55:38 dhb Exp $";

/*
** $Log: out_ascfile.c,v $
** Revision 1.3  1997/07/18 19:55:38  dhb
** Changes from PSC: parallel versions of ascii and FMT1 I/O objects
**
** Revision 1.2  1994/10/04  23:01:43  dhb
** Added FLUSH action.
**
** Revision 1.1  1992/12/11  19:03:19  dhb
** Initial revision
**
*/

#include "out_ext.h"
#include "output_g@.h"

AscSetupFile(output)
struct ascfile_type *output;
{
float	fval;
int	i;
MsgIn	*msg;

    /*
    ** try to close up the file if it has been left open
    */
    CloseOutputFile(output);
    /*
    ** try to open the file
    */
    if(OpenOutputFile(output,"w")){
	/*
	** go to the beginning of the file
	*/
	fseek(output->fp, 0L, 0);
	ConditionalCloseOutputFile(output);
	/*
	** indicate that the file has been initialized
	*/
	output->initialize = FALSE;
    }
}


AscFileOutput(output,action)
struct ascfile_type *output;
Action		*action;
{
    switch(action->type){
    case RESET:
	/*
	** set the initialization flag
	*/
	if(!output->append){
	    output->initialize = TRUE;
	}
	break;
    case PROCESS:
	/*
	** has the file been initialized?
	*/
	if(output->initialize){
	    AscSetupFile(output);
	}
	/*
	** open the file and append data to it
	*/
	if(OpenOutputFile(output,"a")){
	    AscWriteOutput(output);
	    ConditionalCloseOutputFile(output);
	}
	break;
    case DELETE:
    case SAVE:
	CloseOutputFile(output);
	break;
    case FLUSH:
	if (output->is_open)
	    fflush(output->fp);
	break;
    default:
	InvalidAction("FileOutput",output,action);
	break;
    }
}

AscWriteOutput(output)
struct ascfile_type *output;
{
FILE *fp;
MsgIn	*msg;
float	fval;

    fp = output->fp;
    if(!output->notime){
	fprintf(fp,"%g ",simulation_time);
    }
    MSGLOOP(output,msg){
	case 0:
	    fval = MsgValue(msg,float,0);
	    fprintf(fp,"%g ",fval);
	    break;
    }
    fprintf(fp,"\n");
    /*
    ** force it to disk if actioned
    */
    if(output->flush)
	fflush(fp);
}

/* Par* functions added by ghood (PSC) */
ParAscFileOutput(output,action)
struct ascfile_type *output;
Action		*action;
{
    switch(action->type){
    case RESET:
	/*
	** set the initialization flag
	*/
	if(!output->append){
	    output->initialize = TRUE;
	}
	break;
    case PROCESS:
	/*
	** has the file been initialized?
	*/
	if(output->initialize){
	    AscSetupFile(output);
	}
	/*
	** open the file and append data to it
	*/
	if(OpenOutputFile(output,"a")){
	    ParAscWriteOutput(output);
	    ConditionalCloseOutputFile(output);
	}
	break;
    case DELETE:
    case SAVE:
	CloseOutputFile(output);
	break;
    case FLUSH:
	if (output->is_open)
	    fflush(output->fp);
	break;
    default:
	InvalidAction("FileOutput",output,action);
	break;
    }
}

ParAscWriteOutput(output)
struct ascfile_type *output;
{
  FILE *fp;
  Msg	*msg;
  int	index;
  int	nvals;
  static float *buffer = NULL;
  static buffer_size = 0;

  fp = output->fp;
  if(!output->notime){
    fprintf(fp,"%g ",simulation_time);
  }
  nvals = 0;
  MSGLOOP(output,msg){
  case 0:
    index = MsgValue(msg, int, 0);
    if (index >= buffer_size)
      {
	if (buffer_size == 0)
	  buffer_size = 16;
	while (index >= buffer_size)
	  buffer_size *= 2;
	buffer = (float *) realloc(buffer, buffer_size*sizeof(float));
      }
    buffer[index] = MsgValue(msg, float, 1);
    if (index >= nvals)
      nvals = index + 1;
	    break;
    }
  for (index = 0; index < nvals; ++index)
    fprintf(fp,"%g ", buffer[index]);
  fprintf(fp,"\n");
  /*
  ** force it to disk if actioned
  */
  if(output->flush)
    fflush(fp);
}

