static char rcsid[] = "$Id: spike_history.c,v 1.1 1997/05/29 08:45:29 dhb Exp $";

/* Reinoud MAEX - UIA-BBF - december 95 */

/*
** $Log: spike_history.c,v $
** Revision 1.1  1997/05/29 08:45:29  dhb
** Initial revision
**
*/

#include "out_ext.h"
#include "out_defs.h"

SpikeHistory(output,action)

struct spikehistory_type *output;
Action		      *action;
{
MsgIn           *msg;
FILE            *fp;
int             index;

    switch(action->type){ /* the RESET, DELETE, SAVE and FLUSH actions are
			  ** copied from AscFileOutput in out_ascfile.c
                          ** the EVENT action is based on synchan.c
                          */
    case RESET: 
	/*
	** set the initialization flag
	*/
	if(!output->append){
	    output->initialize = TRUE;
	}
	break;
    case EVENT:	
        /* 
         * This action is executed when a spike occurs at any of the spikegen 
         * elements which are presynaptic to the spikehistory element.
         */
        /*
         ** has the file been initialized?
	 */
         if(output->initialize){
            AscSetupFile(output);
	 };
        /*
         ** open the file and append data to it
         */
         if(OpenOutputFile(output,"a")){
            fp = output->fp;
            index = 0;
            MSGLOOP(output,msg) 
               {
               case SPIKESAVE :
                 index++;
                 if (msg == (MsgIn*) action->data){ 
	             if (!(output->ident_toggle)) 
                           fprintf (fp, "%5d", index);
                     else  fprintf (fp, "%s", CopyString(Pathname(msg->src)));
                     fprintf (fp, "     %.5g\n", simulation_time);
	         };
                 break;
               };
            if(output->flush)
	       fflush(fp);
            ConditionalCloseOutputFile(output);
         };
         break;
    case SAVE:
	CloseOutputFile(output);  /* in out_ascfile.c */
	break;
/*    case FLUSH:
	if (output->is_open)
	    fflush(output->fp);
	break;

    case DECODE: ** this action could ideally be called from the genesis command 
		 ** line with the output piped to an ascii file
                 **
         index = 0;
         MSGLOOP(output,msg)
          {
           case SPIKESAVE :
             index++;
             printf ("%d    %s\n", index, CopyString(Pathname(msg->src)));
             break;
          };
         break;	   
*/
    default:
	InvalidAction("FileOutput",output,action);
	break;
    }
}



