#include "fsa.h"
#include "transform.h"
#include "color.h"

#define KEYWORDSIZE 	32
#define NAMESIZE 	128
#define LABELSIZE	256
#define	WORDLENGTH	32
#define MYMAXGENS	128		/* MAXGENS appears in fsa.h */

typedef struct {
	int 		attributes;	/* type? fixed points, etc? */
	char 		word[WORDLENGTH]; /* the 'string' in the generators? */
	Transform 	tform;
	ColorA		color;	
	} group_el;
		
typedef struct {
	char 		*name;
	char 		*comment;
	int 		attributes;
	int 		dimn;
	struct fsa	*fsa;
	int		numgens;
	int		numels;
	group_el	*gens;
	group_el	*el_list;
	} group;
		
#define HYPERBOLIC	1
#define EUCLIDEAN	2
#define SPHERICAL	4
#define FINITE		8
#define TRANSPOSED	16

#define NUM_ATTR	5

extern char attr_list[][24];
extern int attr_val[];

extern group *groupalloc();
extern group *read_group();
extern group *fread_group();
extern int fwrite_group();
