/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef INSTPDEFS
#define INSTPDEFS

/*
 * Private definitions for Inst's.
 */

#include "inst.h"
#include "bboxP.h"	/* includes geomclass.h */

#define INSTMAGIC	GeomMagic('i', 3)

#define INST_4D	VERT_4D

#define INSTFIELDS \
  GEOMFIELDS \
  Transform 	axis;		/* this ought to go... */ \
  Geom		*geom; \
  Handle	*geomhandle; \
  Geom		*tlist; \
  Handle	*tlisthandle; \
  Handle	*axishandle; \
  int 		instflag;	/* currently, only bit read is 4D */ \
  int		location;	/* L_LOCAL, etc. */ \
  int		origin;		/* L_NONE, L_LOCAL, etc. */ \
  Point3	originpt;	/* Only if origin != L_NONE */

struct Inst {
  INSTFIELDS
};

extern GeomClass *InstClass;		/* Public read-only; valid only
					 * after first call to InstMethods()
					 */

extern Inst *InstCreate( Inst *exist, GeomClass *Class, va_list attrs );
extern void  InstDelete( Inst * );
extern Inst *InstCopy( Inst * );
extern Inst *InstDice( Inst *, int nu, int nv );

#endif /*INSTPDEFS*/
