#import "EventView.h"

#include "event.h"
#include "drawer.h"
#include "ui.h"
#include "streampool.h"

#import <dpsclient/wraps.h>
#import <libc.h>

#import "GVApp.h" // for int mousedragage

#define WW bounds.size.width
#define H bounds.size.height

@implementation EventView

-initFrame:(const NXRect *)r 
{
  [super initFrame:r];
  [self setAutosizing:NX_WIDTHSIZABLE|NX_HEIGHTSIZABLE];
  return self;
}

- (BOOL)acceptsFirstMouse
{
  return YES;
}
- (BOOL)acceptsFirstResponder
{
  return YES;
}


void sendevent(int dev, int val, NXEvent *ev)
{
  event.x = ev->location.x;
  event.y = ev->location.y;
  event.t = ev->time/.068;
  event.dev = dev; event.val = val;

  button.shift = (ev->flags & NX_SHIFTMASK) ? 1 : 0;
  button.ctrl = (ev->flags & NX_CONTROLMASK) ? 1 : 0;

  gv_rawevent( event.dev, event.val, event.x, event.y, event.t );
}

- mouseDown: (NXEvent *)theEvent
{
  left = 1;
//  if(theEvent->type & NX_RMOUSEDOWNMASK) {
  if(right) {
    button.right = 0;
    sendevent (ERIGHTMOUSE, 0, theEvent);
    button.middle = 1;
    sendevent (EMIDDLEMOUSE, 1, theEvent);
  }
  else {
    if(theEvent->flags & NX_ALTERNATEMASK) {
      button.middle = 1;
      sendevent (EMIDDLEMOUSE, 1, theEvent);
    }
    else if(theEvent->flags & NX_CONTROLMASK) {
      button.right = 1;
      sendevent (ERIGHTMOUSE, 1, theEvent);
    }
    else {
      button.left = 1;
      sendevent (ELEFTMOUSE, 1, theEvent);
    }
  }
  return self;
}

- rightMouseDown: (NXEvent *)theEvent
{
  right = 1;
//  if(theEvent->type & NX_LMOUSEDOWNMASK) {
  if(left) {
    button.left = 0;
    sendevent (ELEFTMOUSE, 0, theEvent);
    button.middle = 1;
    sendevent (EMIDDLEMOUSE, 1, theEvent);
  }
  else {
    button.right = 1;
    sendevent (ERIGHTMOUSE, 1, theEvent);
  }
  return self;
} 

- mouseDragged: (NXEvent *)theEvent
{
  mousedragage=0;
//  if(theEvent->type & NX_RMOUSEDOWNMASK) 
  if(right)
      sendevent (EMIDDLEMOUSE, -1, theEvent);
  else {
    if(theEvent->flags & NX_ALTERNATEMASK) {
      if(button.middle) sendevent (EMIDDLEMOUSE, -1, theEvent);
      else {
        if(button.left) sendevent (ELEFTMOUSE, 0, theEvent);
	else if(button.right) sendevent (ERIGHTMOUSE, 0, theEvent);
        button.left = 0;button.right = 0;button.middle = 1;
        sendevent (EMIDDLEMOUSE, 1, theEvent);
      }
    }
    else if(theEvent->flags & NX_CONTROLMASK) {
      if(button.right) sendevent(ERIGHTMOUSE, -1, theEvent);
      else {
        if(button.left) sendevent (ELEFTMOUSE, 0, theEvent);
	else if(button.middle) sendevent (EMIDDLEMOUSE, 0, theEvent);
        button.left = 0;button.right = 1;button.middle = 0;
        sendevent (ERIGHTMOUSE, 1, theEvent);
      }
    }
    else {
      if(button.left) sendevent(ELEFTMOUSE, -1, theEvent);
      else {
        button.left = 1;button.right = 0;button.middle = 0;
        if(button.right) sendevent (ERIGHTMOUSE, 0, theEvent);
	else if(button.middle) sendevent (EMIDDLEMOUSE, 0, theEvent);
        sendevent (ELEFTMOUSE, 1, theEvent);
      }
    }
  }
  return self;
}

- rightMouseDragged: (NXEvent *)theEvent
{
  mousedragage = 0;
//  if(theEvent->type & NX_RMOUSEDOWNMASK)
  if(left)
      sendevent (EMIDDLEMOUSE, -1, theEvent);
  else sendevent (ERIGHTMOUSE, -1, theEvent);
  return self;
}

- mouseUp: (NXEvent *)theEvent
{
  left = 0;
  if(button.middle) {
    button.middle=0;
    sendevent (EMIDDLEMOUSE, 0, theEvent);
  }
  else if(button.left) {
    button.left=0;
    sendevent (ELEFTMOUSE, 0, theEvent);
  }
  return self;
}

- rightMouseUp: (NXEvent *)theEvent
{
  right = 0;
  if(button.middle) {
    button.middle=0;
    sendevent (EMIDDLEMOUSE, 0, theEvent);
  }
  else if(button.right) {
    button.right=0;
    sendevent (ERIGHTMOUSE, 0, theEvent);
  }
  return self;
}

- drawSelf:(NXRect *)r :(int)count
{
    return self;
}

@end
