/*
 * GeExDir.c
 * author: Brian T. Luense
 * date: August 18, 1994
 */

#include	<tcl.h>
#include	<stdlib.h>
#include	<string.h>
#include	<tk.h>
#include	"geom.h"
#include	"geomclass.h"
#include	"hpointn.h"
#include	"transformn.h"
#include	"GeomExtentDirection.h"

/*The following is C code meant to be compiled with a tcl/tk interpreter to
create two new tcl functions that communicate with Geomview.
The first expects four string arguments: 1. a vector (of dimension no more than 100)
2. The canonical name of a geom,
3. the canonical name of a coordinate system (e.g world, universe, etc.)
4. a boolean operator
It returns the scaled extent of the object in the given direction (considered in
the given coordinate system) in the following manner:
If the object does not exist it returns the string "NoObj"
If it could not figure out the objects extent it returns "Error"
If it encountered no problems it returns a string representation of the maximum and
minimum separated by a space
If the direction and object were of different dimensions it pads the smaller with
0's and returns the maximum and minimum as before except that the string begins with
the word "Pad"
If the boolean was true (i.e 1) then the results are exact.  If it was false (i.e 0)
it returns an approximate answer.


The second function verifies that the currently specified camera is a 
valid camera name*/

int GeomExDir(ClientData clientdata, Tcl_Interp *interp, int argc, char **argv)
{	float *results, *direction;
	Geom *g;
	char str[128], *ptr[100];
	int n=0, dimdir;
	TransformN *t;
	if (argc != 5)
	{	interp->result = "wrong number of args";
		return TCL_ERROR;
	}

/*The following section of code parses the direction which was sent as a
string into an array of floats*/

	ptr[n]=strtok(argv[1]," ");
	while(ptr[n]!=NULL)
	{	n++;
		ptr[n]=strtok(NULL," ");
	}
	dimdir=n;
	direction=(float *)malloc((sizeof *direction)*dimdir);
	for(n=0;n<dimdir;n++)
		direction[n]=atof(ptr[n]);

/*Ask geomview for data on the specified object.  If the object does not
exist return "NoObj"*/

	printf("(if (real-id %s) (write geometry - %s self) (echo \"nada\"))\n",argv[2],argv[2]);
	fflush(stdout);
	g=GeomFLoad(stdin,"stdin");
	if(g==NULL)
	{	interp->result = "NoObj";
		rewind(stdin);
		return TCL_OK;
	}

/*Get the transform that takes the object to the world/universe*/

	printf("(echo(ND-xform-get %s %s))\n",argv[2],argv[3]);
	fflush(stdout);
	t=TmNRead(stdin);

/*Invert the transform so that it takes the world/universe to the object*/

/*	TmNInvert(t,t);*/

/*Get the extent of the object.  If there is a problem return error.
Otherwise, place the results in a string*/

	results = GeomExtentDir(g,t,dimdir,direction,atoi(argv[4]));
	if (results==NULL)
	{	interp->result = "Error";
		return TCL_OK;
	}
	if (results[2]==0.0)
		sprintf(str,"Pad %f %f",results[0],results[1]);
	else
		sprintf(str,"%f %f",results[0],results[1]);
	free(results);
	free(direction);
	interp->result=str;
	return TCL_OK;
}

/*verifies that the currently specified object is a valid object name*/
int ObjExistCheck(ClientData clientdata, Tcl_Interp *interp, int argc, char **argv)
{	char str[200];
	printf("(if (real-id %s) (echo yes\\n) (echo no\\n))\n",argv[1]);
	fflush(stdout);
	scanf("%s",str);
	interp->result=str;
	return TCL_OK;
}
