#include <stdio.h>
#include <string.h>
#include "geom.h"
#include "trigrp.h"

int debug2 = 0;
char *grpnames[] = {"g233","g234","g235","g236","g237"};

char default_group_path[] = "./groups";
char *group_path;
	

die(fmt, p1, p2, p3)
	char *fmt;
	void *p1, *p2, *p3;
{
	fprintf(stderr, "trigrp: ");
	fprintf(stderr, fmt, p1, p2, p3);
	fputc('\n', stderr);
	exit(1);
}

get_group_path()
{
  char *geomdata;
  char grouppath[512];
  extern char *getenv();
  group_path = NULL;
  
  geomdata = getenv("GEOMDATA");
  if (!geomdata)
    die("The GEOMDATA environment variable is not set.");
  if (access(geomdata, 4) < 0)
    die("Problem with GEOMDATA variable: can't find directory \"%s\".",
	geomdata);

  sprintf(grouppath, "%s/groups", getenv("GEOMDATA"));
  group_path = strdup(grouppath);
}

init_groups()
{
	int i;
	char filename[64];
	
	get_group_path();
	/* precompute generators for the 3 platonic groups 233,234, 235 */
	compute_gen();
}

