/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "bboxP.h"

BBox *
BBoxFLoad(FILE *f, char *fname)
{
    BBox b;
    BBox *bbox;
    char *token = GeomToken(f);
    int dim = 3;

    if(*token == '4') {
	dim = 4;
	token++;
    }
    if(strcmp(token, "BBOX"))
	return NULL;

    b.min.w = b.max.w = 1.0;
    if(fgetnf(f, dim, &b.min.x, 0) != dim ||
       fgetnf(f, dim, &b.max.x, 0) != dim) {
      OOGLSyntax(f, "Reading BBOX from \"%s\": expected %d floats", 
		 fname, dim * 2);
      return NULL;
    }

    bbox = OOGLNewE(BBox, "BBoxFLoad BBox");
    *bbox = b;

    GGeomInit(bbox, BBoxMethods(), BBOXMAGIC, NULL);

    if (dim == 4) bbox->geomflags |= VERT_4D;

    return bbox;
}
