#include <stdio.h>
#include "enum.h"
#include "ooglutil.h"
#define CHUNKSIZE 10000

	typedef struct entry {char word[MAXDEPTH]; } entry;
	static entry *stack = NULL, *old, *oldtop, *oldbase, *new;
	static int numchunks = 1;
	/* new points to the next empty space in the stack */
	/* old points to the first non-empty space in the stack */
	
init_stack()
{
	if (stack) OOGLFree(stack);
	stack = OOGLNewN(entry, CHUNKSIZE);
	if (stack == NULL) exit(fprintf(stderr,"init_stack: no space\n"));
	old =  oldbase = new = stack;
	oldtop = stack - 1;
}

make_new_old()
{
	/* oldbase and oldtop are inclusive limits if non-empty words */
	oldbase = oldtop+1;
	old = oldtop = new-1;
}

char *
pop_old_stack()
{
	if (old >= oldbase)	return((old--)->word);
	else return(NULL);
}

push_new_stack(word)
char *word;
{
	entry * oldstack;
	if (new >= stack + numchunks * CHUNKSIZE)	
	    {
	    oldstack = stack;
	    numchunks *= 2;
            if ((stack = OOGLRenewN(entry, stack, numchunks * CHUNKSIZE )) == (entry *) NULL) return (0);
	    new = (entry *) stack + (new - oldstack);
	    old = (entry *) stack + (old - oldstack);
	    oldtop = (entry *) stack + (oldtop - oldstack);
	    oldbase = (entry *) stack + (oldbase - oldstack);
	    if (stack == NULL)
		exit(fprintf(stderr,"push_new_stack: no space\n"));
	    }

 	strcpy(new->word, word);
	new++;
}	

