/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "geomclass.h"

Geom *
GeomPosition( object, T )
    Geom *object;
    Transform T;
{
    if( object && object->Class->position )
	(*object->Class->position)(object,T);
    else
	TmIdentity(T);
    return object;
}

Geom *
GeomTransformTo( object, T )
    Geom *object;
    Transform T;
{
    if( object && object->Class->transformto )
	(*object->Class->transformto)(object,T);
    return object;
}

Geom *
GeomTransform( object, T )
    Geom *object;
    Transform T;
{
    if( object && object->Class->transform )
	(*object->Class->transform)(object,T);
    return object;
}

