/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips,
 * Celeste Fowler */

#include <math.h>
#include "quadP.h"
#include "hpoint3.h"
#include "point3.h"
#include "pickP.h"
#include "appearance.h"


Quad *
QuadPick(Quad *q, Pick *pick, Appearance *ap, Transform T)
{
  Point3 plist[4], *p, got, ep;
  int i, v, e, maxpt;
  float closest;
  int found;
  unsigned int apflag;

  found = -1;

  /* Make sure that vectors do not appear visible to the pick code - 
   * otherwise they will screw up edge picking */
  if (ap != NULL) {
    apflag = ap->flag;
    ap->flag &= ~APF_VECTDRAW;
  }

  for (i = 0; i < q->maxquad; i++) { 
    /* Note "|", not "||" -- we need to be sure that all four are evaluated!! */
    if(HPt3TransPt3(T, &q->p[i][0], &plist[0]) > 0
     | HPt3TransPt3(T, &q->p[i][1], &plist[1]) > 0
     | HPt3TransPt3(T, &q->p[i][2], &plist[2]) > 0
     | HPt3TransPt3(T, &q->p[i][3], &plist[3]) > 0) {

	if(PickFace(4, plist, pick, ap))
	    found = i;
    }
  }

  if (ap != NULL) ap->flag = apflag;
  
  if (found == -1) return NULL;

  if (pick->found & PW_VERT) {
    HPt3Transform(T, &q->p[found][pick->vi], &pick->v);
    pick->vi = found*4 + pick->vi;
  }
  if (pick->found & PW_EDGE) {
    HPt3Transform(T, &q->p[found][pick->ei[0]], &pick->e[0]);
    HPt3Transform(T, &q->p[found][pick->ei[1]], &pick->e[1]);
    pick->ei[0] = found*4 + pick->ei[0];
    pick->ei[1] = found*4 + pick->ei[1];
  }
  if (pick->found & PW_FACE) {
    if(pick->f) OOGLFree(pick->f);
    pick->f = OOGLNewNE(HPoint3, 4, "Quad pick");
    HPt3TransformN(T, q->p[found], pick->f, 4);
    pick->fi = found;
  }

  TmCopy(T, pick->Tprim);

  return q;
}
