% standard plot
eopen('demo8.eps')                      % open eps-file and write eps-head

eglobpar                                % get access to global parameters
etext('Symbols ',eWinWidth/2,eWinHeight-20,10,0)

nSym=6;
edsymbol('s1','oplus.psd',0.5,1,0,0,90)             % define symbol
edsymbol('s2','plus.psd',0.5,0.5,0,0,0,[1 0 0])     % define symbol
edsymbol('s3','rect.psd',0.5,0.8,0,0,0,[0 1 0])     % define symbol
edsymbol('s4','ring.psd',0.5,0.5,0,0,0,[0 0 1])     % define symbol
edsymbol('s5','star.psd',0.5,0.5,0,0,0,[1 1 0])     % define symbol
edsymbol('s6','tria.psd',0.5,0.5,0,0,0,[1 0 1])     % define symbol


nPos=100;
randPos=rand(nPos,2);
randPos(:,1)=randPos(:,1)*eWinWidth;
randPos(:,2)=randPos(:,2)*eWinHeight;

for i=1:nPos
  symbol=sprintf('s%d',rem(i,nSym)+1);
  esymbol(randPos(i,1),randPos(i,2),symbol)      % print symbol
end

eclose                                  % close eps-file
eview                                   % start ghostview with eps-file
