function legend (x, xpos, ypos)

# legend ([status [, xposition [, yposition]])
#
# turns the plot legend status = "off" || "on" == "transparent" || "opaque",
# left top corner legend at position (left)(botton) 0 <= position <= 1 (right)(top)

global __pl __pl_inited

if (!exist("__pl_inited") || plglevel == 0)
	figure(0)
endif

__pl_strm = plgstrm+1;

  if (nargin == 0)
    __pl.legend(__pl_strm) = 1;
    __pl.legend_xpos(__pl_strm) = __pl.legend_ypos(__pl_strm) = 1;
  endif
  
  if (nargin >= 1)
    if (isstr (x))
      if (strcmp ("off", x))
        __pl.legend(__pl_strm) = 0;
      elseif (strcmp ("on", x) || strcmp ("transparent", x))
        __pl.legend(__pl_strm) = 1;
      elseif (strcmp ("opaque", x))
        __pl.legend(__pl_strm) = 2;
      endif
    else
      error ("legend: argument must be a string");
    endif
  endif
  
  if (nargin == 3)
  	__pl.legend_xpos(__pl_strm) = xpos;
  	__pl.legend_ypos(__pl_strm) = ypos;
  endif

endfunction
