/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#include <config.h>
#include <ctype.h>
#include <stdlib.h>
#include "common.h"
#include "error.h"
#include "getline.h"
#include "str.h"
#include "lexer.h"
#include "lexerP.h"

int
cmd_include_at (void)
{
  char *incfn, *s, *bp, *ep;

  s = bp = get_entire_line ();
  while (isspace ((unsigned char) *bp))
    bp++;
  bp++;				/* skip `@' */
  while (isspace ((unsigned char) *bp))
    bp++;
  if (*bp == '\'')
    bp++;

  ep = bp + strlen (bp);
  while (isspace ((unsigned char) *--ep));
  if (*ep != '\'')
    ep++;

  if (ep <= bp)
    return msg (SE, _("Unrecognized filename format."));

  /* Now the filename is trapped between bp and ep. */
  incfn = xmalloc (ep - bp + 1);
  strncpy (incfn, bp, ep - bp);
  incfn[ep - bp] = 0;
  getl_include (incfn);
  free (incfn);

  return 1;
}

int
cmd_include (void)
{
  get_token ();

  force_string ();
  getl_include (tokstr);

  get_token ();
  if (token != '.')
    syntax_error (_("expecting end of command"));

  return 1;
}
