/***************************************************************
LanceMan's quickplot --- a fast interactive 2D plotter

Copyright (C) 1998, 1999  Lance Arsenault

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; version 2
of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Or look at http://www.gnu.org/copyleft/gpl.html .

**********************************************************************/
/* $Id: do_event_loop.c,v 1.3 1999/01/15 02:19:14 lance Exp $ */
#include <stdio.h>
#include <X11/Xlib.h> 
#include <stdlib.h>

#include "data.h"
#include "xwin.h"

extern void show_true_function_values(PlotXwins *win, Plot *plot, int button);
extern void draw_plot(PlotXwins *win, Plot *plot);
extern void draw_rubber_bands(PlotXwins *win, int *x, int *y, 
			      unsigned int *width, unsigned int *height);
extern int zoom_plot(PlotXwins *win, Plot *plot,  int x, int y, 
		      unsigned int width, unsigned int height);
extern void show_function_values(PlotXwins *win, Plot *plot);
extern void show_point_values(PlotXwins *win, Plot *plot);
extern int get_window_size(Display *display, Window window, 
				 unsigned int *width, 
				 unsigned int *height);

void do_plotbuttomPress(PlotXwins *win, Plot *plot, XEvent *report)
{
  int x,y;
  unsigned int width, height;

  switch(report->xbutton.button)
    {
    case Button1:
      if(win->mode & EDIT_MODE)
	{
	  show_true_function_values(win,plot,Button1);
	}
      else
	show_function_values(win,plot);
      break;
    case Button2:
      draw_rubber_bands(win,&x,&y,&width,&height);
      if(zoom_plot(win,plot,x,y,width,height))
	{
	  draw_plot(win,plot);
	}
      break;
    case Button3:
      if(win->mode & EDIT_MODE)
	{
	  show_true_function_values(win,plot,Button3);
	}
      else
	show_point_values(win,plot);
      break; 
    }
}

void do_event_loop(PlotXwins *win, Plot *plot)
{
  XEvent report;
  XtInputMask mask;
  unsigned int width, height;

  while(XCheckWindowEvent(win->display,win->plotwin,
				      ExposureMask,&report));
  /* go */
  while(1)
    {
      XPeekEvent(win->display, &report); /* blocks until an event looked at */

      if(report.xany.window == win->plotwin) /* plot window */
	{ 
	  XNextEvent(win->display,&report); /* blocks until an event is received */

	  switch(report.type)
	    {
	    case Expose:
	      /* remove any remaining redraw events */
	      while(XCheckWindowEvent(win->display,win->plotwin,
				      ExposureMask| StructureNotifyMask,&report));
	      
	      draw_plot(win,plot);
	      break;
	    case ConfigureNotify: /* look for window resize */
	      if(get_window_size(win->display,win->plotwin,&width,&height))
		{
		  /* remove any remaining redraw events */
		  while(XCheckWindowEvent(win->display,win->plotwin,
				      ExposureMask| StructureNotifyMask,&report));
		  
		  draw_plot(win,plot);
		}
	      break;
	    case ButtonPress:
	      do_plotbuttomPress(win,plot,&report);
	      break;
	    }
	}
      else if((mask = XtAppPending(win->context))) /* Xt event */
	{
	  XtAppProcessEvent(win->context, mask);
	}
      else /* other */
	XNextEvent(win->display,&report); /* blocks until an event is received */
    }
}
