/*
 * Copyright 1995,96 Thierry Bousch
 * Licensed under the Gnu Public License, Version 2
 *
 * $Id: Void.c,v 2.5 1996/08/18 09:30:46 bousch Exp $
 *
 * The "Void" type; contains only one mnode (Void_mnode) used to
 * represent an inexistent or invalid result, just like NaN in
 * floating-point libraries.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "saml.h"
#include "mnode.h"
#include "builtin.h"

void (*saml_error_handler)(int,const char*) = saml_default_ehandler;
int saml_errors = 0;

void saml_silent_ehandler (int reason, const char *where)
{
	++saml_errors;
}

void saml_default_ehandler (int reason, const char *where)
{
	++saml_errors;
	fprintf(stderr, "SAML error: %s", saml_strerror(reason));
	if (where && *where)
	  fprintf(stderr, " (%s)", where);
	fputc('\n', stderr);
}

void saml_fatal_ehandler (int reason, const char *where)
{
	saml_default_ehandler(reason, where);
	fprintf(stderr, "Aborting.\n");
	abort();
}

s_mnode* mnode_error (int reason, const char *where)
{
	void_mnode *mn;
	int bytes;

	/* Sanitize arguments */
	if (reason <= 0)
		reason = 1;
	if (!where)
		where = "";

	bytes = sizeof(void_mnode) + strlen(where) + 1;
	mn = (void_mnode*) __mnalloc(ST_VOID, bytes);
	mn->number = reason;
	strcpy(mn->where, where);
	return (s_mnode*) mn;
}

static gr_string* void_stringify (void_mnode *mn)
{
	int reason = mn->number;
	const char *where = mn->where;
	const char *errmsg;
	gr_string *grs = new_gr_string(0);

	if (!reason)
		return grs_append(grs, "void", 4);
	/* Otherwise it's a genuine error */
	grs = grs_append1(grs, '<');
	if (where && *where) {
		grs = grs_append(grs, where, strlen(where));
		grs = grs_append1(grs, ':');
	}
	errmsg = saml_strerror(reason);
	grs = grs_append(grs, errmsg, strlen(errmsg));
	grs = grs_append1(grs, '>');
	return grs;
}

static unsafe_s_mtype MathType_Void = {
	"Void",
	free, NULL, void_stringify,
	NULL, NULL,
	NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL, NULL
};

void init_MathType_Void (void)
{
	register_mtype(ST_VOID, &MathType_Void);
}
