/*
   Scheme In A Grid
   Copyright (C) 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * forminput.c
 */

#include <stdio.h>
#include <string.h>
#include "../siod/siod.h"
#include "../common/cmalloc.h"
#include "../common/common.h"

#define TEXT 1
#define OKBUTTON 2
#define CANCELBUTTON 3
#define MENU 4

#define ANYWHERE 0
#define LEFT 1
#define RIGHT 2

#if 0
typedef struct s_control {
       int type;
       char *name;
       struct s_control *next, *prev;
} control;

static control *c_list;

static void *vert = NULL, *horiz = NULL, *lastw = NULL, *menu = NULL;

static int status;

static LISP form_begin()
{
        vert = NULL, horiz = NULL;
        c_list = NULL;
        return NIL;
}

static LISP form_label(LISP text)
{
        char *label = get_c_string(text);
        return NIL;
}

static control *new_control(int type, char *name)
{
        control *c = (control *)cmalloc(sizeof(control));
        if (!c_list) {
                c_list = c;
                c->next = c;
                c->prev = c;
        } else {
                c->prev = c_list->prev;
                c->next = c_list;
                c_list->prev->next = c;
                c_list->prev = c;
        }
        c->type = type;
        c->name = cstrdup(name);
        return c;
}

static LISP form_text(LISP n)
{
        char *name = get_c_string(n);
        control *c = new_control(TEXT, name);
        return NIL;
}

static LISP form_menu(LISP n)
{
        char *name = get_c_string(n);
        control *c = new_control(MENU, name);

        return NIL;
}

static LISP form_menuentry(LISP n)
{
        char *name = get_c_string(n);
        return NIL;
}

static LISP form_okbutton(LISP text)
{
        char *name = get_c_string(text);
        return NIL;
}

static LISP form_cancelbutton(LISP text)
{
        char *name = get_c_string(text);
        return NIL;
}

static LISP form_property(LISP name, LISP value)
{
        char *n = get_c_string(name);
        char *tv;
        long lv;

        if (!lastw) err("Last widget is NULL", NIL);

        if (FLONUMP(value)) {
                lv = get_c_long(value);
        } else {
                tv = get_c_string(value);
        }

        return NIL;
}

static LISP form_newline()
{
        vert = horiz;
        horiz = NULL;
        return NIL;
}

static LISP form_end()
{
        control *c;
        LISP result;
        /* collect values and free resources */
        result = NIL;
        c = c_list;
        if (!c) return NIL;
        do {
                char *value;
                switch (c->type) {
                case TEXT:
                        break;
                case MENU:
                        break;
                }
                result = cons(cons(strcons(strlen(c->name), c->name),
                                   strcons(strlen(value), value)),
                              result);
                c = c->next;
        } while (c != c_list);
        lastw = NULL;
        if (status == ABORT) return NIL;
        return result;
}

void init_form(void)
{
        init_subr_0("form-begin", form_begin);
        init_subr_1("form-label", form_label);
        init_subr_1("form-text", form_text);
        init_subr_1("form-menu", form_menu);
        init_subr_1("form-menuentry", form_menuentry);
        init_subr_1("form-okbutton", form_okbutton);
        init_subr_1("form-cancelbutton", form_cancelbutton);
        init_subr_2("form-property", form_property);
        init_subr_0("form-newline", form_newline);
        init_subr_0("form-end", form_end);
}
#endif
