    
#include "mathenvironment.h"
#include "lispatom.h"
#include "standard.h"
#include "lispuserfunc.h"
#include "mathuserfunc.h"




LispPtr *MathEnvironment::FindLocal(LispStringPtr aVariable)
{
    Check(iLocals.Get() != NULL,KLispErrInvalidStack);
    Check(iLocals.Get()->SubList() != NULL,KLispErrInvalidStack);

    LispIterator iter(*iLocals.Get()->SubList());
    while (iter() != NULL)
    {
        Check(iter()->SubList() != NULL,KLispErrInvalidStack);
        if (iter()->SubList()->Get()->String() == aVariable)
            return iter.Ptr();

        iter.GoNext();
    }
    return NULL;
}

void MathEnvironment::SetVariable(LispStringPtr aVariable, LispPtr& aValue)
{
    LispPtr *local = FindLocal(aVariable);
    if (local != NULL)
    {
        local->Get()->SubList()->Get()->Next().Set(aValue.Get());
        return;
    }

    iGlobals.SetAssociation(LispGlobalVariable(aValue), aVariable);
}

LispPtr* MathEnvironment::GetVariable(LispStringPtr aVariable)
{
    LispPtr *local = FindLocal(aVariable);
    if (local != NULL)
    {
        return &local->Get()->SubList()->Get()->Next();
    }
    LispGlobalVariable *l = iGlobals.LookUp(aVariable);
    if (l)
    {
        return &l->iValue;
    }
    return NULL;
}

void MathEnvironment::UnsetVariable(LispStringPtr aString)
{
    LispPtr *local = FindLocal(aString);
    if (local != NULL)
    {
        local->Get()->SubList()->Get()->Next().Set(NULL);
        return;
    }
    iGlobals.Release(aString);
}

void MathEnvironment::PushLocalFrame(LispBoolean aFenced)
{
    if (aFenced)
    {
        LispPtr newly;
        newly.Set(LispSubList::New(NULL));
        newly.Get()->Next().Set(iLocals.Get());
        iLocals.Set(newly.Get());
    }
    else
    {
        LISPASSERT(iLocals.Get()!=NULL);
        LISPASSERT(iLocals.Get()->SubList()!=NULL);
        LispPtr newly;
        newly.Set(LispSubList::New(iLocals.Get()->SubList()->Get()));
        newly.Get()->Next().Set(iLocals.Get());
        iLocals.Set(newly.Get());
    }
}

void MathEnvironment::PopLocalFrame()
{
    LISPASSERT(iLocals.Get() != NULL);
    LispPtr next;
    next.Set(iLocals.Get()->Next().Get());
    iLocals.Set(next.Get());
}

void MathEnvironment::NewLocal(LispStringPtr aVariable,LispObject* aValue)
{
    LISPASSERT(iLocals.Get() != NULL);
    LISPASSERT(iLocals.Get()->SubList() != NULL);
    LispPtr newly;
    LispObject* newitem = LispSubList::New(LispAtom::New(aVariable));
    newitem->SubList()->Get()->Next().Set(aValue);
    newitem->Next().Set(iLocals.Get()->SubList()->Get());
    newly.Set(newitem);
//TODO weg?    newly.Get()->Next().Set(iLocals.Get()->SubList()->Get());
    iLocals.Get()->SubList()->Set(newly.Get());
}


LispCommands& MathEnvironment::Commands()
{
    return iCommands;
}

LispHashTable& MathEnvironment::HashTable()
{
    return iHashTable;
}


LispPrinter& MathEnvironment::CurrentPrinter()
{
    return iPrinter;
}

LispDefFiles& MathEnvironment::DefFiles()
{
    return iDefFiles;
}

LispOperators& MathEnvironment::PreFix()
{
    return iPreFixOperators;
}
LispOperators& MathEnvironment::InFix()
{
    return iInFixOperators;
}
LispOperators& MathEnvironment::PostFix()
{
    return iPostFixOperators;
}
LispOperators& MathEnvironment::Bodied()
{
    return iBodiedOperators;
}


LispInput* MathEnvironment::CurrentInput()
{
    return iCurrentInput;
}

void MathEnvironment::SetCurrentInput(LispInput* aInput)
{
    iCurrentInput = aInput;
}

LispOutput* MathEnvironment::CurrentOutput()
{
    return iCurrentOutput;
}

void MathEnvironment::SetCurrentOutput(LispOutput* aOutput)
{
    iCurrentOutput = aOutput;
}



LispUserFunction* MathEnvironment::UserFunction(LispPtr& aArguments)
{
    LispMultiUserFunction* multiUserFunc =
        iUserFunctions.LookUp(aArguments.Get()->String());
    if (multiUserFunc != NULL)
    {
        LispInt arity = InternalListLength(aArguments)-1;
        return  multiUserFunc->UserFunc(arity);
    }
    return NULL;
}


LispUserFunction* MathEnvironment::UserFunction(LispStringPtr aName,LispInt aArity)
{
    LispMultiUserFunction* multiUserFunc = iUserFunctions.LookUp(aName);
    if (multiUserFunc != NULL)
    {
        return  multiUserFunc->UserFunc(aArity);
    }
    return NULL;
}



void MathEnvironment::UnFenceRule(LispStringPtr aOperator,LispInt aArity)
{
    LispMultiUserFunction* multiUserFunc =
        iUserFunctions.LookUp(aOperator);

    Check(multiUserFunc != NULL, KLispErrInvalidArg);
    LispUserFunction* userFunc = multiUserFunc->UserFunc(aArity);
    Check(userFunc != NULL, KLispErrInvalidArg);
    userFunc->UnFence();
}

void MathEnvironment::TryRetract(LispStringPtr aOperator,LispInt aArity)
{
    LispMultiUserFunction* multiUserFunc = iUserFunctions.LookUp(aOperator);
    if (multiUserFunc)
    {
        multiUserFunc->DeleteBase(aArity);
    }
}

void MathEnvironment::DeclareRuleBase(LispStringPtr aOperator, LispPtr& aParameters)
{
    LispMultiUserFunction* multiUserFunc = MultiUserFunction(aOperator);
    // add an operator with this arity to the multiuserfunc.
    multiUserFunc->DefineRuleBase(new BranchingUserFunction(aParameters));


#ifdef LISP_DEBUGHEAP
{
extern long theNrDefinedUser;
theNrDefinedUser++;
}
#endif
}


LispMultiUserFunction* MathEnvironment::MultiUserFunction(LispStringPtr aOperator)
{
    // Find existing multiuser func.
    LispMultiUserFunction* multiUserFunc =
        iUserFunctions.LookUp(aOperator);

    // If none exists, add one to the user functions list
    if (multiUserFunc == NULL)
    {
        LispMultiUserFunction newMulti;
        iUserFunctions.SetAssociation(newMulti, aOperator);
        multiUserFunc =
            iUserFunctions.LookUp(aOperator);
        Check(multiUserFunc != NULL, KLispErrCreatingUserFunction);
    }
    return multiUserFunc;
}






void MathEnvironment::HoldArgument(LispStringPtr  aOperator, LispStringPtr aVariable)
{
    LispMultiUserFunction* multiUserFunc =
        iUserFunctions.LookUp(aOperator);
    Check(multiUserFunc != NULL,KLispErrInvalidArg);
    multiUserFunc->HoldArgument(aVariable);
}


void MathEnvironment::DefineRule(LispStringPtr aOperator,LispInt aArity,
                                 LispInt aPrecedence, LispPtr& aPredicate,
                                 LispPtr& aBody)
{
    // Find existing multiuser func.
    LispMultiUserFunction* multiUserFunc =
        iUserFunctions.LookUp(aOperator);
    Check(multiUserFunc != NULL, KLispErrCreatingRule);

    // Get the specific user function with the right arity
    LispUserFunction* userFunc = multiUserFunc->UserFunc(aArity);
    Check(userFunc != NULL, KLispErrCreatingRule);
    
    // Declare a new evaluation rule
    userFunc->DeclareRule(aPrecedence, aPredicate,aBody);
}


void MathEnvironment::SetUserError(LispCharPtr aErrorString)
{
    theUserError=aErrorString;
}

LispCharPtr MathEnvironment::ErrorString(LispInt aError)
{
    LISPASSERT(aError>=0 && aError < KLispNrErrors);
    switch (aError)
    {
    case KLispErrNone:
        return "No Error";
    case KLispErrInvalidArg:
        return "Invalid argument";
    case KLispErrWrongNumberOfArgs:
        return "Wrong number of arguments";
    case KLispErrNotList:
        return "Argument is not a list";
    case KLispErrListNotLongEnough:
        return "List not long enough";
    case KLispErrInvalidStack:
        return "Invalid stack";
    case KQuitting:
        return "Quitting...";
    case KLispErrNotEnoughMemory:
        return "Not Enough Memory";
    case KInvalidToken:
        return "Empty token during parsing";
    case KLispErrInvalidExpression:
        return "Error parsing expression";
    case KLispErrUnprintableToken:
        return "Unprintable atom";
    case KLispErrFileNotFound:
        return "File Not Found";
    case KLispErrReadingFile:
        return "Error reading file";
    case KLispErrCreatingUserFunction:
        return "Could Not Create User Function";
    case KLispErrCreatingRule:
        return "Could Not Create Rule";
    case KLispErrArityAlreadyDefined:
        return "Rule Base With This Arity Already Defined";
    case KLispErrCommentToEndOfFile:
        return "Reaching end of file within a comment block";
    case KLispErrNotString:
        return "Argument Is Not A String";
    case KLispErrNotInteger:
        return "Argument Is Not A Integer";
    case KLispErrParsingInput:
        return "Error while parsing input";
    case KLispErrMaxRecurseDepthReached:
        return "Max evaluation stack depth reached.\nPlease use MaxEvalDepth to increase the stack size as needed.";
    case KLispErrDefFileAlreadyChosen:
        return "DefFile already chosen for function";
    case KLispErrDivideByZero:
        return "Divide by zero";
    case KLispErrNotAnInFixOperator:
        return "Trying to make a non-infix operator right-associative";
    case KLispErrIsNotInFix:
        return "Trying to get precedence of non-infix operator";
    case KLispErrSecurityBreach:
        return "Trying to perform an insecure action";
    case KLispErrUser:
        if (theUserError != NULL) //TODO should always be true!
            return theUserError;
        break;
    }
    return "Unspecified Error";
}





