/** \file lisptype.h
  * Declarations of types that could become platform-dependent
  */


#ifndef __triagetypes_h__
#define __triagetypes_h__

#include "choices.h"

// Type definitions for the base types
#define PlatChar  char
#define PlatByte  unsigned char
#define PlatInt   int
#define PlatUInt  unsigned int
#define PlatUnsLong unsigned long
#define PlatShort short
#define PlatCharPtr PlatChar *
#define PlatBoolean int
#define PlatLongLong long long
#define PlatDouble double

#define PlatPixel PlatUnsLong
#define PlatMaxDepth 0xffffff

#define PLATEXPORT
#define PLATIMPORT

// Exception handling. At the time of writing this was not yet
// implemented in the same way in several c++ compilers...




#endif

