/*--------------------------------------------------------------*
 *                                                              *
 *         SUFARY --- Suffix Array ΤΥ饤֥       *
 *                                                              *
 *  chfile.c - եγĽ                               *
 *                                                              *
 *--------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef _WIN32
#include <io.h>
#include <process.h>
#endif
#include <fcntl.h>
#include <sys/stat.h>
#include "sufary.h"

/* %%%%% ؿƱΤδط %%%%%
   sa_openfiles() 
   +- sa_opentextfile()
   +- sa_openarrayfile()
   sa_cloasefiles() 
   +- sa_closetextfile()
   +- sa_closearrayfile()
   %%%%%%%%%%%%%%%%%%%%%%%% */

/**********************************************
 *        SUFARY *sa_openfiles(char *s, char *t);
 *
 * purpose
 *   ꤵ줿ƥȥե(s)arrayե(t)򳫤
 *   arrayե̾NULL˻ꤹСƥȥե̾
 *   '.ary' ղäΤarrayե̾ˤʤ롣
 *
 * parameters
 *   t : arrayե̾
 *   s : ƥȥե̾
 *
 * return value
 *   줿SUFARYѿ
 **********************************************/
SUFARY *sa_openfiles(s, t)
    char *s, *t;
{
  SUFARY *newary;
  int tfd, afd;
  char aryname[8192];

  newary = (SUFARY *)calloc(sizeof(SUFARY), 1);
  if (!newary){
    /* ݼ */
    fprintf(stderr,"new array allocation failed.\n");
    exit (1);
    /* return NULL; */
  }

  /* ե̾γǼ 980126 */
  strcpy(newary->filename,s);

  if (t == NULL){ 
    /*  1 : array file ꤵƤʤ */
    if (sa_opentextfile(newary, s) == ERROR){
      /* ץ󥨥顼 */
      free(newary);
      return NULL;
    }
#if 0
    /* ary Υե̾ */
    /* t = malloc(strlen(s) + 4); */
    /* allocaϤδؿǤΤͭmallocư˴롣 */
    aryname = (char *)alloca(strlen(s) + 4);
    if ( aryname == NULL ){
      fprintf(stderr,"array filename allocation failed.\n");
      exit(1);
    }
#endif
    sprintf(aryname, "%s.ary", s); /* (Rel1.4: .pat -> .ary) */
    if (sa_openarrayfile(newary, aryname) == ERROR){
      sa_closetextfile(newary);
      free(newary);
      return NULL;
    }
    /* free(t); */
  } else {
    if (sa_opentextfile(newary, s) == ERROR){
      free(newary);
      return NULL;
    }
    if (sa_openarrayfile(newary, t) == ERROR){
      sa_closetextfile(newary); /* ? */
      free(newary);
      return NULL;
    }
  }
  return newary;
}


/**********************************************
 *        eresult sa_opentextfile(SUFARY *ary,char *s);
 *
 * purpose
 *   ƥȥե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s   : ƥȥե̾
 * 
 * return value
 *    /  (eresult)
 **********************************************/
eresult sa_opentextfile(ary, s)
    SUFARY *ary;
    char *s;
{
  off_t sz;  /* ե륵 */
  struct stat st;
  int fd;
  caddr_t map;
  
  /* ˥ץ󤵤ƤΤХ */
  if (ary->txtfd > 0 || ary->txtmap){
    sa_closetextfile(ary);
  }

  /* եΥץ */
  if ((fd = open(s, O_RDONLY)) < 0){
    printf("cannot open text file '%s'.\n",s);
    return ERROR;
  }

  fstat(fd, &st);
  sz = st.st_size;

#ifdef NO_MMAP
  map = (caddr_t)malloc(sz);
  read(fd, map, sz);
#else
  /* ޥå  use mmap */
  if ((map = mmap((caddr_t)0, sz, PROT_READ, MAP_SHARED, fd, 0))
      == (caddr_t)-1 ){
    printf ("file mapping error. '%s'\n",s);
    return ERROR;
  }
#endif

  /* ΤǥǡǼreturn */
  ary->txtfd  = fd;
  ary->txtsz  = sz;
  ary->txtmap = map;

  return CONT;
}

/**********************************************
 *       eresult sa_openarrayfile(SUFARY *ary, char *s);
 *
 * purpose
 *   Array ե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s : Array ե̾
 *
 * return value
 *    /  (eresult)
 **********************************************/
eresult sa_openarrayfile(ary, s)
    SUFARY *ary;
    char *s;
{
  off_t sz;  /* ե륵 */
  FILE *patfile;
  struct stat st;
  int fd;
  caddr_t map;

  /* ˥ץ󤵤ƤΤХ */
  if (ary->aryfd > 0 || ary->arymap){
    sa_closearrayfile(ary);
  }

  if ((fd = open(s, O_RDONLY)) < 0){
    printf("cannot open array file '%s'.\n",s);
    return ERROR;
  }

  fstat(fd, &st);
  sz = st.st_size;

#ifdef NO_MMAP
  map = (caddr_t)malloc(sz);
  read(fd, map, sz);
#else
  /* ޥå */
  if ((map = mmap((caddr_t)0, sz, PROT_READ, MAP_SHARED, fd, 0))
      == (caddr_t)-1 ){
    printf ("file mapping error. '%s'\n",s);
    return ERROR;
  }
#endif

  /* arrayեΥΤ뤿ν */
  /* Ĥäfdopen()ˤǤʤΤʡ tomoak-i */
  if ((patfile = fopen(s, "r")) == NULL){
    printf("cannot open array file '%s'.\n",s);
    return ERROR;
  }

  fseek(patfile, 0L, 2);
  ary->arraysize = ftell(patfile) / sizeof(long); /* 970715 */

  /* Ĥ */
  fclose(patfile);

  ary->aryfd = fd;
  ary->arysz = sz;
  ary->arymap = ary->aryorig = map;
  ary->left = 0;
  ary->right = ary->arraysize - 1;

  /* left, right ϸϰϤ¦ؤ  980319 */  
  return CONT;
}

/**********************************************
 *       void sa_closefiles(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿եĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 *
 * description
 *   ƥȥեarrayեƱĤ
 **********************************************/
void sa_closefiles(ary)
    SUFARY *ary;
{
  sa_closetextfile(ary);
  sa_closearrayfile(ary);
  free(ary);
  ary = NULL;
  return;
}

/**********************************************
 *        void sa_closetextfile(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿ƥȥեĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
void sa_closetextfile(ary)
    SUFARY *ary;
{
  if (ary->txtfd != -1){
    /* mmap β */
#ifdef NO_MMAP
    free(ary->txtmap);
#else
    munmap(ary->txtmap, ary->txtsz);
#endif
    close(ary->txtfd);
    ary->txtmap = NULL;
    ary->txtfd = -1;
    ary->txtsz = 0;
  }
  return;
}

/**********************************************
 *        void sa_closearrayfile(void);
 *
 * purpose
 *   ꤵ줿arrayեĤ륯
 *
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
void sa_closearrayfile(ary)
    SUFARY *ary;
{
  /* ⡧mmap Ĥɬפ뤫 */
  if (ary->aryfd != -1){
    /* mmap β */
#ifdef NO_MMAP
    free(ary->txtmap);
#else
    munmap(ary->txtmap, ary->txtsz);
#endif
    close(ary->aryfd);
    ary->arymap = NULL;
    ary->aryorig = NULL;
    ary->aryfd = -1;
    ary->arysz = 0;
  }
  ary->arraysize = 0;
  ary->left = 0;
  ary->right = 0;

  return;
}
