/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#define GATOS_SOUND_C 1

#include "gatos.h"
#include "sound.h"
#include "board.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <fcntl.h>

/* ------------------------------------------------------------------------ */
/* Initialization routine */

/* Initialize sound, disable audio ioctl's if any errors */
int sound_init(void) {

  int i ;

  if(gatos.audiotype&1) {
     /* Open mixer device and find cd and line mixer controls */
     gatos.mixerfd = open("/dev/mixer",0) ;
     if (gatos.mixerfd<0) { gatos.audiotype &= 0xfe ; }
     if (gatos.mixerfd>=0) {
        for ( i=0 ; i<SOUND_MIXER_NRDEVICES ; i++ ) {
          if (!strcmp("line",mixer_names[i])) gatos.mixerdev = i ; }
        if (gatos.mixerdev<0) { gatos.audiotype &= 0xfe ; }
     }
     /* Save current mixer settings */
     if(gatos.audiotype&1) {
       if (ioctl(gatos.mixerfd, MIXER_READ(gatos.mixerdev), &gatos.oldvol))
          gatos.audiotype &= 0xfe ;
       gatos_setvolume(gatos.volume);
     }
  }
  if(gatos.audiotype==2) {
     gatos_setvolume(gatos.volume);
  }
     
  RETURN0 ; }

/* ------------------------------------------------------------------------ */
/* Public routines */

int sound_restore(void) {
  if(gatos.audiotype&1) {
    ioctl(gatos.mixerfd, MIXER_WRITE(gatos.mixerdev), &gatos.oldvol) ;
  }
  if(gatos.audiotype&2) {
    /*board_setvol(gatos.oldvol);*/
  }
  RETURN0 ; }

int sound_setvol(int value) {
  if(gatos.audiotype&1) {
    value |= value<<8 ;
    if (ioctl(gatos.mixerfd, MIXER_WRITE(gatos.mixerdev), &value) == -1)
       gatos.audiotype &= 0xfe ;
  }
  if(gatos.audiotype&2) {
    /*board_setvol(value);*/
  }
  RETURN0 ; }

int sound_setmixer(int value) {
  if (!(gatos.audiotype&1)) RETURN0 ;
  if (ioctl(gatos.mixerfd, MIXER_WRITE(gatos.mixerdev),
	&gatos.oldvol) == -1) RETURN(errno) ;
  gatos.mixerdev = value;
  if (ioctl(gatos.mixerfd, MIXER_READ(gatos.mixerdev), &gatos.oldvol))
       gatos.audiotype &= 0xfe ;
  RETURN0 ; }

int sound_nummixers() {
  if (!(gatos.audiotype&1)) RETURN0 ;
  return SOUND_MIXER_NRDEVICES;
  }

char*   sound_mixername(int value) {
  return mixer_names[value];
  }

char**   sound_mixernames() {
  return mixer_names;
  }

