.TH GMTSELECT l "1 November 1999"
.SH NAME
gmtselect \- Select data subsets based on multiple spatial criteria 
.SH SYNOPSIS
\fBgmtselect\fP [ \fIinfiles\fP ] [ \fB\-A\fP\fImin_area\fP[/\fImin_level/max_level\fP] ] 
[ \fB\-C\fP[\fBf\fP]\fIdist/ptfile\fP ] [ \fB\-D\fP\fIresolution\fP ] [ \fB\-F\fP\fIpolygonfile\fP ] 
[ \fB\-H\fP[\fInrec\fP] ] [ \fB\-I\fP[\fBcflrs\fP] ] [ \fB\-J\fP\fIparameters\fP ] 
[ \fB\-L\fP\fIdist/linefile\fP ] [ \fB\-M\fP[\fIflag\fP] ] 
[ \fB\-N\fP\fImaskvalues\fP[\fBo\fP] ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ] 
[ \fB\-V\fP ] [ \fB\-:\fP ] [ \fB\-bi\fP[\fBs\fP][\fIn\fP] ] 
[ \fB\-bo\fP[\fBs\fP] ]
.SH DESCRIPTION
\fBgmtselect\fP is a filter that reads (longitude, latitude) positions from the first 2 columns of \fIinfiles\fP [or standard input] and
uses a combination of 1-5 criteria to pass or reject the records.  Records can be selected based on whether or not they are
1) inside a rectangular region (\fB\-R\fP [and \fB\-J\fP]), 2) within \fIdist\fP km of any point in \fIptfile\fP,
3) within \fIdist\fP km of any line in \fIlinefile\fP, 4) inside one of the polygons in the \fIpolygonfile\fP, and 5) inside geographical features (based on coastlines).
The sense of the tests can be reversed for each of these 5 criteria by using the \fB\-I\fP option.
See option \fB\-:\fP on how to read (latitude,longitude) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfiles\fP
ASCII (or binary, see\fB\-b\fP) data file(s) to be operated on.  If not given, standard input is read.
.SH OPTIONS
.TP
.B \-A
Ignored unless \fB\-N\fP is set.  Geographical features with an area smaller than \fImin_area\fP
in km^2 or of hierarchical level that is lower than \fImin_level\fP or higher than \fImax_level\fP
will be ignored [Default is 0/4 (all features)]. See DATABASE INFORMATION in the \fBpscoast\fP man-pages for more details.
.TP
.B \-C
Pass all records whose location is within \fIdist\fP km of any of the points in \fIptfile\fP.  If \fIdist\fP
is zero then the 3rd column of \fIptfile\fP must have each point's individual radius of influence.  Prepend \fBf\fP to indicate you want approximate flat
earth distance calculations (faster) than exact great circle calculations (slower).
.TP
.B \-D
Ignored unless \fB\-N\fP is set.  Selects the resolution of the coastline data set to use ((\fBf\fP)ull, (\fBh\fP)igh, (\fBi\fP)ntermediate, (\fBl\fP)ow, or (\fBc\fP)rude).  The
resolution drops off by ~80% between data sets. [Default is \fBl\fP].  Note that because the coastlines differ in details is not guaranteed that a point will remain inside [or outside] when a different resolution is selected.
.TP
.B \-F
Pass all records whose location is within one of the closed polygons in the multiple-segment
file \fIpolygonfile\fP.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-I
Reverses the sense of the test for each of the criteria specified:
.br
	\fBc\fP  select records NOT inside any point's circle of influence.
.br
	\fBf\fP  select records NOT inside any of the polygons.
.br
	\fBl\fP  select records NOT within the specified distance of any line.
.br
	\fBr\fP  select records NOT inside the specified rectangular region.
.br
	\fBs\fP  select records NOT considered inside as specified by \fB\-A, \-D, \-N\fP.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/scale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optionally offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-L
Pass all records whose location is within \fIdist\fP km of any of the line segments in the multiple-segment
file \fIlinefile\fP.  If \fIdist\fP is zero then the 2nd column of each sub-header in the \fIptfile\fP must have each lines's individual distance value.
.TP
.B \-M
Multiple segment file.  Segments are separated by a record whose first character is \fIflag\fP.
[Default is '>'].
.TP
.B \-N
Pass all records whose location is inside specified geographical features.
Specify if records should be \fBs\fPkipped or \fBk\fPkept using 1 of 2 formats:
.br
	\fB\-N\fP\fIwet/dry\fP.
.br
	\fB\-N\fP\fIocean/land/lake/island/pond\fP.
.br
Append \fBo\fP to let points exactly on feature boundaries be considered outside the feature [Default is inside]. [Default is s/k/s/k/s (i.e., s/k), which passes all points on dry land].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is double].
Append \fIn\fP for the number of columns in the binary file(s).
[Default is 2 input columns].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is double].
.SH EXAMPLES
To extract the subset of data set that is within 300 km of any of the points in pts.d but more than
100 km away from the lines in lines.d, try
.br
.sp
gmtselect lonlatfile \fB\-C\fP300/pts.d \fB\-L\fP100/lines.d \fB\-Il\fP > subset
.br
.sp
To keep all points in data.d except those on land, as determined by the high-resolution
coastlines, try
.br
.sp
gmtselect data.d \fB\-R\fP120/121/22/24 \fB\-Dh\fP \fB\-Ns\fP/\fBk\fP > subset
.br
.SH RESTRICTIONS
All data are assumed to be in geographical coordinates since great circle distances are calculated.
When working on data in polar regions it may be best to use an appropriate map-projection.  Hence,
when \fB\-J\fP is supplied all comparisons with polygons are done with projected coordinates.
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR gmt (l),
.IR grdlandmask (l),
.IR pscoast (l)
