/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>
#include <fnmatch.h>
#include <string.h>
#include <pthread.h>
#include <signal.h>

#include "data.h"
#include "loadcat.h"
#include "addisk.h"
#include "erreur.h"
#include "waitbox.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

#define READ   0
#define WRITE 1

char *local_foldername;
char *local_diskname;
Folder *local_folder;

pthread_t thread1;

extern GtkWidget *path_entry;

int path_size;

void include_file_in_database(Folder *folder,gchar *file)
{ 
  struct stat fileinfo;
  FILE *f;
  int i;
  char a;
  unsigned long int j;
  char *temp;
  char buff[250];
  int fd[2];
  int b;

  for(i=0;i<nbIncludeData;i++)
    {
      if (fnmatch(IncludeData[i].type,folder->name,(1 << 4)) == 0) 
	{
	  cur_file = folder->name;
	  kill(current_pid,SIGUSR2);
	  
	  if(strlen(IncludeData[i].prog) == 0)
	    {
	      if (stat(file,&fileinfo)  == -1)
		{
		  printf("le stat a echoue\n");
		  fflush(stdout);
		  return;
		}
	      else
		{
		  folder->information = (char *)malloc((fileinfo.st_size + 2)*sizeof(char));
		  if (fileinfo.st_size != 0)
		    {
		      if((f = fopen(file,"r")) == NULL)
			{
			  printf("le fopen a echoue");
			  fflush(stdout);
			}
		      else
			{
			  j = 0;
			  while((a = getc(f)) != EOF)
			    {
			      folder->information[j] = a;
			      j++;
			    }
			  folder->information[j] = '\0';
			  fclose(f);
			}
		    }
		  
		}
	    }
	  else
	    {
	      temp = (char *)malloc(sizeof(char));
	      temp[0] = '\0';
	      if(pipe(fd) == -1)
		{
		  perror("creation du pipe qui chie");
		  return;
		}
	      switch(fork())
		{
		case 0: /*fils1*/
		  close(fd[READ]);
		  close(1);
		  dup(fd[WRITE]);
		  close(fd[WRITE]);
		  if(strlen(IncludeData[i].arg) == 0) execlp(IncludeData[i].prog,IncludeData[i].prog,file+(disk_path_size +1),(char *)0);
		  else execlp(IncludeData[i].prog,IncludeData[i].prog,IncludeData[i].arg,file+(disk_path_size +1),(char *)0);
		  printf("le exec chie\n");
		  fflush(stdout);
		  exit(3);
		case -1:    /*erreur*/
		  printf("Appel qui chie\n");
		  fflush(stdout);
		  exit(3);
		default:
		  close(fd[WRITE]);
		  close(0);
		  dup(fd[READ]);
		  close(fd[READ]);
		  do 
		    {
		      b = read(0,buff,249*sizeof(char));;
		      if(b != 0) 
			{
			  buff[b] = '\0';
			 // printf("%s",buff);
			  temp = (char *)realloc(temp,(strlen(temp)+strlen(buff)+1)*sizeof(char));
			  temp = strcat(temp,buff);
			}
		    } while (b != 0);
		  wait(NULL);
		  folder->information = (char *)malloc((strlen(temp) +1)*sizeof(char));
		  strcpy(folder->information,temp);
		  
		}
	    }
	}
    }
}


void create_folder_tree(Folder *folder,gchar *path)
{
  DIR *dir;
  struct dirent *fichier;
  struct stat fileinfo;
  int i,j,trouve;
  gchar *path2;
  gchar *file;

  folder->nb_folders = 0;
  folder->nb_files = 0;
 
  path2 = g_strconcat(path,folder->name,NULL);
  path2 = g_strconcat(path2,"/",NULL);

  cur_folder = path2+disk_path_size;
  cur_file = NULL;
  kill(current_pid,SIGUSR2);

  if ((dir = opendir(path2)) == NULL)
    {
      printf("ne peut lister le repertoire courant: %s",path2);
      return;
    } 
      
  while((fichier = readdir(dir))!=NULL)
    {
      file = g_strconcat(path2,fichier->d_name,NULL); 
      if ((strcmp(fichier->d_name,".")!=0)&&(strcmp(fichier->d_name,"..")!=0))
	{
	  struct stat fileinfo2;

	  if (stat(file,&fileinfo)  == -1)
	    {
	      printf("fichier introuvable: %s\n",fichier->d_name);
	    } 
	  /* traitement du repertoire trouv */
	  if S_ISDIR(fileinfo.st_mode)
	    {
	      if (folder->nb_folders == 0) 
		{
		  folder->folders = (Folder*) malloc(sizeof(Folder));
		  i = 0;
		}
	      else
		{
		  folder->folders = (Folder*) realloc(folder->folders,(folder->nb_folders+1)*sizeof(Folder));
		  trouve = 0;
		  i = 0;
		  while(trouve == 0)
		    {
		      if (strcmp(fichier->d_name,folder->folders[i].name)<0)
			{
			  for(j=folder->nb_folders;j>i;j--)
			    {
			      folder->folders[j] = folder->folders[j-1];
			    }
			  trouve = 1;
			}
		      else
			{
			  i++;
			  if (i == folder->nb_folders) trouve = 1;
			}
		    }
		}
	      
	      if (lstat(file,&fileinfo2) == -1)
		{
		  printf("fichier introuvable: %s\n",fichier->d_name); 
		}
	      /* si c'est un lien symbolique*/
	      if (S_ISLNK(fileinfo2.st_mode))
		{
		  char tmp[1024];
		  char tmp2[1024];
		  int k;

		  for(k=0;k<1000;k++) tmp[k] = '\0';
		  
		  if (readlink(file,tmp,1023) == -1)
		    {
		      printf("Problem with symbolic link %s, we forget it!\n",file);
		    }
		  else
		    {
		      sprintf(tmp2,"%s -> %s",fichier->d_name,tmp);
		      init_folder(&folder->folders[i],folder,tmp2,0,fileinfo.st_ctime,4);
		      folder->folders[i].folders = (Folder *)malloc(sizeof(folder));
		      folder->folders[i].folders[0].name = (char *)malloc((strlen(tmp) +1)*sizeof(char));
		      strcpy(folder->folders[i].folders[0].name,tmp);
		    }
		}
	      else init_folder(&folder->folders[i],folder,fichier->d_name,0,fileinfo.st_ctime,2);
	      folder->nb_folders++;	
	    }
	  
	  else 
	    {
	      if (folder->nb_files == 0)
		{
		  folder->files = (Folder*) malloc(sizeof(Folder));
		  i = 0;
		}
	      else
		{
		  folder->files = (Folder*) realloc (folder->files,(folder->nb_files+1)*sizeof(Folder));
		  trouve = 0;
		  i = 0;
		  while(trouve == 0)
		    {
		      if (strcmp(fichier->d_name,folder->files[i].name)<0)
			{
			  for(j=folder->nb_files;j>i;j--)
			    {
			      folder->files[j] = folder->files[j-1];
			    }
			  trouve = 1;
			}
		      else
			{
			  i++;
			  if (i == folder->nb_files) trouve = 1;
			}
		    } 
		}
	      init_folder(&folder->files[i],folder,fichier->d_name,fileinfo.st_size,fileinfo.st_ctime,3);
	      //under construction
	      include_file_in_database(&folder->files[i], file);
	      if(folder->files[i].parent != folder)
		{
		  printf("erreur de parent\n");
		  fflush(stdout);
		}
	      folder->nb_files++;
	    }
	}
      
    }
  closedir(dir);
  
  
  if (folder->nb_folders > 0)
    {
      for(i=0;i<folder->nb_folders;i++)
	{
	  if (is_folder(&folder->folders[i]) == 1) create_folder_tree(&folder->folders[i],path2);
	 // else  folder->folders[i].taille = (2 << 30)|(size_mask & folder->folders[i].taille);
	}
    }
}


void *start_thread_scan(void *arg)
{  
  init_folder(local_folder,&racine,local_foldername,0,0,0);
  create_folder_tree(local_folder,"");
  kill(current_pid,SIGUSR1);

  change_name(local_folder,local_diskname);
  
  //racine.folders[i].taille = (int) taille + is_a_disk;
  local_folder->type = 1;//is_a_disk;
  racine.nb_folders++;
  is_modified = 1;
  update_tree();
  pthread_exit(0);
  exit(0);
}

void finish_normal_scan()
{
  void *ret;

 if(pthread_join(thread1,&ret) == 28) printf("pouet\n");
 close_waitbox();
 chdir(getenv("HOME"));
}

int start_add_disk(char *foldername, char* diskname)
{
  int i,j,trouve;
  
  if(foldername[strlen(foldername) -1] == '/') foldername[strlen(foldername) -1] = '\0';
  if (local_foldername != NULL)free(local_foldername);
  local_foldername = (char *)malloc((strlen(foldername) +1)*sizeof(char));
  strcpy(local_foldername,foldername);
  if(local_diskname != NULL)free(local_diskname);
  local_diskname = (char *)malloc((strlen(diskname) +1)*sizeof(char));
  strcpy(local_diskname,diskname);
 
  if (racine.nb_folders == 0) 
    {
      racine.folders = (Folder*) malloc(sizeof(Folder));
      i = 0;
    }
  else
    {
      racine.folders = (Folder*) realloc(racine.folders,(racine.nb_folders+1)*sizeof(Folder));
      trouve = 0;
      i = 0;
      while(trouve == 0)
	{
	  if (strcmp(diskname,racine.folders[i].name)<0)
	    {
	      for(j=racine.nb_folders;j>i;j--)
		{
		  racine.folders[j] = racine.folders[j-1];
		}
	      trouve = 1;
	    }
	  else
	    {
	      i++;
	      if (i == racine.nb_folders) trouve = 1;
	    }
	}
    }
  /*Pour que le tar soit supporte, il ne faut pas qu'on change de disque dans le path (path relatif obligatoire)*/
  disk_path_size = strlen(foldername);
  chdir(foldername);
  local_folder = &racine.folders[i];
  /*************/
  signal(SIGUSR2,update_waitbox);
  if(pthread_create(&thread1, NULL,start_thread_scan ,NULL ) <0)
    {
      erreur_dialog(NULL, "Thread failed", "Check your number of threads.", "ERROR !");
      return(0);
    }  
  signal(SIGUSR1,finish_normal_scan);
  open_waitbox();
  return(0);
}


