/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>
#include <fnmatch.h>

#include "data.h"
#include "savecat.h"
#include "erreur.h"

extern GtkWidget *filew;

typedef struct {
  unsigned char type;//donne l'info sur le type de l'objet. Cela remplace les deux derniers bit de la taille
  unsigned long int taille;//2 derniers bits: type d'objet 00 racine, 01 disque, 10 repertoire, 11 fichier et bien d'autres combinaisons!
  unsigned long int date;// code en time_t
  unsigned char categorie;
  unsigned short int description;
} Donnees;


Donnees data;
FILE *catalog;
int j;



static gint 
save_compressed_image (char   *filename)
{
  FILE* f;
 
  int pid;
  int status;

  if ((pid = fork()) < 0)
    {
      g_message ("fork failed: %s\n", g_strerror(errno));
      erreur_dialog(filew,"fork failed:",g_strerror(errno),"ERROR!");
      return -1;
    }
  else if (pid == 0)
    {

      if (!(f = fopen(filename,"w")))
	{
	  g_message("fopen failed: %s\n", g_strerror(errno));
	  erreur_dialog(filew,"fopen failed:",g_strerror(errno),"ERROR!");
	  _exit(127);
	}

      if (-1 == dup2(fileno(f),fileno(stdout)))
	g_message ("dup2 failed: %s\n", g_strerror(errno));

      if (fnmatch("*.gz",filename,0) == 0) execlp("gzip", "gzip", "-cf", "/tmp/gtktalogtmpfile", NULL);
      if (fnmatch("*.bz2",filename,0) == 0) execlp("bzip2", "bzip2", "-cf","/tmp/gtktalogtmpfile", NULL);
      if (fnmatch("*.gz",filename,0) == 0)
	{
	  g_message ("gzip: exec failed: %s\n", g_strerror(errno));
	  erreur_dialog(filew,"gzip: exec failed:",g_strerror(errno),"ERROR!");
	}
      if (fnmatch("*.bz2",filename,0) == 0)
	{
	  g_message ("bzip2: exec failed: %s\n", g_strerror(errno));
	  erreur_dialog(filew,"bzip2: exec failed:",g_strerror(errno),"ERROR!");
	}
      _exit(127);
    }
  else
    {
      waitpid (pid, &status, 0);

      if (!WIFEXITED(status) ||
	  WEXITSTATUS(status) != 0)
	{
	   if (fnmatch("*.gz",filename,0) == 0)
	     {
	       g_message ("gz: gzip exited abnormally on file %s\n","/tmp/gtktalogtmpfile" );
	       erreur_dialog(filew,"gz: gzip exited abnormally on file","/tmp/gtktalogtmpfile","ERROR!");
	     }
	   if (fnmatch("*.bz2",filename,0) == 0)
	     {
	       g_message ("bz2: bzip2 exited abnormally on file %s\n","/tmp/gtktalogtmpfile" );
	       erreur_dialog(filew,"bz2: bzip2 exited abnormally on file","/tmp/gtktalogtmpfile","ERROR!");
	     }
	  return -1;
	}
    }

  unlink ("/tmp/gtktalogtmpfile");

  return 0;
}





void print_folder_tree(Folder *folder)
{
  int i;
  char debfold = 2;
  char finfold = 12;
  char debfile = 3;
//  char deb_filedata = 13;
  //int k;
  unsigned long int l;
  //unsigned long int tmp;
  
  fprintf(catalog,"%s\n",folder->name);
  data.taille = folder->taille;
  data.type = folder->type;
  data.date = folder->date;
  data.categorie = folder->categorie;
  data.description = folder->description;
  if((folder->information != NULL)&&(strlen(folder->information) != 0))
    {
      data.type = data.type|(1<<7);
      fwrite(&data,sizeof(Donnees),1,catalog);
      l = strlen(folder->information);
      fwrite(&l,sizeof(unsigned long int),1,catalog);
      fwrite(folder->information,l*sizeof(char),1,catalog);
    }
  else
    {
      data.type = data.type & 127;
      fwrite(&data,sizeof(Donnees),1,catalog);
    }

  
  //under construction
  /* if ((is_file(folder) == 1)&&((folder->nb_files == 1)&&(((folder->files[0].taille & (1<<30)) != 0)&&((folder->files[0].taille & (1<<31)) == 0)))) 
	    {
	     // tmp = strlen(folder->files[0].name);
	      fputc(deb_filedata,catalog);
	      // fwrite(&tmp,sizeof(unsigned long int),1,catalog);
	      fwrite(&folder->files[0].name,tmp*sizeof(char),1,catalog);
	      fputc(deb_filedata,catalog);
 	      return;
	    }
	  
	  //      fputc('\n',catalog);*/


  if ((j == 1)&&(is_link(folder) == 1))
    {
      fprintf(catalog,"%s\n",folder->folders[0].name);
    }
  else
    {
      if (j == 0) j = 1;
      for(i=0;i<folder->nb_folders;i++)
	{
	  fputc(debfold,catalog);
	  print_folder_tree(&folder->folders[i]);
	  if((j != 1)||(is_link(&folder->folders[i]) == 0))//ne pas fermer si c'est un link!!!!!
	    {
	      fputc(finfold,catalog);
	      fputc('\n',catalog);
	    }
	}
      
      for(i=0;i<folder->nb_files;i++)
	{
	  fputc(debfile,catalog);
	  print_folder_tree(&folder->files[i]);
	}
    }
}


int save_cat_to_file(char *filename)
{
  int i;
  char nb_cat = 0;
  char nb_desc = 1;
  char fin_info = 10;

  j = 0;
  if ((fnmatch("*.gz",filename,0) == 0)||(fnmatch("*.bz2",filename,0) == 0))
    {
      if ((catalog = fopen("/tmp/gtktalogtmpfile","w+")) == NULL)
	{
	  return(-1);
	}
    }
  else if ((catalog = fopen(filename,"w+")) == NULL)
    {
      return(-1);
    }
  fprintf(catalog,"gtktalog2\n");
  for(i=1;i<nb_categories;i++)
    {
      fputc(nb_cat,catalog);
      fprintf(catalog,"%s\n",categories[i]);
    }
  for(i=1;i<nb_descriptions;i++)
    {
      fputc(nb_desc,catalog);
      fprintf(catalog,"%s\n",descriptions[i]);
    }
  fputc(fin_info,catalog);
//  fputc('\n',catalog);
  racine.name = g_strdup("Start!");
  print_folder_tree(&racine);
  fclose(catalog);
  if ((fnmatch("*.gz",filename,0) == 0)||(fnmatch("*.bz2",filename,0) == 0)) if(save_compressed_image(filename) == -1) return -1;
  is_modified = 0;
  return(0);
}
