/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "data.h"
#include "text.h"

Folder *localFolder;

gint dumy_text_event( GtkWidget *widget, GdkEvent  *event, gpointer   data )
{
  //on evite juste que la fentre soit ferme en renvoyant TRUE.
    return(TRUE);
}
 

void close_text( GtkWidget *widget, gpointer data )
{
       gtk_widget_destroy(data);
       text_box_is_open = 0;
}



void display_file (Folder *file)
{
  GtkWidget *text_window;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *table;
  GtkWidget *vscrollbar;
//  GdkColormap *cmap;
//  GdkColor colour;
 
 
  text_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (text_window, 400, 250);
  gtk_window_set_policy (GTK_WINDOW(text_window), TRUE, TRUE, FALSE);  
 /* gtk_signal_connect (GTK_OBJECT (text_window), "destroy",
		      GTK_SIGNAL_FUNC(close_application),
		      NULL);*/
  gtk_window_set_title (GTK_WINDOW (text_window), "File Informations");
  gtk_container_set_border_width (GTK_CONTAINER (text_window), 0);
  gtk_signal_connect (GTK_OBJECT (text_window), "delete_event",
			  GTK_SIGNAL_FUNC (dumy_text_event), NULL);
  
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (text_window), box1);
  gtk_widget_show (box1);
  
  
  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 3);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
  gtk_widget_show (box2);
  
  
  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
  gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
  gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
  gtk_widget_show (table);
  
  /* Create the GtkText widget */
  read_text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (read_text), TRUE);
  gtk_table_attach (GTK_TABLE (table), read_text, 0, 1, 0, 1,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (read_text);

  /* Add a vertical scrollbar to the GtkText widget */
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (read_text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);

  /* Load a fixed font */
  //fixed_font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");
  fixed_font = gdk_font_load ("-misc-terminal-medium-r-*-*-*-140-*-*-*-*-*-*");

  /* Realizing a widget creates a window for it, ready for us to insert some text */
  gtk_widget_realize (read_text);

  /* Freeze the text widget, ready for multiple updates */
  gtk_text_freeze (GTK_TEXT (read_text));
  

  /* Load the file text.c into the text window */

   if ( file->information != NULL) gtk_text_insert (GTK_TEXT (read_text), fixed_font, NULL,
		   NULL, file->information, strlen(file->information));

  /* Thaw the text widget, allowing the updates to become visible */  
  gtk_text_thaw (GTK_TEXT (read_text));

  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 0);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
  gtk_widget_show (box2);
  
  button = gtk_button_new_with_label ("close");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(close_text),
		      text_window);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  gtk_text_set_editable(GTK_TEXT(read_text),FALSE);
  gtk_text_set_word_wrap(GTK_TEXT(read_text),FALSE); 
  gtk_widget_show (text_window);
      
  text_box_is_open = 1;
}



void info_ok_clicked( GtkWidget *widget, info_data *data)
{
  guint taille;
  gchar *text;
  
  taille = gtk_text_get_length (GTK_TEXT(data->text));
  free(data->file->information);
  data->file->information = (char *)malloc((taille +1)*sizeof(char));
  text = gtk_editable_get_chars(GTK_EDITABLE(data->text),0,taille); 
  strcpy(data->file->information,text);
  gtk_widget_destroy(data->window);
}



void info_cancel_clicked( GtkWidget *widget, info_data *data )
{
       gtk_widget_destroy(data->window);
}



void edit_file_informations (GtkWidget *w)
{
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *button;
  GtkWidget *button2;
  GtkWidget *table;
  GtkWidget *vscrollbar;
//  GdkColormap *cmap;
//  GdkColor colour;
  info_data *data;
 
  
  data = (info_data *)malloc(sizeof(info_data));
  data->file = selected_folder;

  data->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (data->window, 400, 250);
  gtk_window_set_policy (GTK_WINDOW(data->window), TRUE, TRUE, FALSE);  
 /* gtk_signal_connect (GTK_OBJECT (data->window), "destroy",
		      GTK_SIGNAL_FUNC(close_application),
		      NULL);*/
  gtk_window_set_title (GTK_WINDOW (data->window), "Edit file Informations");
  gtk_container_set_border_width (GTK_CONTAINER (data->window), 0);
  gtk_signal_connect (GTK_OBJECT (data->window), "delete_event",
			  GTK_SIGNAL_FUNC (dumy_text_event), NULL);
  
  box1 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (data->window), box1);
  gtk_widget_show (box1);
  
  
  box2 = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 3);
  gtk_box_pack_start (GTK_BOX (box1), box2, TRUE, TRUE, 0);
  gtk_widget_show (box2);
  
  
  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
  gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
  gtk_box_pack_start (GTK_BOX (box2), table, TRUE, TRUE, 0);
  gtk_widget_show (table);
  
  /* Create the GtkText widget */
  data->text = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (data->text), TRUE);
  gtk_table_attach (GTK_TABLE (table), data->text, 0, 1, 0, 1,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		    GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (data->text);

  /* Add a vertical scrollbar to the GtkText widget */
  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (data->text)->vadj);
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);

  /* Load a fixed font */
  //fixed_font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");
  fixed_font = gdk_font_load ("-misc-terminal-medium-r-*-*-*-140-*-*-*-*-*-*");

  /* Realizing a widget creates a window for it, ready for us to insert some text */
  gtk_widget_realize (data->text);

  /* Freeze the text widget, ready for multiple updates */
  gtk_text_freeze (GTK_TEXT (data->text));
  

  /* Load the file text.c into the text window */

  if ( data->file->information != NULL) gtk_text_insert (GTK_TEXT (data->text), fixed_font, NULL,
		   NULL, data->file->information, strlen(data->file->information));

  /* Thaw the text widget, allowing the updates to become visible */  
  gtk_text_thaw (GTK_TEXT (data->text));

  box2 = gtk_hbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (box2), 0);
  gtk_box_pack_start (GTK_BOX (box1), box2, FALSE, TRUE, 0);
  gtk_widget_show (box2);
  
  button = gtk_button_new_with_label ("Ok");
  gtk_signal_connect (GTK_OBJECT (button), "clicked",
		      GTK_SIGNAL_FUNC(info_ok_clicked),
		      (gpointer)data);
  gtk_box_pack_start (GTK_BOX (box2), button, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default (button);
  gtk_widget_show (button);

  button2 = gtk_button_new_with_label ("Cancel");
  gtk_signal_connect (GTK_OBJECT (button2), "clicked",
		      GTK_SIGNAL_FUNC(info_cancel_clicked),
		      (gpointer)data);
  gtk_box_pack_start (GTK_BOX (box2), button2, TRUE, TRUE, 0);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
  gtk_widget_show (button2);

  gtk_text_set_editable(GTK_TEXT(data->text),TRUE);
  gtk_text_set_word_wrap(GTK_TEXT(data->text),FALSE); 
  gtk_widget_show (data->window);
      
}
