/*  GTKtalog.
 *  Copyright (C) 1999  Mathieu VILLEGAS
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <signal.h>
#include "waitbox.h"

#ifdef LIBC5
#define SIGUSR1 SIGSTKFLT
#define SIGUSR2 SIGUNUSED
#endif

GtkWidget *waitbox;
GtkWidget *folder_label;
GtkWidget *file_label;

gint dumy_event( GtkWidget *widget, GdkEvent  *event, gpointer   data )
{
  //on evite juste que la fentre soit ferme en renvoyant TRUE.
    return(TRUE);
}

void close_waitbox()
{
  gtk_grab_remove(waitbox);
  gtk_widget_destroy(waitbox);
  waitbox_is_open = 0;
}

void update_waitbox()
{
  if(waitbox_is_open == 1)
    {
      gtk_label_set_text (GTK_LABEL(folder_label),cur_folder);
      
      if(cur_file == NULL) gtk_label_set_text (GTK_LABEL(file_label),"");
      else gtk_label_set_text (GTK_LABEL(file_label),cur_file);
    }
}


void open_waitbox()
{
  GtkWidget *frame;
  GtkWidget *vbox;
  GtkWidget *hbox; 
  
  if(waitbox_is_open  == -1) waitbox_is_open = 0;
  else
    {
      waitbox = gtk_window_new(GTK_WINDOW_DIALOG);
      gtk_window_set_title(GTK_WINDOW(waitbox),"Disk scan in progress ...");
      gtk_widget_set_usize(waitbox,250,100);
      gtk_container_border_width (GTK_CONTAINER (waitbox), 0);
      gtk_window_set_policy(GTK_WINDOW(waitbox), FALSE, FALSE, TRUE);
      gtk_window_set_position (GTK_WINDOW (waitbox), GTK_WIN_POS_MOUSE);
      gtk_grab_add(waitbox);
      gtk_widget_show (waitbox);
      gtk_container_border_width(GTK_CONTAINER(waitbox),10);
      gtk_signal_connect (GTK_OBJECT (waitbox), "delete_event",
			  GTK_SIGNAL_FUNC (dumy_event), NULL);
      
      vbox = gtk_vbox_new(FALSE,4);
      gtk_container_add( GTK_CONTAINER(waitbox),vbox);
      gtk_widget_show(vbox);
      
      
      frame = gtk_frame_new(NULL);
      gtk_frame_set_label( GTK_FRAME(frame), "Intering folder:" );
      gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
      gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
      gtk_widget_show(frame);
      
      hbox = gtk_hbox_new(FALSE,4);
      gtk_container_add( GTK_CONTAINER(frame),hbox);
      gtk_widget_show(hbox);
      
      folder_label = gtk_label_new("");
      // gtk_container_add(GTK_CONTAINER (frame), folder_label);
      gtk_box_pack_start (GTK_BOX (hbox), folder_label, TRUE, TRUE, 0);
      gtk_widget_show(folder_label);
      
      
      frame = gtk_frame_new(NULL);
      gtk_frame_set_label( GTK_FRAME(frame), "Scanning file:" );
      gtk_frame_set_label_align( GTK_FRAME(frame), 0.0, 0.0);
      gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
      gtk_box_pack_start (GTK_BOX (vbox), frame, FALSE, FALSE, 0);
      gtk_widget_show(frame);
      
      hbox = gtk_hbox_new(FALSE,4);
      gtk_container_add( GTK_CONTAINER(frame),hbox);
      gtk_widget_show(hbox);
      
      file_label = gtk_label_new("");
      // gtk_container_add(GTK_CONTAINER (frame), file_label);
      gtk_box_pack_start (GTK_BOX (hbox), file_label, TRUE, TRUE, 0);
      gtk_widget_show(file_label);
      
      waitbox_is_open = 1;
    }
}
