/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __BEZERK_H__
#define __BEZERK_H__

#include <gtk/gtk.h>
#include "reply.h"
#include "config.h"

#define BEZ_CHECK_CAST(obj, cast)      ((cast *) (obj))

#define BUFFLEN 520

typedef enum
{
  BEZ_CHANNEL,
  BEZ_MESSAGE
} BezWindowType;

typedef struct _BezBaseWindow
{
  BezWindowType type;
  GtkWidget *window;
  GtkWidget *text;
  guint numlines;
  GtkWidget *entry;
  struct _Connection *connection;
  struct _MenuBar *menu_bar;
  GList *recall_commands;
  GList *recall_current;
  char *incomplete_command;
} BezBaseWindow;

typedef struct _Toolbar
{
  GtkWidget *toolbar;
  GtkWidget *combo;
} Toolbar;
  
typedef struct _BezChannelWindow
{
  BezWindowType type;
  GtkWidget *window;
  GtkWidget *text;
  guint numlines;
  GtkWidget *entry;
  struct _Connection *connection;
  struct _MenuBar *menu_bar;
  GList *recall_commands;
  GList *recall_current;
  char *incomplete_command;

  struct _Toolbar *toolbar;
  GtkWidget *ch_clist;
  GtkWidget *nick_clist;
  int selected_row;
  GtkWidget *notify_clist;
  GtkWidget *user_status;
  GtkWidget *channel_status;
  struct _ChannelInfo *current_channel;
} BezChannelWindow;

typedef enum {
  DCC_CHAT,
  IRC_MSG
} BezMessageType;

typedef struct _BezMessageWindow
{
  BezWindowType type;
  GtkWidget *window;
  GtkWidget *text;
  guint numlines;
  GtkWidget *entry;
  struct _Connection *connection;
  struct _MenuBar *menu_bar;
  GList *recall_commands;
  GList *recall_current;
  char *incomplete_command;

  char *nick;
  GtkWidget *status;
  BezMessageType message_type;
} BezMessageWindow;

typedef union _BezWindow
{
  BezWindowType type;
  BezBaseWindow base;
  BezChannelWindow channel;
  BezMessageWindow message;
} BezWindow;

#define BEZ_WINDOW(obj)             BEZ_CHECK_CAST(obj, BezWindow)
#define BEZ_BASE_WINDOW(obj)        BEZ_CHECK_CAST(obj, BezBaseWindow)
#define BEZ_CHANNEL_WINDOW(obj)     BEZ_CHECK_CAST(obj, BezChannelWindow)
#define BEZ_MESSAGE_WINDOW(obj)     BEZ_CHECK_CAST(obj, BezMessageWindow)

#define IS_BEZ_CHANNEL_WINDOW(obj)  (obj->type == BEZ_CHANNEL)
#define IS_BEZ_MESSAGE_WINDOW(obj)  (obj->type == BEZ_MESSAGE)
#define IS_BEZ_WINDOW(obj)          (IS_BEZ_CHANNEL_WINDOW(obj) || IS_BEZ_MESSAGE_WINDOW(obj))

#define OKAY   0
#define NOTREG 1
#define AWAY   2

BezWindow *create_channel_window(char *title, gint top_level);
BezWindow *create_message_window(BezMessageType type, char *nick);

#endif /* __BEZERK_H__ */
