/* Bezerk
 * Copyright (C) 1998 Tony Gale.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
 
#ifndef __IRC_H__
#define __IRC_H__

int irc_init();
int irc_connect(char *hostname, unsigned port);
void irc_disconnect(int server_sd);
void irc_cmd_user(int server_sd, char *nick, char *name);
int irc_parse_command(char *buff);
void irc_clear_message();
int irc_process_message();
void irc_send_format(int server_sd, char *format, ...);
void irc_send_message(int server_sd, char *message);

/* Max length of an IRC command string is 512 bytes */
#define BUFFLEN 520
#define MAXARGS 15
#define MODELEN 20

typedef struct MessageData {
  unsigned type;
  char *command;
  int number;
  char *nick;
  char *address;
  char *args[MAXARGS];
}messageData;

typedef struct MessageInfo {
  unsigned type;
  char *text;
}messageInfo;

#define ERR_BADNICK -5
#define ERR_NOTREG -4
#define ERR_NOTCONN -3
#define ERR_FATAL -2
#define ERR_GENERAL -1
#define MSG_NUMERIC 1
#define MSG_COMMAND 2
#define MSG_ERROR 3
#define MSG_REPLY 4
#define MSG_INFO 5

#endif /* __IRC_H__ */

