/*
 * Copyright (C) 1998  Mark Baysinger (mbaysing@ucsd.edu)
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include "config.h"
#include "setup.h"
#include <stdio.h>
#include <stddef.h>
#ifdef STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# endif
#endif
#ifdef HAVE_STRING_H
# include <string.h>
#else
# ifdef HAVE_STRINGS_H
#  include <strings.h>
# endif
#endif
#include "util.h"


extern int strstart(char const * full, char const * part)
{
    if (strlen(full)<strlen(part))
	return 1;
    /* If there is more than the command, make sure it is separated */
    if (strlen(full)>strlen(part) && full[strlen(part)]!=' ' && full[strlen(part)]!='\0')
        return 1;
    return strncasecmp(full,part,strlen(part));
}


#define DEF_LEN 64
#define INC_LEN 16

extern char * file_get_line(FILE * fp)
{
    char *       line;
    unsigned int len=DEF_LEN;
    unsigned int pos=0;
    int          temp;
    
    if (!(line = malloc(DEF_LEN)))
	return NULL;
    
    while ((temp=fgetc(fp))!=EOF)
    {
	if (((char)temp)=='\n')
	    break;
	line[pos++] = (char)temp;
	if ((pos+1)>=len)
	{
	    char * newline;
	    
	    len += INC_LEN;
	    if (!(newline = realloc(line,len)))
	    {
		pfree(line,len-INC_LEN);
		return NULL;
	    }
	    line = newline;
	}
    }
    
    if (temp==EOF && pos<1)
    {
	pfree(line,len);
	return NULL;
    }
    
    line[pos] = '\0';
    
    return line;
}


extern char * strreverse(char * str)
{
    unsigned int i;
    unsigned int len;
    char         temp;
    
    if (!str)
	return NULL;
    
    len = strlen(str);
    
    /* swap leftmost and rightmost chars until we hit center */
    for (i=0; i<len/2; i++)
    {
	temp         = str[i];
	str[i]       = str[len-1-i];
	str[len-1-i] = temp;
    }
    
    return str;
}


extern int str_to_uint(char const * str, unsigned int * num)
{
    unsigned int pos;
    unsigned int i;
    unsigned int val;
    unsigned int pval;
    
    if (!str || !num)
        return -1;
    for (pos=0; str[pos]==' ' || str[pos]=='\t'; pos++);
    if (str[pos]=='+')
        pos++;
    
    val = 0;
    for (i=pos; str[i]!='\0'; i++)
    {
	pval = val;
        val *= 10;
	if (val/10!=pval) /* check for overflow */
	    return -1;
	
	pval = val;
	switch (str[i])
	{
	case '0':
	    break;
	case '1':
	    val += 1;
	    break;
	case '2':
	    val += 2;
	    break;
	case '3':
	    val += 3;
	    break;
	case '4':
	    val += 4;
	    break;
	case '5':
	    val += 5;
	    break;
	case '6':
	    val += 6;
	    break;
	case '7':
	    val += 7;
	    break;
	case '8':
	    val += 8;
	    break;
	case '9':
	    val += 9;
	    break;
	default:
	    return -1;
	}
	if (val<pval) /* check for overflow */
	    return -1;
    }
    
    *num = val;
    return 0;
}


extern int str_to_ushort(char const * str, unsigned short * num)
{
    unsigned int   pos;
    unsigned int   i;
    unsigned short val;
    unsigned short pval;
    
    if (!str || !num)
        return -1;
    for (pos=0; str[pos]==' ' || str[pos]=='\t'; pos++);
    if (str[pos]=='+')
        pos++;
    
    val = 0;
    for (i=pos; str[i]!='\0'; i++)
    {
	pval = val;
        val *= 10;
	if (val/10!=pval) /* check for overflow */
	    return -1;
	
	pval = val;
	switch (str[i])
	{
	case '0':
	    break;
	case '1':
	    val += 1;
	    break;
	case '2':
	    val += 2;
	    break;
	case '3':
	    val += 3;
	    break;
	case '4':
	    val += 4;
	    break;
	case '5':
	    val += 5;
	    break;
	case '6':
	    val += 6;
	    break;
	case '7':
	    val += 7;
	    break;
	case '8':
	    val += 8;
	    break;
	case '9':
	    val += 9;
	    break;
	default:
	    return -1;
	}
	if (val<pval) /* check for overflow */
	    return -1;
    }
    
    *num = val;
    return 0;
}


/* This routine assumes ASCII like control chars
   if len is zero, it will print all characters up to the first NUL,
   otherwise it will print exactly that many characters */
int str_print_term(FILE * fp, char const * str, unsigned int len, int allow_nl)
{
    unsigned int i;
    
    if (!fp)
	return -1;
    if (!str)
	return -1;
    
    if (len==0)
	len = strlen(str);
    for (i=0; i<len; i++)
	if (str[i]>='\000' && str[i]<'\040' && (!allow_nl || (str[i]!='\r' && str[i]!='\n')))
	    fprintf(fp,"^%c",str[i]+64);
	else
	    fputc((int)str[i],fp);
    
    return 0;
}
