#ifndef COMMANDS_H
#define COMMANDS_H

#include <stdio.h>  // for printf() etc.
#include <getopt.h> // for getopt()
#include <stdlib.h> // for atoi()
#include <string.h>	// for strerror()
#include <unistd.h> // for write()
#include <errno.h>  // for errno
#include <stdarg.h> // for varargs
#include <pwd.h>	// for getpass()
#include <ctype.h>
#include <dirent.h>
#include <sys/stat.h>
#include <time.h>
#include <readline/readline.h>
#include <readline/history.h>

#include <darxite.h>

int DaemonWrite(BOOL show_response, const char *string, ...);
int GetResponse(BOOL show_response);
BOOL OpenUrl(char *url, BOOL anon_login);
void LocalLs(const char *path, BOOL verbose, BOOL show_hidden);
void RemoteLs(const char *path, const char *options);
char *Completion(char *text, int state);
BOOL Cwd(char *path);
BOOL Pwd(void);
void nospace(char *str);

int DaemonFd, DaemonPort;
BOOL LoggedIn, LsCacheOk;
char Server[256], Path[256], RespBuf[4096];
char UserName[256], Password[256];
char LocalDir[256], *LsCache[1024];
char DaemonHost[256];
int LsCacheCount;

int ServerCount;
char *ServHost[256], *ServPath[256], *ServLogin[256], *ServPassword[256];
char *ServAlias[256];

#endif
