/* Gnome Darxite Control
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

#include "global.h"
#include "control-page.h"
#include "batch-status.h"
#include "functions.h"
#include "../common/dnd.h"
#include "pause_menu.xpm"
#include "../common/callbacks.h" //for pixmap stuff!!

GdkColor Blue = {0, 0x8700, 0xCE00, 0xFA00};
GdkColor Red = {0, 0xFF00, 0x7000, 0x7000};
GdkColor Cyan = {0, 0x0000, 0xAAAA, 0xAAAA};
GdkColor Green = {0, 0x6600, 0xCD00, 0xAA00};
GdkColor Brown = {0, 0xD200, 0xB400, 0x8C00};
GdkColor White = {0, 0xFFFF, 0xFFFF, 0xFFFF};

/****************************************************************/
/* popup definitions */
static GnomeUIInfo batch_popup[] = {
    GNOMEUIINFO_ITEM_STOCK (N_("New"),
			    N_ ("Show the download window"),
			    pop_window_d, GNOME_STOCK_MENU_NEW),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Play"), NULL, play_cb,
                            GNOME_STOCK_MENU_FORWARD),
    GNOMEUIINFO_ITEM_STOCK (N_ ("Pause"), NULL, pause_cb,
                            GNOME_STOCK_MENU_PAUSE),

    GNOMEUIINFO_ITEM_STOCK (N_ ("Cancel"), NULL, cancel_cb, 
                            GNOME_STOCK_MENU_STOP),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Get Again"), NULL, reget_cb, 
                            GNOME_STOCK_MENU_REFRESH),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK (N_ ("Clear List"), NULL, clear_list_cb, 
                            GNOME_STOCK_PIXMAP_CLEAR),
    GNOMEUIINFO_END
};

/****************************************************************/

void change_sort(GtkCList *clist, gint column)
{
//  GTK_SORT_ASCENDING
//  GTK_SORT_DESCENDING

	if (GTK_CLIST(clist)->sort_column == column)
	{
	   gtk_clist_set_sort_type((GtkCList *)clist,
	   	!GTK_CLIST(clist)->sort_type);
	}
	else
	{
	   gtk_clist_set_sort_type((GtkCList *)clist,
	   			GTK_SORT_ASCENDING);
	   gtk_clist_set_sort_column ((GtkCList *)clist, column);
	}
	
	gtk_clist_sort ((GtkCList *)clist);
}


GtkWidget *
control_batch_new(ControlPage *child)
{
	GtkWidget *clist;
	GtkWidget *scroll;
	gchar	*clist_titles[] =
			 { _("Filename"), _("Activity"), _("% Got"),
			   _("Current Size"), _("Total Size"),
			   _("Speed"), _("Transfer Time"),
			   _("URL")};

	scroll = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll),
				       GTK_POLICY_AUTOMATIC,
                                       GTK_POLICY_AUTOMATIC);
//	gtk_widget_set_usize(GTK_WIDGET(scroll), 800,300);

/*        gtk_box_pack_start(GTK_BOX(h_box), scroll,TRUE,TRUE,0);*/
        gtk_widget_show(scroll);

	clist = gtk_clist_new_with_titles(BS_TOTAL_COLS, clist_titles);
	gtk_clist_set_selection_mode((GtkCList *)clist, GTK_SELECTION_EXTENDED);
/*	gtk_widget_set_usize(GTK_WIDGET(clist), 200,250);*/
        gtk_container_add(GTK_CONTAINER(scroll), clist);
	gtk_widget_show(clist);

	/* Resize the columns ... */
	gtk_clist_set_column_width((GtkCList *)clist, BS_FILE, 150);
	gtk_clist_set_column_width((GtkCList *)clist, BS_ACTIVITY, 90);
	gtk_clist_set_column_width((GtkCList *)clist, BS_PERCENT, 40);
	gtk_clist_set_column_width((GtkCList *)clist, BS_CURRENT_SIZE, 70);
	gtk_clist_set_column_width((GtkCList *)clist, BS_TOTAL_SIZE, 70);
	gtk_clist_set_column_width((GtkCList *)clist, BS_RATE_OVERALL, 60);
	gtk_clist_set_column_width((GtkCList *)clist, BS_TOTAL_TIME, 80);
	gtk_clist_set_column_width((GtkCList *)clist, BS_URL, 50);

	gtk_clist_set_column_auto_resize ((GtkCList *)clist, BS_URL, TRUE);


	gtk_clist_set_column_justification((GtkCList *)clist,
					BS_PERCENT, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					BS_CURRENT_SIZE, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					BS_TOTAL_SIZE, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					BS_RATE_OVERALL, GTK_JUSTIFY_RIGHT);
	gtk_clist_set_column_justification((GtkCList *)clist,
					BS_TOTAL_TIME, GTK_JUSTIFY_RIGHT);

	gtk_clist_set_sort_column ((GtkCList *)clist, 0);
	gtk_clist_set_auto_sort ((GtkCList *)clist, TRUE);

	if (!GTK_IS_MENU(batch_popup_menu))
	   batch_popup_menu = gnome_popup_menu_new (batch_popup);

	gnome_popup_menu_attach(batch_popup_menu, clist, NULL);

	gtk_signal_connect_object(GTK_OBJECT (clist), "click_column",
					GTK_SIGNAL_FUNC(change_sort), GTK_OBJECT(clist));

//	gtk_signal_connect_object (GTK_OBJECT (clist), "event",
//	                           GTK_SIGNAL_FUNC (clist_event),
//	                           NULL);

	FileStatus += 1;
	clists = g_list_append(clists, clist);
	CONTROL_PAGE(child)->main_widget = GTK_WIDGET(clist);
        return scroll;
}


/***********************************************************************/
static void CopyPointers(gchar *st[BS_TOTAL_COLS], FileInfo *data)
{
	st[BS_FILE] = data->filename;
	st[BS_ACTIVITY] = data->activity;
	st[BS_PERCENT] = data->percent_str;
	st[BS_CURRENT_SIZE] = bytes_to_string(data->current_size);
	st[BS_TOTAL_SIZE] = bytes_to_string(data->total_size);
	st[BS_RATE_OVERALL] = bytesXs_to_string(data->rate_overall);
	st[BS_TOTAL_TIME] = seconds_to_string(data->current_time);
	st[BS_URL] = data->url;
}

static void free_CopyPointers(gchar *st[BS_TOTAL_COLS])
{
//	st[BS_FILE] = data->filename;
//	st[BS_ACTIVITY] = data->activity;
//	st[BS_PERCENT] = data->percent_str;
	g_free(st[BS_CURRENT_SIZE]);
	g_free(st[BS_TOTAL_SIZE]);
	g_free(st[BS_RATE_OVERALL]);
	g_free(st[BS_TOTAL_TIME]);
//	st[BS_URL] = data->url;
}

void update_batch_s(FileInfo *completion, FileInfo *old)
{
	GtkWidget *clist = NULL;
	GList *lists;
	GList *info;
	gint row;
	gchar *temp;

	FileInfo *data;

	gchar *st[BS_TOTAL_COLS];

	if (clists == NULL)
	   return;
	   
	lists = g_list_first(clists);

	if (completion == NULL)
	{

//FIXME: this should be a if when behaviour changed.
	while(lists)
	{
	   clist = GTK_WIDGET(lists->data);

	   info = g_list_first(batch);

	gtk_clist_freeze(GTK_CLIST(clist));

	   while(info)
           { 
	   data = info->data;

	   if (!data->new)
	   {
	   row = gtk_clist_find_row_from_data(GTK_CLIST(clist), data);
	   if (row > -1)
	   {
	      if (data->activity_ch)
	         gtk_clist_set_text((GtkCList *)clist, row, BS_ACTIVITY, data->activity);
	      if (data->percent_ch)
	         gtk_clist_set_text((GtkCList *)clist, row, BS_PERCENT, data->percent_str);
	      if (data->current_size_ch)
	      {
	         temp = bytes_to_string(data->current_size);
	         gtk_clist_set_text((GtkCList *)clist, row,
	         			BS_CURRENT_SIZE, temp);
	         g_free(temp);
	      }
	      if (data->total_size_ch)
	      {
	         temp = bytes_to_string(data->total_size);
	         gtk_clist_set_text((GtkCList *)clist, row,
	         			BS_TOTAL_SIZE, temp);
	         g_free(temp);
	      }
	      if (data->current_time_ch)
	      {
	         temp = seconds_to_string(data->current_time);
	         gtk_clist_set_text((GtkCList *)clist, row,
	         			BS_TOTAL_TIME, temp);
	         g_free(temp);
	      }
	      if (data->rate_overall_ch)
	      {
	         temp = bytesXs_to_string(data->rate_overall);
	         gtk_clist_set_text((GtkCList *)clist, row,
	         			BS_RATE_OVERALL, temp);
	         g_free(temp);
	      }
	   }
	   }
	   else
	   {
	      CopyPointers(st, data);
	      
	      row = gtk_clist_prepend((GtkCList *)clist, st);
	      
	      free_CopyPointers(st);

	      gtk_clist_set_row_data((GtkCList *)clist, row, (FileInfo *) data);

	      data->new = FALSE;
	   }
	   info = info->next;
	   }

	gtk_clist_thaw(GTK_CLIST(clist));

	lists = lists->next;
	}
	}
	else
	{
//FIXME: These needs to be changed!
	   clist = GTK_WIDGET(lists->data);

	   if (old == NULL)
	   {
	      CopyPointers(st, completion);
	      row = gtk_clist_prepend((GtkCList *)clist, st);
	      free_CopyPointers(st);
	   }
	   else
	   {
	      row = gtk_clist_find_row_from_data(GTK_CLIST(clist), old);

	      gtk_clist_set_text((GtkCList *)clist, row, BS_ACTIVITY,
	         completion->activity);
	      gtk_clist_set_text((GtkCList *)clist, row, BS_PERCENT,
	         completion->percent_str);
	      
	      temp = bytes_to_string(completion->current_size);
	      gtk_clist_set_text((GtkCList *)clist, row,
	      			BS_CURRENT_SIZE, temp);
	      g_free(temp);
	      temp = bytes_to_string(completion->total_size);
	      gtk_clist_set_text((GtkCList *)clist, row,
	      			BS_TOTAL_SIZE, temp);
	      g_free(temp);
	      temp = seconds_to_string(completion->current_time);
	      gtk_clist_set_text((GtkCList *)clist, row,
	      			BS_TOTAL_TIME, temp);
	      g_free(temp);
	      temp = bytesXs_to_string(completion->rate_overall);
	      gtk_clist_set_text((GtkCList *)clist, row,
	      			BS_RATE_OVERALL, temp);
	      g_free(temp);
	   }

	   gtk_clist_set_row_data((GtkCList *)clist, row, (FileInfo *) completion);

	   put_color(clist, row, completion->type);
	}

	gtk_clist_sort ((GtkCList *)clist);
}
