/* Gnome Darxite Monitor applet
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/*Includes*/
#include "global.h"
#include "main.h"
#include "../common/dnd.h"
#include "../common/connect.h"
#include "widgets.h"
#include "properties.h"
#include "../common/callbacks.h"
#include "../common/prefs-dnd.h"
#include "../common/prefs-daemon.h"

GtkWidget *applet; /* Here, so every one can see the applet */ 

/*Functions declaration*/
static gint applet_load_session(GtkWidget * widget, const char *privcfgpath,
                    const char *globcfgpath, gpointer data);
static gint applet_save_session(GtkWidget * widget, const char *privcfgpath,
				const char *globcfgpath, gpointer data);
void applet_create_menus(GtkWidget *applet);
void applet_change_orient(GtkWidget *widget, PanelOrientType o);
gint check_daemon(gpointer data);
void signal_func(int signum);
void show_about();
void update_menus();
void do_all(AppletWidget *widget, gpointer data);
void run_noctftp(AppletWidget *widget, void *data);
void run_dxftp(AppletWidget *widget, void *data);
void control_centre(AppletWidget *widget, void *data);
void remote_dialog_cb(AppletWidget *widget, void *data);
void local_connection_applet_cb();


/*------------------------- M A I N ---------------------------*/
int
main(int argc, char **argv)
{
        GtkWidget *monitor_widget; /* The widget of the applet */
        
        /* Initialize the i18n stuff */
//FIXME: autoconf macro!
//	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
//	textdomain (PACKAGE);

        /* intialize */
        applet_widget_init("darxite-monitor_applet", NULL, argc, argv, NULL, 0, NULL);

        /* create a new applet_widget */
	applet = applet_widget_new("darxite-monitor_applet");

        /* in the rare case that the communication with the panel
           failed, error out */
        if (!applet)
                g_error("Can''t create applet!\n");

	/* Read Configuration */
	applet_load_session(applet, APPLET_WIDGET(applet)->privcfgpath,
			APPLET_WIDGET(applet)->globcfgpath, applet);

	/* Darxite Daemon */
        g_print("Gnome Darxite Monitor applet %s by %s, linked against Darxite %s (%s)\n",
           	 GDMONITOR_VERSION, AUTHOR, RELEASE_VER, RELEASE_NAME);
        connected = FALSE;	//We will try this later
        DX_ReadConfigFiles(); /* Read .darxiterc values :) */
	sprintf(TargetDir, "%s/", DX_OutputDir); /* Always use it the first time */
        darxite_client = "darxite-monitor"; //This is the client to connect :)

	daemon_tab_initializations();

        /* Make the applet_widget */
        monitor_widget = monitor_widget_make();

        gtk_signal_connect(GTK_OBJECT(applet), "change_orient",
           		   GTK_SIGNAL_FUNC(applet_change_orient),
                           NULL);

	create_pause_pixmap();

	applet_widget_add (APPLET_WIDGET (applet), monitor_widget);

        gtk_widget_show (applet);

	applet_widget_set_widget_tooltip (APPLET_WIDGET(applet), applet, 
				_("Drop something to download"));
       
        gtk_signal_connect(GTK_OBJECT(applet), "save_session",
           		   GTK_SIGNAL_FUNC(applet_save_session), applet);

	applet_create_menus(applet);

// Configure needed SIGNALS
	if (signal(SIGPIPE, SIG_IGN) == SIG_ERR)
            g_error("Can''t ignore signal SIGPIPE");

	// Connection Configuration...
	if (startup_connect)
	{
	   local = startup_local;

	   if (startup_local)
	   {
	      //connect to local daemon!
	      local_connection_cb();
	   }
	   else //startup_local == FALSE ==> startup_remote :)
	   {
	      //connect to remote daemon!
	      if (remote_connection(host, port, password))
	         g_print("%s", "Remote daemon connection failed!");

	      if (!connected && retry_connect_remote)
	         retry_connect_timeout = gtk_timeout_add
				(retry_timeout_remote*1000, retry_connect_cb, NULL);
	   }
	}
         					
	g_print("Go!\n");
        /* special corba main loop */
        applet_widget_gtk_main ();

	/* Save the configuration before exiting */
	applet_save_session(applet, NULL, NULL, applet);

	DisconnectClient();

        return 0;
}
/*--------------------- E N D   M A I N -------------------------*/

static gint
applet_load_session(GtkWidget * widget, const char *privcfgpath,
                    const char *globcfgpath, gpointer data)
{
  	gnome_config_push_prefix("darxite-monitor_applet/");

        show_flash = gnome_config_get_int("options/show_flash=1");

        show_logo_button = gnome_config_get_int("widgets/show_logo_button=1");
        show_logo_button_little = gnome_config_get_int("widgets/show_logo_button_little=1");
        show_power_button = gnome_config_get_int("widgets/show_power_button=1");
        show_percent_button = gnome_config_get_int("widgets/show_percent_button=1");
        show_files_button = gnome_config_get_int("widgets/show_files_button=1");
        use_two_lines = gnome_config_get_int("widgets/use_two_lines=0");

        inverse_percent = gnome_config_get_int("monitor/inverse_percent=1");

        autostart_daemon = gnome_config_get_int("daemon/autostart_daemon=0");
        strcpy(flags, gnome_config_get_string("daemon/flags=PrSmB"));

	host = gnome_config_get_string("Daemon/host=localhost");
	port = gnome_config_get_int("Daemon/port=5678");
//FIXME: We haven't saved any password, so set it to ""
	password = "";

	dnd_tab_load_config();
	daemon_tab_load_config();

   	gnome_config_pop_prefix();
	return FALSE;
}

static gint
applet_save_session(GtkWidget * widget, const char *privcfgpath,
                    const char *globcfgpath, gpointer data)
{
   	gnome_config_push_prefix("darxite-monitor_applet/");

        gnome_config_set_int("options/show_flash", show_flash);

        gnome_config_set_int("widgets/show_logo_button", show_logo_button);
        gnome_config_set_int("widgets/show_logo_button_little", show_logo_button_little);
        gnome_config_set_int("widgets/show_power_button", show_power_button);
        gnome_config_set_int("widgets/show_percent_button", show_percent_button);
        gnome_config_set_int("widgets/show_files_button", show_files_button);
        gnome_config_set_int("widgets/use_two_lines", use_two_lines);

        gnome_config_set_int("monitor/inverse_percent", inverse_percent);

        gnome_config_set_int("daemon/autostart_daemon", autostart_daemon);
        gnome_config_set_string("daemon/flags", flags);

	gnome_config_set_string("Daemon/host", host);
	gnome_config_set_int("Daemon/port", port);
//FIXME: I think we don't want this:
//	gnome_config_set_int("Daemon/password", password);

	dnd_tab_save_config();
	daemon_tab_save_config();

   	gnome_config_pop_prefix();
        gnome_config_sync();
        gnome_config_drop_all();

        return FALSE;
}

void applet_create_menus(GtkWidget *applet)
{

	applet_widget_register_stock_callback_dir(APPLET_WIDGET(applet),
					    "actions/",
					    GNOME_STOCK_MENU_EXEC,
					    _("Actions"));

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"actions/new_url",
					GNOME_STOCK_MENU_NEW,
                                        _("New URL..."),
                                        pop_window_d,
                                        NULL);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"actions/continue_all",
					GNOME_STOCK_MENU_FORWARD,
                                        _("Continue All"),
                                        do_all,
                                        GINT_TO_POINTER(0));

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"actions/pause_all",
					GNOME_STOCK_MENU_PAUSE,
                                        _("Pause All"),
                                        do_all,
                                        GINT_TO_POINTER(1));

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"actions/cancel_all",
					GNOME_STOCK_MENU_STOP,
                                        _("Cancel All"),
                                        do_all,
                                        GINT_TO_POINTER(2));

	applet_widget_register_stock_callback_dir(APPLET_WIDGET(applet),
					    "programs/",
					    GNOME_STOCK_MENU_JUMP_TO,
					    _("Programs"));

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"programs/run_dsgtk",
				        GNOME_STOCK_MENU_SEARCH,
                                        _("Download Status"),
                                        button_status_click,
                                        applet);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"programs/run_darxite_control",
				        GNOME_STOCK_MENU_SEARCH,
                                        _("Darxite Control"),
                                        button_files_click,
                                        applet);

        applet_widget_register_callback(APPLET_WIDGET(applet),
           				"programs/run_noctftp",
                                        _("Noct FTP"),
                                        run_noctftp,
                                        applet);

        applet_widget_register_callback(APPLET_WIDGET(applet),
           				"programs/run_dxftp",
                                        _("dx FTP"),
                                        run_dxftp,
                                        applet);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"programs/control_centre",
					GNOME_STOCK_MENU_PREF,
                                        _("Control Centre"),
                                        control_centre,
                                        applet);

	applet_widget_register_stock_callback_dir(APPLET_WIDGET(applet),
					    "Daemon/",
					    GNOME_STOCK_MENU_LINE_IN,
					    _("Daemon"));

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"Daemon/local",
					GNOME_STOCK_MENU_LINE_IN,
                                        _("Connect to Local"),
                                        local_connection_applet_cb,
                                        NULL);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"Daemon/remote",
					GNOME_STOCK_MENU_LINE_IN,
                                        _("Connect to Remote"),
                                        remote_dialog_cb,
                                        NULL);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"Daemon/disconnect",
					GNOME_STOCK_MENU_BLANK,
                                        _("Disconnect"),
                                        DisconnectClient,
                                        NULL);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"start_stop",
				        GNOME_STOCK_MENU_TIMER,
                                        _("Start Darxite Daemon"),
                                        start_stop_daemon_applet_cb,
                                        applet);

        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"properties",
                                        GNOME_STOCK_MENU_PROP,
                                        _("Properties..."),
                                        prefs_cb,
                                        applet);
 
        applet_widget_register_stock_callback(APPLET_WIDGET(applet),
       					"about",
                                        GNOME_STOCK_MENU_ABOUT,
                                        _("About..."),
                                        show_about,
                                        applet);
}

void
applet_change_orient(GtkWidget *widget, PanelOrientType o)
{
   	if ((ORIENT_UP == o) || (ORIENT_DOWN == o))
           {
	   panel_orientation = 0;

           gtk_widget_show(hbox);
           gtk_widget_hide(vbox);

	   distribute_widgets();
	   update_widgets();
           }
        else
           {
	   panel_orientation = 1;

	   gtk_widget_show(vbox);
           gtk_widget_hide(hbox);

	   distribute_widgets();
	   update_widgets();
           }           
}

void
update_menus()
{
	if (connected)
	{
           applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"start_stop",
				        GNOME_STOCK_MENU_TIMER_STOP,
                                        _("Stop Darxite Daemon"),
                                        start_stop_daemon_applet_cb,
                                        applet);
	}
	else
	{
	   applet_widget_register_stock_callback(APPLET_WIDGET(applet),
           				"start_stop",
				        GNOME_STOCK_MENU_TIMER,
                                        _("Start Darxite Daemon"),
                                        start_stop_daemon_applet_cb,
                                        applet);
	}
}

void do_all(AppletWidget *widget, gpointer data)
{
        char buffer[2048];

	switch(GPOINTER_TO_INT(data))
	{
	case 0:        sprintf(buffer, "Continue all\n");
		       break;
	case 1:        sprintf(buffer, "Pause all\n");
		       break;
	case 2:        sprintf(buffer, "Cancel all\n");
/*FIXME: show a warning first!!!*/
		       break;
	}

#ifdef DEBUG_MESSAGES
        g_print(buffer);
#endif
        write(fd, buffer, strlen(buffer));
}

void
show_about()
{
   	const char *authors[] = {"Manuel Clos", NULL};
        GtkWidget *href;
        GtkWidget *about_box;
        about_box = gnome_about_new(_("Gnome Darxite Monitor applet"),
                          _(GDMONITOR_VERSION),
                          NULL,
                          authors,
                          _("From the Darxite FAQ:\n"
"  What is it?\n"
"   ""Darxite"" is the name given to a system consisting of a daemon running"
"   in the background whose job is to retrieve files via FTP or HTTP and"
"   execute other FTP commands, and a number of \"client\" programs whose"
"   jobs are to control the daemon and to provide a user interface.\n"
"The Darxite author is Ashley Montanaro (hell@ukgateway.net).\n"
"This applet is one of such clients. It can add URLs to the batch,"
" accepts DnD (both Gnome and Netscape), and shows some statistics"
" relating to the download."),
                           "darxite-png");
        gtk_window_position(GTK_WINDOW(about_box), GTK_WIN_POS_CENTER);
	href = gnome_href_new("http://darxite.cjb.net/", NULL);
        gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(about_box)->vbox), href,
        	FALSE, FALSE, 0);
        gtk_widget_show(href);
        gtk_widget_show(about_box);
}

void configure_connection()
{
	input_response = gdk_input_add(fd, GDK_INPUT_READ, get_data, NULL);

	SendToDaemon("NotifyOnEvent Exit\n");
	SendToDaemon("NotifyOnEvent ConfigChange\n");

	if (local)
	{
	   if (file_count_local)
	   {
	      file_count_cb(NULL);
	      file_count_timeout = gtk_timeout_add
			(file_count_timeout_local*1000, file_count_cb, NULL);
	   }
//FIXME: It don't support FileStatus right now, but will do in the future.
//	   if (file_status_local)
//	   {
//	      sprintf(buffer, "FileStatus\n");
//	      write(fd, buffer, strlen(buffer));
//	      first_file_status_sent = TRUE;
//
//	      file_status_timeout = gtk_timeout_add
//	      		(file_status_timeout_local*1000, file_status_cb, NULL);
//	   }	
	}
	else
	{
	   if (file_count_remote)
	   {
	      file_count_cb(NULL);
	      file_count_timeout = gtk_timeout_add
			(file_count_timeout_remote*1000, file_count_cb, NULL);
	   }
//FIXME: It don't support FileStatus right now, but will do in the future.
//	   if (file_status_remote)
//	   {
//	      sprintf(buffer, "FileStatus\n");
//	      write(fd, buffer, strlen(buffer));
//	      first_file_status_sent = TRUE;
//	      
//	      file_status_timeout = gtk_timeout_add
//	      		(file_status_timeout_remote*1000, file_status_cb, NULL);
//	   }	
	}

	//Application PostConnection configuration...
	update_widgets();
	update_menus();
}

void configure_disconnection()
{
//FIXME: This is for safety, should be removed when we don't use SIGPIPE.
	connected = FALSE;

	gtk_timeout_remove(file_count_timeout);
	file_count_timeout = 0;
//	gtk_timeout_remove(file_status_timeout);
//	file_status_timeout = 0;

	update_widgets();
	update_menus();
}

gint 
retry_connect_cb(gpointer data)
{
	if (connected)
	   return FALSE;

	if (local)
	{
	   //connect to local daemon!
	   if (local_connection())
	   {
	      if (auto_start_local)
	      {
	         //Autostart the local daemon
	         if(do_autostart_daemon())
	            local_connection();
	      }
	   }
	}
	else //local == FALSE ==> remote :)
	{
	   //connect to remote daemon!
	   remote_connection(host, port, password);
	}

	if (!connected)
	   return TRUE;
	else
	   return FALSE;
}

void run_noctftp(AppletWidget *widget, void *data)
{
	run_noctftp_cb(NULL, NULL);
}

void run_dxftp(AppletWidget *widget, void *data)
{
	run_dxftp_cb(NULL, NULL);
}

void control_centre(AppletWidget *widget, void *data)
{
	control_centre_cb(NULL, NULL);
}

void remote_dialog_cb(AppletWidget *widget, void *data)
{
	remote_dialog(NULL);
}

void local_connection_applet_cb()
{
	local_connection_cb();
}
