/* Gnome Darxite Monitor applet
 * 
 * Author: Manuel Clos
 * 
 * Darxite Author: Ashley Montanaro
 *
 * See AUTHORS for emails.
 */

/* widgets for Gnome Darxite Monitor Applet*/

#include "global.h"
#include "../common/dnd.h"
#include "widgets.h"
#include "properties.h"
#include "../common/prefs-dnd.h"
#include "../common/prefs-daemon.h"

/* This module only variables */

PropertyUI prefs_ui = { NULL };

GtkWidget *cb_do_flash;
GtkWidget *cb_inverse_percent;

GtkWidget *cb_show_logo;
GtkWidget *cb_logo_little;
GtkWidget *cb_power_button;
GtkWidget *cb_percent_button;
GtkWidget *cb_files_button;
GtkWidget *cb_use_two_lines;


static void monitor_preferences(PropertyUI *pui);
static void apply_changes_cb(GnomePropertyBox *pbox, gint page, PropertyUI *pui);
static int close_preferences(GtkWidget * widget, PropertyUI *pui);
GtkWidget *options_tab_make(GnomePropertyBox *pbox);
void options_tab_apply_changes();
GtkWidget *look_tab_make(GnomePropertyBox *pbox);
void look_tab_apply_changes();

//---------------------------------------------------------

static void
properties_modified_cb(GtkWidget *w, GnomePropertyBox *pbox)
{
        gnome_property_box_changed(pbox);
}

void
prefs_cb(AppletWidget * applet, gpointer data)
{
        if(prefs_ui.pbox == NULL)
                monitor_preferences(&prefs_ui);
	else
		gdk_window_raise(GTK_WIDGET(prefs_ui.pbox)->window);
}

static void
monitor_preferences(PropertyUI *pui)
{
	/*Create the preferences box and bind some signals*/
        pui->pbox = (GnomePropertyBox *)gnome_property_box_new();

        gtk_signal_connect(GTK_OBJECT(pui->pbox), "apply",
           	  	   GTK_SIGNAL_FUNC(apply_changes_cb), pui);
        gtk_signal_connect(GTK_OBJECT(pui->pbox), "delete_event",
           	  	   GTK_SIGNAL_FUNC(close_preferences), pui);
        gtk_signal_connect(GTK_OBJECT(pui->pbox), "destroy",
           	  	   GTK_SIGNAL_FUNC(close_preferences), pui);

        gtk_window_set_title (GTK_WINDOW (pui->pbox),
           		      _("Gnome Darxite Monitor applet properties"));


	pui->dnd_tab = dnd_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->dnd_tab, gtk_label_new(_("DnD Behaviour")));

	pui->options_tab = options_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->options_tab, gtk_label_new(_("Options")));

	pui->look_tab = look_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->look_tab, gtk_label_new(_("Look")));

	pui->daemon_tab = daemon_tab_make(GNOME_PROPERTY_BOX(pui->pbox));
	gnome_property_box_append_page(GNOME_PROPERTY_BOX(pui->pbox),
			pui->daemon_tab, gtk_label_new(_("Daemon")));

	gtk_widget_show(GTK_WIDGET(pui->pbox));
}

static void
apply_changes_cb(GnomePropertyBox *pbox, gint page, PropertyUI *pui)
{
        if ( page != -1 ) return; /* Only do something on global apply */

	dnd_tab_apply_changes();
	options_tab_apply_changes();
	daemon_tab_apply_changes();
	look_tab_apply_changes();
	dnd_tab_apply_changes();

/*        applet_widget_config_sync(AppletWidget *widget);*/
	update_widgets();
	distribute_widgets();
}

static int
close_preferences(GtkWidget * widget, PropertyUI *pui)
{
   	pui->pbox = NULL;
   	return FALSE;
}

//--------------------------------------------------------------

GtkWidget *
options_tab_make(GnomePropertyBox *pbox)
{
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *frame;
	
	vbox = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD_SMALL);
        gtk_widget_show(vbox);

	frame = gtk_frame_new(_("Options"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

	cb_do_flash = gtk_check_button_new_with_label(
           	_("Flash logo when drop accepted"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_do_flash, FALSE, TRUE, 0);
        gtk_widget_show(cb_do_flash);

        cb_inverse_percent = gtk_check_button_new_with_label(
           	_("Show inverse percent (100% -> 0%, remaining bits)"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_inverse_percent, FALSE, TRUE, 0);
        gtk_widget_show(cb_inverse_percent);

	
//Set preferences:

        if (show_flash)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_do_flash), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_do_flash), "clicked",
					properties_modified_cb, pbox);

	if (inverse_percent)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_inverse_percent), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_inverse_percent), "clicked",
					properties_modified_cb, pbox);

	return vbox;
}

void options_tab_apply_changes()
{
	if (GTK_TOGGLE_BUTTON(cb_do_flash)->active)
	   show_flash = TRUE;
	else
	   show_flash = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_inverse_percent)->active)
	   inverse_percent = TRUE;
	else
	   inverse_percent = FALSE;
}

GtkWidget *
look_tab_make(GnomePropertyBox *pbox)
{
	GtkWidget *vbox;
	GtkWidget *vbox2;
	GtkWidget *frame;
	
	vbox = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD_SMALL);
        gtk_widget_show(vbox);

	frame = gtk_frame_new(_("Look"));
        gtk_container_border_width(GTK_CONTAINER(frame), GNOME_PAD_SMALL);
        gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 2);  
        gtk_widget_show(frame);

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(frame), vbox2);
        gtk_widget_show(vbox2);

	cb_show_logo = gtk_check_button_new_with_label(
           	_("Show the logo button (download button)"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_show_logo, FALSE, TRUE, 0);
        gtk_widget_show(cb_show_logo);

	cb_logo_little = gtk_check_button_new_with_label(
           	_("Show it little"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_logo_little, TRUE, FALSE, 0);
        gtk_widget_show(cb_logo_little);

	cb_power_button = gtk_check_button_new_with_label(
           	_("Show power button (can start/stop the daemon)"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_power_button, TRUE, FALSE, 0);
        gtk_widget_show(cb_power_button);

        cb_percent_button = gtk_check_button_new_with_label(
	   _("Show percent button (also execs. 'dsgtk')"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_percent_button, TRUE, FALSE, 0);
        gtk_widget_show(cb_percent_button);

	cb_files_button = gtk_check_button_new_with_label(
	   _("Show files button (also execs. 'darxite-control')"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_files_button, TRUE, FALSE, 0);
	gtk_widget_show(cb_files_button);

        cb_use_two_lines = gtk_check_button_new_with_label(
	   _("Use two lines to show the buttons"));
        gtk_box_pack_start(GTK_BOX(vbox2), cb_use_two_lines, TRUE, FALSE, 0);
        gtk_widget_show(cb_use_two_lines);

//Set preferences:

        if (show_logo_button)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_show_logo), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_show_logo), "clicked",
					properties_modified_cb, pbox);

        if (show_logo_button_little)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_logo_little), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_logo_little), "clicked",
					properties_modified_cb, pbox);

        if (show_power_button)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_power_button), TRUE);

	gtk_signal_connect(GTK_OBJECT(cb_power_button), "clicked",
					properties_modified_cb, pbox);

        if (show_percent_button)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_percent_button), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_percent_button), "clicked",
					properties_modified_cb, pbox);

        if (show_files_button)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_files_button), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_files_button), "clicked",
					properties_modified_cb, pbox);

        if (use_two_lines)
           gtk_toggle_button_set_active
              (GTK_TOGGLE_BUTTON(cb_use_two_lines), TRUE);

        gtk_signal_connect(GTK_OBJECT(cb_use_two_lines), "clicked",
					properties_modified_cb, pbox);

	return vbox;
}

void look_tab_apply_changes()
{

	if (GTK_TOGGLE_BUTTON(cb_show_logo)->active)
	   show_logo_button = TRUE;
	else
	   show_logo_button = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_logo_little)->active)
	   show_logo_button_little = TRUE;
	else
	   show_logo_button_little = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_power_button)->active)
	   show_power_button = TRUE;
	else
	   show_power_button = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_percent_button)->active)
	   show_percent_button = TRUE;
	else
	   show_percent_button = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_files_button)->active)
	   show_files_button = TRUE;
	else
	   show_files_button = FALSE;

	if (GTK_TOGGLE_BUTTON(cb_use_two_lines)->active)
	   use_two_lines = TRUE;
	else
	   use_two_lines = FALSE;
}
