// The Darxite Control Centre

#include <gtk/gtk.h>
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "../../darxite.h"

#define VERSION "0.34"

GtkWidget *Window, *MainVbox, *Notebook, *ButtonBox;
GtkWidget *TransferTable, *MirrorTable, *ProxyTable, *MassiveTable;
GtkWidget *LoggingTable, *Misc1Table, *Misc2Table;

GtkWidget *OutputDirEntry, *EMailAddressEntry;
GtkWidget *RemotePortEntry, *SleepIntervalEntry;
GtkWidget *OutputToProgramEntry, *OutputToFileEntry;
GtkWidget *RxBeforeSwitchEntry, *TimeBeforeSwitchEntry;
GtkWidget *MaxSimDownloadsEntry;

GtkWidget *OpenLocalFileCheck, *UseMirrorsCheck;
GtkWidget *SpoolFileCheck, *RenameFileCheck;
GtkWidget *AutoBookmarkCheck;

GtkWidget *AppList, *ExtensionEntry, *AppEntry;
GtkWidget *NewAppButton, *DeleteAppButton;

GtkWidget *ProxyHostName, *ProxyPort;

GtkWidget *MassiveDownloadCheck, *MassiveLimitEntry;
GtkWidget *MassiveAutoMirrorCheck;
GtkWidget *MassiveMaxConnectionsEntry, *MassiveConnectAgainLimitEntry;

GtkWidget *FileLogEntry, *ClearFileLogCheck, *ClearFileLogButton;
GtkWidget *LeaveCompleteFilesCheck;
GtkWidget *FileLoggingCheck, *ErrorLoggingCheck;

GtkWidget *DisconnectCheck, *DisconnectCommandEntry;
GtkWidget *DetectPrematureCompletionCheck;
GtkWidget *BufferSizeEntry;

GtkWidget *SaveDotFileButton, *SaveEtcFileButton;
GtkWidget *UpdateDaemonButton, *ExitButton;

char *DotFileName, *EtcFileName;
int AppListRow = -1;

void WritePrefs(GtkWidget *widget, const char *filename);
void CreateTransferPage(void);
void CreateMirroringPage(void);
void CreateAppsPage(void);
void CreateProxyPage(void);
void CreateMassivePage(void);
void CreateLoggingPage(void);
void CreateMisc1Page(void);
void CreateMisc2Page(void);

void WritePrefs(GtkWidget *widget, const char *filename)
{
    FILE *file;
    char *str, *str2;
    int num, i;
    
    file = fopen(filename, "w");
    if (!file)
    {
        fprintf(stderr, "Couldn't save file: %s\n", strerror(errno));
        return;
    }
    fprintf(file,
            "# Configuration file for Darxite release %s\n"
            "# Generated automagically by dxpref %s - "
            "edit at your own risk!\n\n", RELEASE_VER, VERSION);
    fprintf(file, "OutputDir    \"%s\"\n"
            "EMailAddress \"%s\"\n",
            gtk_entry_get_text(GTK_ENTRY(OutputDirEntry)),
            gtk_entry_get_text(GTK_ENTRY(EMailAddressEntry)));
    if (GTK_TOGGLE_BUTTON(SpoolFileCheck)->active)
        fprintf(file, "EnableSpooling\n");
    else
        fprintf(file, "DisableSpooling\n");
    if (GTK_TOGGLE_BUTTON(RenameFileCheck)->active)
        fprintf(file, "EnableRenaming\n");
    else
        fprintf(file, "DisableRenaming\n");
    if (GTK_TOGGLE_BUTTON(OpenLocalFileCheck)->active)
        fprintf(file, "EnableOpenLocalFile\n");
    else
        fprintf(file, "DisableOpenLocalFile\n");
    if (GTK_TOGGLE_BUTTON(ErrorLoggingCheck)->active)
        fprintf(file, "EnableErrorLogging\n");
    else
        fprintf(file, "DisableErrorLogging\n");
    num = atoi(gtk_entry_get_text(GTK_ENTRY(MaxSimDownloadsEntry)));
    if (num > 0)
        fprintf(file, "MaxSimDownloads %d\n", num);
    
    if (GTK_TOGGLE_BUTTON(UseMirrorsCheck)->active)
    {
        fprintf(file, "\nEnableMirrors\n"
                "MinRxBeforeSwitching %s\n"
                "TimeBeforeSwitching %s\n\n",
                gtk_entry_get_text(GTK_ENTRY(RxBeforeSwitchEntry)),
                gtk_entry_get_text(GTK_ENTRY(TimeBeforeSwitchEntry)));
    }
    else
    {
        fprintf(file, "\nDisableMirrors\n\n");
    }
    num = atoi(gtk_entry_get_text(GTK_ENTRY(RemotePortEntry)));
    if (num > 0)
        fprintf(file, "ListenOnPort %d\n", num);
    num = atoi(gtk_entry_get_text(GTK_ENTRY(SleepIntervalEntry)));
    if (num > 0)
        fprintf(file, "SleepInterval %d\n", num);
    str = gtk_entry_get_text(GTK_ENTRY(OutputToFileEntry));
    if (strcmp(str, ""))
        fprintf(file, "OutputToFile \"%s\"\n", str);
    str = gtk_entry_get_text(GTK_ENTRY(OutputToProgramEntry));
    if (strcmp(str, ""))
        fprintf(file, "OutputToProgram \"%s\"\n", str);
    
    if (GTK_TOGGLE_BUTTON(FileLoggingCheck)->active)
        fprintf(file, "\nEnableFileLogging\n");
    else
        fprintf(file, "\nDisableFileLogging\n");
    str = gtk_entry_get_text(GTK_ENTRY(FileLogEntry));
    if (strcmp(str, ""))
        fprintf(file, "FileLogName \"%s\"\n", str);
    if (GTK_TOGGLE_BUTTON(ClearFileLogCheck)->active)
        fprintf(file, "ClearFileLogOnExit\n");
    else
        fprintf(file, "LeaveFileLogOnExit\n");
    
    if (GTK_TOGGLE_BUTTON(LeaveCompleteFilesCheck)->active)
        fprintf(file, "LeaveCompleteFiles\n");
    else
        fprintf(file, "RemoveCompleteFiles\n");
    
    str = gtk_entry_get_text(GTK_ENTRY(ProxyHostName));
    if (strcmp(str, ""))
        fprintf(file, "ProxyHostName %s\n", str);
    num = atoi(gtk_entry_get_text(GTK_ENTRY(ProxyPort)));
    if (num > 0)
        fprintf(file, "ProxyPort %d\n", num);
    
    if (GTK_TOGGLE_BUTTON(MassiveDownloadCheck)->active)
        fprintf(file, "\nEnableMassiveDownload\n");
    else
        fprintf(file, "\nDisableMassiveDownload\n");
    if (GTK_TOGGLE_BUTTON(MassiveAutoMirrorCheck)->active)
        fprintf(file, "EnableMassiveAutoMirror\n");
    else
        fprintf(file, "DisableMassiveAutoMirror\n");
    num = atoi(gtk_entry_get_text(GTK_ENTRY(MassiveLimitEntry)));
    fprintf(file, "MassiveLimit %d\n", num);
    num = atoi(gtk_entry_get_text(GTK_ENTRY(MassiveMaxConnectionsEntry)));
    fprintf(file, "MassiveMaxConnections %d\n", num);
    num =
        atoi(gtk_entry_get_text(GTK_ENTRY(MassiveConnectAgainLimitEntry)));
    fprintf(file, "MassiveConnectAgainLimit %d\n", num);
    
    if (GTK_TOGGLE_BUTTON(DisconnectCheck)->active)
        fprintf(file, "\nDisconnectOnCompletion\n");
    else
        fprintf(file, "\nNoDisconnectOnCompletion\n");
	str = gtk_entry_get_text(GTK_ENTRY(DisconnectCommandEntry));
    if (strcmp(str, ""))
        fprintf(file, "DisconnectCommand \"%s\"\n", str);
    num = atoi(gtk_entry_get_text(GTK_ENTRY(BufferSizeEntry)));
    if (num > 0)
        fprintf(file, "BufferSize %d\n", num);
    if (GTK_TOGGLE_BUTTON(DetectPrematureCompletionCheck)->active)
        fprintf(file, "DetectPrematureCompletion\n");
    else
        fprintf(file, "NoDetectPrematureCompletion\n");
    
    for (i = 0; i < GTK_CLIST(AppList)->rows; i++)
    {
        gtk_clist_get_text(GTK_CLIST(AppList), i, 0, &str);
        gtk_clist_get_text(GTK_CLIST(AppList), i, 1, &str2);
        if (*str == '.')
            fprintf(file, "\n%s %s", str, str2);
        else
            fprintf(file, "\n.%s %s", str, str2);
    }
    fprintf(file, "\n");
    fclose(file);
}

void UpdateDaemon(void)
{
    int fd;
    char *ptr = strdup("ReloadConfig\n");

    fd = DX_ConnectClient("dxpref");
    if (fd < 0)
    {
        fprintf(stderr, "Couldn't connect to daemon: %s\n",
                strerror(DX_errno));
        return;
    }
    write(fd, ptr, strlen(ptr));
    DX_DisconnectClient(fd);
    free(ptr);
}

void ClearFileLog(GtkWidget *widget, GtkEntry *entry)
{
    remove(gtk_entry_get_text(entry));
}

void CreateTransferPage(void)
{
    GtkWidget *label, *line;
    char buffer[256];

    TransferTable = gtk_table_new(7, 2, FALSE);
    gtk_widget_show(TransferTable);
    
    label = gtk_label_new("Output dir:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), label, 0, 1, 0, 1);
    gtk_widget_show(label);
    
    OutputDirEntry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(OutputDirEntry), DX_OutputDir);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), OutputDirEntry,
                              1, 2, 0, 1);
    gtk_widget_show(OutputDirEntry);
    
    label = gtk_label_new("E-mail address:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), label, 0, 1, 1, 2);
    gtk_widget_show(label);
    
    EMailAddressEntry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(EMailAddressEntry), DX_EMailAddress);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), EMailAddressEntry,
                              1, 2, 1, 2);
    gtk_widget_show(EMailAddressEntry);

    label = gtk_label_new("Max. simultaneous transfers:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), label, 0, 1, 2, 3);
    gtk_widget_show(label);
    
    MaxSimDownloadsEntry = gtk_entry_new();
    if (DX_MaxSimDownloads > 0)
    {
        sprintf(buffer, "%d", DX_MaxSimDownloads);
        gtk_entry_set_text(GTK_ENTRY(MaxSimDownloadsEntry), buffer);
    }
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), MaxSimDownloadsEntry,
                              1, 2, 2, 3);
    gtk_widget_show(MaxSimDownloadsEntry);

    RenameFileCheck =
        gtk_check_button_new_with_label("Rename files during transfer");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(RenameFileCheck),
                                DX_EnableRenaming);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), RenameFileCheck,
                              1, 2, 3, 4);
    gtk_widget_show(RenameFileCheck);
    
    SpoolFileCheck =
        gtk_check_button_new_with_label("Spool files during transfer");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(SpoolFileCheck),
                                DX_EnableSpooling);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), SpoolFileCheck,
                              1, 2, 4, 5);
    gtk_widget_show(SpoolFileCheck);
    
    OpenLocalFileCheck =
        gtk_check_button_new_with_label("Keep files open during transfer");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(OpenLocalFileCheck),
                                DX_EnableOpenLocalFile);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), OpenLocalFileCheck,
                              1, 2, 5, 6);
    gtk_widget_show(OpenLocalFileCheck);

    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), line, 0, 2, 6, 7);
    gtk_widget_show(line);
    
    label = gtk_label_new("\"Output dir\" is the directory in which, by "
                          "default, downloaded files will be placed.\n"
                          "If the \"rename files\" box is checked, then "
                          "while a file is still being downloaded, it \n"
                          "will have \".darxite\" appended to its name.\n"
                          "If the \"spool files\" box is checked, then files "
                          "will be \"spooled\" in the directory\n"
                          "\"~/.darxite/spool\" until they are complete.");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(TransferTable), label, 0, 2, 7, 8);
    
    label = gtk_label_new("Transfer");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), TransferTable, label);
}

void CreateMirroringPage(void)
{
    char buffer[256];
    GtkWidget *label, *line;
    
    MirrorTable = gtk_table_new(5, 2, FALSE);
    gtk_widget_show(MirrorTable);
    
    UseMirrorsCheck = gtk_check_button_new_with_label("Enable auto-mirroring");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(UseMirrorsCheck),
                                DX_EnableMirrors);
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), UseMirrorsCheck,
                              1, 2, 0, 1);
    gtk_widget_show(UseMirrorsCheck);
    
    label = gtk_label_new("Min rx rate before switch:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), label, 0, 1, 1, 2);
    gtk_widget_show(label);
    
    RxBeforeSwitchEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_MinRxBeforeSwitching);
    gtk_entry_set_text(GTK_ENTRY(RxBeforeSwitchEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), RxBeforeSwitchEntry,
                              1, 2, 1, 2);
    gtk_widget_show(RxBeforeSwitchEntry);
    
    label = gtk_label_new("Min time before switch:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), label, 0, 1, 2, 3);
    gtk_widget_show(label);
    
    TimeBeforeSwitchEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_TimeBeforeSwitching);
    gtk_entry_set_text(GTK_ENTRY(TimeBeforeSwitchEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), TimeBeforeSwitchEntry,
                              1, 2, 2, 3);
    gtk_widget_show(TimeBeforeSwitchEntry);
    
    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), line, 0, 2, 3, 4);
    gtk_widget_show(line);
    
    label = gtk_label_new("If auto-mirroring is enabled, then Darxite will "
                          "automatically switch\nbetween a server's mirrors "
                          "when the transfer rate gets too slow -\nie. when "
                          "the number of bytes per second goes below \"rx "
                          "rate\"\nor it has been \"min time\" seconds since "
                          "there was any input.");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(MirrorTable), label, 0, 2, 4, 5);
    
    label = gtk_label_new("Mirroring");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), MirrorTable, label);
}

void NewApp(void)
{
    char *new_app[] = { "<new>", "" };
    
    gtk_clist_append(GTK_CLIST(AppList), new_app);
}

void DeleteApp(void)
{
    if (AppListRow > -1)
        gtk_clist_remove(GTK_CLIST(AppList), AppListRow);
}

void AppListClicked(GtkWidget *widget, gint row, gint column,
                    GdkEventButton *event)
{
    gchar *text;
    
    AppListRow = row;
    if (row > -1)
    {
        gtk_clist_get_text(GTK_CLIST(AppList), row, 0, &text);
        gtk_entry_set_text(GTK_ENTRY(ExtensionEntry), text);
        gtk_clist_get_text(GTK_CLIST(AppList), row, 1, &text);
        gtk_entry_set_text(GTK_ENTRY(AppEntry), text);
    }
    else
    {
        gtk_entry_set_text(GTK_ENTRY(ExtensionEntry), "");
        gtk_entry_set_text(GTK_ENTRY(AppEntry), "");
    }
}

void EditExtension(void)
{
    if (AppListRow > -1)
    {
        gtk_clist_set_text(GTK_CLIST(AppList), AppListRow, 0,
                           gtk_entry_get_text(GTK_ENTRY(ExtensionEntry)));
    }
}

void EditApp(void)
{
    if (AppListRow > -1)
    {
        gtk_clist_set_text(GTK_CLIST(AppList), AppListRow, 1,
                           gtk_entry_get_text(GTK_ENTRY(AppEntry)));
    }
}

void CreateAppsPage(void)
{
    char *type[2], *titles[] = { "Extension", "Application" };
    GtkWidget *label, *line, *vbox, *hbox;
    int i;
    
    vbox = gtk_vbox_new(FALSE, 0);
    gtk_widget_show(vbox);

    AppList = gtk_clist_new_with_titles(2, titles);
    gtk_signal_connect(GTK_OBJECT(AppList), "select_row",
                       GTK_SIGNAL_FUNC(AppListClicked), NULL);
    gtk_box_pack_start(GTK_BOX(vbox), AppList, TRUE, TRUE, 0);
    for (i = 0; i < DX_FileTypeCount; i++)
    {
        type[0] = DX_FileType[0][i];
        type[1] = DX_FileType[1][i];
        gtk_clist_append(GTK_CLIST(AppList), type);
    }
    gtk_widget_show(AppList);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);

    NewAppButton = gtk_button_new_with_label("New");
    gtk_signal_connect(GTK_OBJECT(NewAppButton), "clicked",
                       GTK_SIGNAL_FUNC(NewApp), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), NewAppButton, TRUE, TRUE, 0);
    gtk_widget_show(NewAppButton);

    DeleteAppButton = gtk_button_new_with_label("Delete");
    gtk_signal_connect(GTK_OBJECT(DeleteAppButton), "clicked",
                       GTK_SIGNAL_FUNC(DeleteApp), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), DeleteAppButton, TRUE, TRUE, 0);
    gtk_widget_show(DeleteAppButton);

    ExtensionEntry = gtk_entry_new();
    gtk_signal_connect(GTK_OBJECT(ExtensionEntry), "changed",
                       GTK_SIGNAL_FUNC(EditExtension), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), ExtensionEntry, TRUE, TRUE, 0);
    gtk_widget_show(ExtensionEntry);

    AppEntry = gtk_entry_new();
    gtk_signal_connect(GTK_OBJECT(AppEntry), "changed",
                       GTK_SIGNAL_FUNC(EditApp), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), AppEntry, TRUE, TRUE, 0);
    gtk_widget_show(AppEntry);
    
    line = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(vbox), line, FALSE, FALSE, 0);
    gtk_widget_show(line);
    
    label = gtk_label_new("To automatically run a program on files when\nthey "
                          "have been transferred, enter the extension on\nthe "
                          "left and then the program that should be "
                          "executed.");
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
    gtk_widget_show(label);
    
    label = gtk_label_new("Applications");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), vbox, label);
}

void CreateProxyPage(void)
{
    GtkWidget *label, *line;
    char buffer[256];

    ProxyTable = gtk_table_new(4, 2, FALSE);
    gtk_widget_show(ProxyTable);
    
    label = gtk_label_new("HTTP proxy host name:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(ProxyTable), label, 0, 1, 0, 1);
    gtk_widget_show(label);
    
    ProxyHostName = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(ProxyHostName), DX_ProxyHostName);
    gtk_table_attach_defaults(GTK_TABLE(ProxyTable), ProxyHostName,
                              1, 2, 0, 1);
    gtk_widget_show(ProxyHostName);

    label = gtk_label_new("HTTP proxy port:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(ProxyTable), label, 0, 1, 1, 2);
    gtk_widget_show(label);
    
    ProxyPort = gtk_entry_new();
    sprintf(buffer, "%d", DX_ProxyPort);
    gtk_entry_set_text(GTK_ENTRY(ProxyPort), buffer);
    gtk_table_attach_defaults(GTK_TABLE(ProxyTable), ProxyPort, 1, 2, 1, 2);
    gtk_widget_show(ProxyPort);
    
    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(ProxyTable), line, 0, 2, 2, 3);
    gtk_widget_show(line);
    
    label = gtk_label_new("If you need to use a proxy when you download\n"
                          "files via HTTP, then enter its host name and\n"
                          "port number (the default is 80) above.");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(ProxyTable), label, 0, 2, 3, 4);
    
    label = gtk_label_new("Proxy");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), ProxyTable, label);
}

void CreateMassivePage(void)
{
    GtkWidget *label, *line;
    char buffer[256];

    MassiveTable = gtk_table_new(6, 2, FALSE);
    gtk_widget_show(MassiveTable);
    
    MassiveDownloadCheck =
        gtk_check_button_new_with_label("Enable massive download");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(MassiveDownloadCheck),
                                DX_EnableMassiveDownload);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), MassiveDownloadCheck,
                              1, 2, 0, 1);
    gtk_widget_show(MassiveDownloadCheck);

    MassiveAutoMirrorCheck =
        gtk_check_button_new_with_label("Use mirrors");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(MassiveAutoMirrorCheck),
                                DX_EnableMassiveAutoMirror);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), MassiveAutoMirrorCheck,
                              1, 2, 1, 2);
    gtk_widget_show(MassiveAutoMirrorCheck);
    
    label = gtk_label_new("Massive download files over (KB):");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), label, 0, 1, 2, 3);
    gtk_widget_show(label);
    
    MassiveLimitEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_MassiveLimit);
    gtk_entry_set_text(GTK_ENTRY(MassiveLimitEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), MassiveLimitEntry,
                              1, 2, 2, 3);
    gtk_widget_show(MassiveLimitEntry);
    
    label = gtk_label_new("Maximum no. of extra connections:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), label, 0, 1, 3, 4);
    gtk_widget_show(label);
    
    MassiveMaxConnectionsEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_MassiveMaxConnections);
    gtk_entry_set_text(GTK_ENTRY(MassiveMaxConnectionsEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable),
                              MassiveMaxConnectionsEntry, 1, 2, 3, 4);
    gtk_widget_show(MassiveMaxConnectionsEntry);
    
    label = gtk_label_new("Connect again every (KB):");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), label, 0, 1, 4, 5);
    gtk_widget_show(label);
    
    MassiveConnectAgainLimitEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_MassiveConnectAgainLimit);
    gtk_entry_set_text(GTK_ENTRY(MassiveConnectAgainLimitEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable),
                              MassiveConnectAgainLimitEntry, 1, 2, 4, 5);
    gtk_widget_show(MassiveConnectAgainLimitEntry);
    
    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), line, 0, 2, 5, 6);
    gtk_widget_show(line);
    
    label = gtk_label_new("\"Massive Download\" enables very fast file "
                          "transfer via FTP or HTTP.\nExtra connections "
                          "will be opened to the server as specified above."
                          "\n");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(MassiveTable), label, 0, 2, 6, 7);
    
    label = gtk_label_new("Massive D/L");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), MassiveTable, label);
}

void CreateLoggingPage(void)
{
    GtkWidget *label, *line;

    LoggingTable = gtk_table_new(3, 3, FALSE);
    gtk_widget_show(LoggingTable);
    
    label = gtk_label_new("File log filename:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), label, 0, 1, 0, 1);
    gtk_widget_show(label);
    
    FileLogEntry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(FileLogEntry), DX_FileLogName);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), FileLogEntry,
                              1, 2, 0, 1);
    gtk_widget_show(FileLogEntry);

    ClearFileLogButton = gtk_button_new_with_label("Clear");
    gtk_signal_connect(GTK_OBJECT(ClearFileLogButton), "clicked",
                      GTK_SIGNAL_FUNC(ClearFileLog), (gpointer)FileLogEntry);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), ClearFileLogButton,
                              2, 3, 0, 1);
    gtk_widget_show(ClearFileLogButton);

    FileLoggingCheck =
        gtk_check_button_new_with_label("Enable file logging");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(FileLoggingCheck),
                                DX_EnableFileLogging);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), FileLoggingCheck,
                              1, 2, 1, 2);
    gtk_widget_show(FileLoggingCheck);
    
    ClearFileLogCheck =
        gtk_check_button_new_with_label("Clear file log on exit");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(ClearFileLogCheck),
                                DX_ClearFileLogOnExit);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), ClearFileLogCheck,
                              1, 2, 2, 3);
    gtk_widget_show(ClearFileLogCheck);
    
    LeaveCompleteFilesCheck =
        gtk_check_button_new_with_label("Leave complete files in batch");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(LeaveCompleteFilesCheck),
                                DX_LeaveCompleteFiles);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), LeaveCompleteFilesCheck,
                              1, 2, 3, 4);
    gtk_widget_show(LeaveCompleteFilesCheck);
    
    ErrorLoggingCheck =
        gtk_check_button_new_with_label("Enable error logging [DEBUG ONLY]");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(ErrorLoggingCheck),
                                DX_EnableErrorLogging);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), ErrorLoggingCheck,
                              1, 2, 4, 5);
    gtk_widget_show(ErrorLoggingCheck);
    
    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), line, 0, 3, 5, 6);
    gtk_widget_show(line);
    
    label = gtk_label_new("If you enter a filename in the \"file log\" box, "
                          "whenever a file\n finishes transferring, an entry "
                          "will be made in the filename specified. It will\n"
                          "automatically be cleared when the daemon exits if "
                          "you check the relevant check-box."
                          "\nOnly enable error logging if you need to for "
                          "debugging purposes.");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(LoggingTable), label, 0, 3, 6, 7);
    
    label = gtk_label_new("Logging");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), LoggingTable, label);
}

void CreateMisc1Page(void)
{
    char buffer[256];
    GtkWidget *label, *line;

    Misc1Table = gtk_table_new(6, 2, FALSE);
    gtk_widget_show(Misc1Table);
    
    label = gtk_label_new("Listen on port:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), label, 0, 1, 0, 1);
    gtk_widget_show(label);
    
    RemotePortEntry = gtk_entry_new();
    if (DX_ListenPort > 0)
    {
        sprintf(buffer, "%d", DX_ListenPort);
        gtk_entry_set_text(GTK_ENTRY(RemotePortEntry), buffer);
    }
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), RemotePortEntry,
                              1, 2, 0, 1);
    gtk_widget_show(RemotePortEntry);
	
    label = gtk_label_new("Sleep interval:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), label, 0, 1, 1, 2);
    gtk_widget_show(label);
    
    SleepIntervalEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_SleepInterval);
    gtk_entry_set_text(GTK_ENTRY(SleepIntervalEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), SleepIntervalEntry,
                              1, 2, 1, 2);
    gtk_widget_show(SleepIntervalEntry);
	
    label = gtk_label_new("Output to file:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), label, 0, 1, 2, 3);
    gtk_widget_show(label);
    
    OutputToFileEntry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(OutputToFileEntry), DX_OutputToFile);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), OutputToFileEntry,
                              1, 2, 2, 3);
    gtk_widget_show(OutputToFileEntry);
	
    label = gtk_label_new("Output to program:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), label, 0, 1, 3, 4);
    gtk_widget_show(label);
    
    OutputToProgramEntry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(OutputToProgramEntry), DX_OutputToProgram);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), OutputToProgramEntry,
                              1, 2, 3, 4);
    gtk_widget_show(OutputToProgramEntry);
	
    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), line, 0, 2, 4, 5);
    gtk_widget_show(line);
    
    label = gtk_label_new("If you want to run Darxite with remote clients, "
                          "set the \"listen on port\"\nvalue to the port you "
                          "want them to connect to.\n"
                          "\"Sleep interval\" is how frequently, in seconds, "
                          "the daemon should\ntry to start downloading files."
                          "\nEnter something in the two \"output\" fields if "
                          "you want the daemon to send its\n(text) output to a"
                          " file or a program.");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(Misc1Table), label, 0, 2, 5, 6);
    
    label = gtk_label_new("Misc 1");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), Misc1Table, label);
}

void CreateMisc2Page(void)
{
    GtkWidget *label, *line;
    char buffer[256];

    Misc2Table = gtk_table_new(7, 2, FALSE);
    gtk_widget_show(Misc2Table);
    
    DetectPrematureCompletionCheck =
        gtk_check_button_new_with_label("Detect premature completion");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(
        DetectPrematureCompletionCheck),
                                DX_DetectPrematureCompletion);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table),
                              DetectPrematureCompletionCheck,
                              1, 2, 0, 1);
    gtk_widget_show(DetectPrematureCompletionCheck);
    
    DisconnectCheck =
        gtk_check_button_new_with_label("Disconnect on batch completion");
    gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(DisconnectCheck),
                                DX_DisconnectOnCompletion);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), DisconnectCheck,
                              1, 2, 1, 2);
    gtk_widget_show(DisconnectCheck);
	
    label = gtk_label_new("Disconnect program:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), label, 0, 1, 2, 3);
    gtk_widget_show(label);
    
    DisconnectCommandEntry = gtk_entry_new();
    gtk_entry_set_text(GTK_ENTRY(DisconnectCommandEntry),
					   DX_DisconnectCommand);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), DisconnectCommandEntry,
                              1, 2, 2, 3);
    gtk_widget_show(DisconnectCommandEntry);
    
    label = gtk_label_new("Buffer size:");
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_RIGHT);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), label, 0, 1, 3, 4);
    gtk_widget_show(label);
    
    BufferSizeEntry = gtk_entry_new();
    sprintf(buffer, "%d", DX_BufferSize);
    gtk_entry_set_text(GTK_ENTRY(BufferSizeEntry), buffer);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), BufferSizeEntry,
                              1, 2, 3, 4);
    gtk_widget_show(BufferSizeEntry);
    
    line = gtk_hseparator_new();
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), line, 0, 2, 4, 5);
    gtk_widget_show(line);
    
    label = gtk_label_new("If you would like Darxite to automatically "
						  "disconnect from the Internet \nwhen all files "
						  "are complete, check the check box and enter the "
						  "name \nof the command to run to disconnect.\n"
                          "Increase the buffer size for better performance, "
                          "decrease it\nfor lower memory usage.");
    gtk_widget_show(label);
    gtk_table_attach_defaults(GTK_TABLE(Misc2Table), label, 0, 2, 5, 6);
    
    label = gtk_label_new("Misc 2");
    gtk_notebook_append_page(GTK_NOTEBOOK(Notebook), Misc2Table, label);
}

void close_window(void)
{
    gtk_main_quit();
}

int main(int argc, char *argv[])
{
    char buffer[256];
    
    gtk_init(&argc, &argv);
    DX_ReadConfigFiles();
    sprintf(buffer, "%s/conf", DX_ProgDir);
    DotFileName = strdup(buffer);
    sprintf(buffer, "%s/darxite.conf", DX_GlobalConfigPath());
    EtcFileName = strdup(buffer);
    
    Window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(Window), "Darxite Control Centre");
    // allow the window to grow or shrink automatically
    gtk_window_set_policy(GTK_WINDOW(Window), FALSE, FALSE, TRUE);
    gtk_window_position(GTK_WINDOW(Window), GTK_WIN_POS_CENTER);
    gtk_container_border_width(GTK_CONTAINER(Window), 10);
    gtk_signal_connect(GTK_OBJECT(Window), "delete_event",
                       GTK_SIGNAL_FUNC(close_window), NULL);
    
    MainVbox = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(Window), MainVbox);
    gtk_widget_show(MainVbox);
    
    Notebook = gtk_notebook_new();
    gtk_box_pack_start(GTK_BOX(MainVbox), Notebook, TRUE, TRUE, 0);
    gtk_widget_show(Notebook);
    
    CreateTransferPage();
    CreateMirroringPage();
    CreateAppsPage();
    CreateProxyPage();
    CreateMassivePage();
    CreateLoggingPage();
    CreateMisc1Page();
	CreateMisc2Page();
    
    ButtonBox = gtk_hbox_new(TRUE, 5);
    gtk_box_pack_start(GTK_BOX(MainVbox), ButtonBox, FALSE, FALSE, 0);
    gtk_widget_show(ButtonBox);
    
    SaveDotFileButton = gtk_button_new_with_label("Save personal config");
    gtk_signal_connect(GTK_OBJECT(SaveDotFileButton), "clicked",
                      GTK_SIGNAL_FUNC(WritePrefs), (gpointer)DotFileName);
    gtk_box_pack_start(GTK_BOX(ButtonBox), SaveDotFileButton,
                       TRUE, TRUE, 0);
    gtk_widget_show(SaveDotFileButton);
    
    SaveEtcFileButton = gtk_button_new_with_label("Save system config");
    gtk_signal_connect(GTK_OBJECT(SaveEtcFileButton), "clicked",
                      GTK_SIGNAL_FUNC(WritePrefs), (gpointer)EtcFileName);
    gtk_box_pack_start(GTK_BOX(ButtonBox), SaveEtcFileButton,
                       TRUE, TRUE, 0);
    gtk_widget_show(SaveEtcFileButton);

    UpdateDaemonButton = gtk_button_new_with_label("Update daemon");
    gtk_signal_connect(GTK_OBJECT(UpdateDaemonButton), "clicked",
                      GTK_SIGNAL_FUNC(UpdateDaemon), NULL);
    gtk_box_pack_start(GTK_BOX(ButtonBox), UpdateDaemonButton,
                       TRUE, TRUE, 0);
    gtk_widget_show(UpdateDaemonButton);
    
    ExitButton = gtk_button_new_with_label("Exit");
    gtk_signal_connect(GTK_OBJECT(ExitButton), "clicked",
                             GTK_SIGNAL_FUNC(close_window), NULL);
    gtk_box_pack_start(GTK_BOX(ButtonBox), ExitButton, TRUE, TRUE, 0);
    gtk_widget_show(ExitButton);
    
    gtk_widget_show(Window);
    gtk_main();
    return 0;
}
