// File dealing with pop-up dialogues

#include "global.h"
#include "dialogues.h"
#include "commands.h"
#include "main.h"

static void confirm_ok(GtkWidget *widget)
{
    gtk_grab_remove(ConfirmationDialogue);
    gtk_widget_hide(ConfirmationDialogue);
    if ((widget == ConfirmOk) && (ConfirmCallback != NULL))
        ConfirmCallback();
}

static void yes_no_cancel_done(GtkWidget *widget, gpointer data)
{
    gtk_grab_remove(YesNoCancel.Dialogue);
    gtk_widget_hide(YesNoCancel.Dialogue);
    YesNoCancelCallback((int)data);
}

static void input_ok(GtkWidget *widget, gpointer data)
{
    gtk_grab_remove(InputDialogue);
    gtk_widget_hide(InputDialogue);
    // if the "OK" button was clicked on
    if ((int)data == TRUE)
    {
        strncpy(InputBuffer, gtk_entry_get_text(GTK_ENTRY(InputEntry)),
                sizeof(InputBuffer));
        InputCallback(InputBuffer);
    }
    else
    {
        InputCallback(NULL);
    }
}

void CreateConfirmationDialogue(void)
{
    ConfirmationDialogue = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(ConfirmationDialogue), "NoctFTP");
    gtk_window_position(GTK_WINDOW(ConfirmationDialogue), GTK_WIN_POS_CENTER);
    gtk_container_set_border_width(GTK_CONTAINER(ConfirmationDialogue), 5);
    gtk_window_set_policy(GTK_WINDOW(ConfirmationDialogue),
                          FALSE, FALSE, FALSE);

    ConfirmFrame = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(ConfirmationDialogue), ConfirmFrame);
    gtk_widget_show(ConfirmFrame);
    
    ConfirmLabel = gtk_label_new("Confirm action");
    gtk_box_pack_start(GTK_BOX(ConfirmFrame), ConfirmLabel, TRUE, FALSE, 0);
    gtk_widget_show(ConfirmLabel);

    ConfirmButtonBox = gtk_hbox_new(TRUE, 5);
    gtk_box_pack_start(GTK_BOX(ConfirmFrame), ConfirmButtonBox,
                       FALSE, FALSE, 5);
    gtk_widget_show(ConfirmButtonBox);
    
    ConfirmOk = gtk_button_new_with_label("OK");
    gtk_box_pack_start(GTK_BOX(ConfirmButtonBox), ConfirmOk, TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(ConfirmOk), "clicked",
                       GTK_SIGNAL_FUNC(confirm_ok), NULL);
    gtk_widget_show(ConfirmOk);

    ConfirmCancel = gtk_button_new_with_label("Cancel");
    gtk_box_pack_start(GTK_BOX(ConfirmButtonBox), ConfirmCancel,
                       TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(ConfirmCancel), "clicked",
                       GTK_SIGNAL_FUNC(confirm_ok), NULL);
    gtk_widget_show(ConfirmCancel);
}

void CreateYesNoCancelDialogue(void)
{
    YesNoCancel.Dialogue = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(YesNoCancel.Dialogue), "NoctFTP");
    gtk_window_position(GTK_WINDOW(YesNoCancel.Dialogue), GTK_WIN_POS_CENTER);
    gtk_container_set_border_width(GTK_CONTAINER(YesNoCancel.Dialogue), 5);
    gtk_window_set_policy(GTK_WINDOW(YesNoCancel.Dialogue),
                          FALSE, FALSE, FALSE);

    YesNoCancel.Frame = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(YesNoCancel.Dialogue), YesNoCancel.Frame);
    gtk_widget_show(YesNoCancel.Frame);
    
    YesNoCancel.Label = gtk_label_new("Confirm action");
    gtk_box_pack_start(GTK_BOX(YesNoCancel.Frame), YesNoCancel.Label, TRUE,
                       FALSE, 0);
    gtk_widget_show(YesNoCancel.Label);
    
    YesNoCancel.ButtonBox = gtk_hbox_new(TRUE, 5);
    gtk_box_pack_start(GTK_BOX(YesNoCancel.Frame), YesNoCancel.ButtonBox,
                       FALSE, FALSE, 5);
    gtk_widget_show(YesNoCancel.ButtonBox);
    
    YesNoCancel.Button1 = gtk_button_new_with_label("Yes");
    gtk_box_pack_start(GTK_BOX(YesNoCancel.ButtonBox), YesNoCancel.Button1,
                       TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(YesNoCancel.Button1), "clicked",
                       GTK_SIGNAL_FUNC(yes_no_cancel_done), 0);
    gtk_widget_show(YesNoCancel.Button1);
    
    YesNoCancel.Button2 = gtk_button_new_with_label("No");
    gtk_box_pack_start(GTK_BOX(YesNoCancel.ButtonBox), YesNoCancel.Button2,
                       TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(YesNoCancel.Button2), "clicked",
                       GTK_SIGNAL_FUNC(yes_no_cancel_done), (gpointer)1);
    gtk_widget_show(YesNoCancel.Button2);
    
    YesNoCancel.Cancel = gtk_button_new_with_label("Cancel");
    gtk_box_pack_start(GTK_BOX(YesNoCancel.ButtonBox), YesNoCancel.Cancel,
                       TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(YesNoCancel.Cancel), "clicked",
                       GTK_SIGNAL_FUNC(yes_no_cancel_done), (gpointer)2);
    gtk_widget_show(YesNoCancel.Cancel);
}

void CreateInputDialogue(void)
{
    InputDialogue = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(InputDialogue), "NoctFTP");
    gtk_widget_set_usize(InputDialogue, 300, 100);
    gtk_window_position(GTK_WINDOW(InputDialogue), GTK_WIN_POS_CENTER);
    gtk_window_set_policy(GTK_WINDOW(InputDialogue), FALSE, FALSE, FALSE);
    gtk_container_border_width(GTK_CONTAINER(InputDialogue), 10);
    
    InputFrame = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(InputDialogue), InputFrame);
    gtk_widget_show(InputFrame);

    InputLabel = gtk_label_new("Enter input:");
    gtk_box_pack_start(GTK_BOX(InputFrame), InputLabel, FALSE, FALSE, 0);
    gtk_widget_show(InputLabel);

    InputEntry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(InputFrame), InputEntry, FALSE, FALSE, 0);
    gtk_widget_show(InputEntry);

    InputButtonRow = gtk_hbox_new(TRUE, 5);
    gtk_box_pack_start(GTK_BOX(InputFrame), InputButtonRow, FALSE, FALSE, 0);
    gtk_widget_show(InputButtonRow);

    InputOk = gtk_button_new_with_label("OK");
    gtk_box_pack_start(GTK_BOX(InputButtonRow), InputOk, TRUE, TRUE, 5);
    gtk_widget_show(InputOk);
    gtk_signal_connect_object(GTK_OBJECT(InputEntry), "activate",
                              GTK_SIGNAL_FUNC(gtk_button_clicked),
                              GTK_OBJECT(InputOk));
    gtk_signal_connect(GTK_OBJECT(InputOk), "clicked",
                       GTK_SIGNAL_FUNC(input_ok), (gpointer)TRUE);
    
    InputCancel = gtk_button_new_with_label("Cancel");
    gtk_box_pack_start(GTK_BOX(InputButtonRow),
                       InputCancel, TRUE, TRUE, 5);
    gtk_signal_connect(GTK_OBJECT(InputCancel), "clicked",
                       GTK_SIGNAL_FUNC(input_ok), (gpointer)FALSE);
    gtk_widget_show(InputCancel);
}

void CreateViewDialogue(void)
{
    ViewDialogue = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_window_set_title(GTK_WINDOW(ViewDialogue), "View file");
    gtk_widget_set_usize(ViewDialogue, 500, 350);
    gtk_container_set_border_width(GTK_CONTAINER(ViewDialogue), 10);
    gtk_window_position(GTK_WINDOW(ViewDialogue), GTK_WIN_POS_CENTER);
    gtk_window_set_policy(GTK_WINDOW(ViewDialogue), TRUE, TRUE, FALSE);
    
    ViewFrame = gtk_vbox_new(FALSE, 5);
    gtk_container_add(GTK_CONTAINER(ViewDialogue), ViewFrame);
    gtk_widget_show(ViewFrame);

    ViewTextFrame = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ViewFrame), ViewTextFrame, TRUE, TRUE, 0);
    gtk_widget_show(ViewTextFrame);
    
    ViewText = gtk_text_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(ViewTextFrame), ViewText, TRUE, TRUE, 0);
    gtk_widget_show(ViewText);
    
    ViewScrollBar = gtk_vscrollbar_new(GTK_TEXT(ViewText)->vadj);
    gtk_box_pack_start(GTK_BOX(ViewTextFrame), ViewScrollBar, FALSE, FALSE, 0);
    gtk_widget_show(ViewScrollBar);
    
    ViewButtonRow = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(ViewFrame), ViewButtonRow, FALSE, FALSE, 5);
    gtk_widget_show(ViewButtonRow);
    
    ViewOk = gtk_button_new_with_label("Exit");
    GTK_WIDGET_SET_FLAGS(ViewOk, GTK_CAN_DEFAULT);
    gtk_window_set_default(GTK_WINDOW(ViewDialogue), ViewOk);
    
    gtk_box_pack_end(GTK_BOX(ViewButtonRow), ViewOk, TRUE, TRUE, 5);
    gtk_signal_connect_object(GTK_OBJECT(ViewOk), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_hide),
                              GTK_OBJECT(ViewDialogue));
    gtk_widget_show(ViewOk);
}

void ConfirmAction(void (*callback)(void), const char *label)
{
    gtk_label_set(GTK_LABEL(ConfirmLabel), label);
    ConfirmCallback = callback;
    gtk_grab_add(ConfirmationDialogue);
    gtk_widget_show(ConfirmationDialogue);
}

void YesNoCancelShow(void (*callback)(int index), const char *label,
                     const char *text1, const char *text2)
{
    gtk_label_set(GTK_LABEL(YesNoCancel.Label), label);
    gtk_label_set(GTK_LABEL(GTK_BIN(YesNoCancel.Button1)->child), text1);
    gtk_label_set(GTK_LABEL(GTK_BIN(YesNoCancel.Button2)->child), text2);
    YesNoCancelCallback = callback;
    gtk_grab_add(YesNoCancel.Dialogue);
    gtk_widget_show(YesNoCancel.Dialogue);
}

char *GetInput(void (*callback)(const char *), const char *label,
               const char *entry_text)
{
    gtk_label_set(GTK_LABEL(InputLabel), label);
    gtk_entry_set_text(GTK_ENTRY(InputEntry), entry_text);
    InputCallback = callback;
    gtk_widget_show(InputDialogue);
    gtk_widget_grab_focus(InputEntry);
    gtk_grab_add(InputDialogue);
    return NULL;
}

void ViewFile(const char *file)
{
    FILE *fp = fopen(file, "r");
    char buffer[256];

    if (fp == NULL)
    {
        AddFtpString(strerror(errno));
        return;
    }
    gtk_window_set_title(GTK_WINDOW(ViewDialogue), file);
    gtk_widget_show(ViewDialogue);
    gtk_text_freeze(GTK_TEXT(ViewText));
    gtk_text_set_point(GTK_TEXT(ViewText), 0);
    gtk_text_forward_delete(GTK_TEXT(ViewText),
                            gtk_text_get_length(GTK_TEXT(ViewText)));
    while (fgets(buffer, sizeof(buffer), fp))
        gtk_text_insert(GTK_TEXT(ViewText), NULL, NULL, NULL, buffer, -1);
    fclose(fp);
    gtk_text_thaw(GTK_TEXT(ViewText));
}
