// File dealing with pixmaps

#include "global.h"
#include "main.h"
#include "xpm.h"

#include "xpms/archive.xpm"
#include "xpms/doc.xpm"
#include "xpms/exec.xpm"
#include "xpms/file.xpm"
#include "xpms/folder.xpm"
#include "xpms/html.xpm"
#include "xpms/link.xpm"
#include "xpms/redhat.xpm"
#include "xpms/mainicon.xpm"
#include "xpms/paint.xpm"
#include "xpms/penguin.xpm"
#include "xpms/socket.xpm"
#include "xpms/spin.xpm"
#include "xpms/up.xpm"

void create_list_icon(GdkPixmap **icon, gchar **xpm);
void create_normal_icon(GdkPixmap **icon, gchar **xpm);

void create_list_icon(GdkPixmap **icon, gchar **xpm)
{
    GdkBitmap *bitmap;
    GtkStyle *style;
    
    style = gtk_widget_get_style(Lister[LOCAL]);
    *icon = gdk_pixmap_create_from_xpm_d(Window->window, &bitmap,
                                         &style->bg[GTK_STATE_PRELIGHT],
                                         (gchar **)xpm);
}

void create_normal_icon(GdkPixmap **icon, gchar **xpm)
{
    GdkBitmap *bitmap;
    GtkStyle *style;
    
    style = gtk_widget_get_style(Window);
    *icon = gdk_pixmap_create_from_xpm_d(Window->window, &bitmap,
                                         &style->bg[GTK_STATE_NORMAL],
                                         (gchar **)xpm);
}

void CreatePixmaps(void)
{
    create_list_icon(&ArchiveIcon, archive_xpm);
    create_list_icon(&DocIcon, doc_xpm);
    create_list_icon(&ExecIcon, exec_xpm);
    create_list_icon(&FileIcon, file_xpm);
    create_list_icon(&FolderIcon, folder_xpm);
    create_list_icon(&HtmlIcon, html_xpm);
    create_list_icon(&LinkIcon, link_xpm);
    create_normal_icon(&MainIcon, mainicon_xpm);
    create_list_icon(&PaintIcon, paint_xpm);
    create_normal_icon(&PenguinIcon, penguin_xpm);
    create_list_icon(&RedhatIcon, redhat_xpm);
    create_list_icon(&SocketIcon, socket_xpm);
    create_normal_icon(&SpinIcon, spin_xpm);
    create_list_icon(&UpIcon, up_xpm);
}

void SelectIcon(const char *filename, const char *perms, GtkWidget *widget,
                int row)
{
    char buffer[256];
    int i;
    
    if (!filename || !perms || !widget)
        return;

    memset(buffer, 0, 256);
    for (i = 0; i < strlen(filename); i++)
        buffer[i] = tolower(filename[i]);
    if (!strcmp(buffer, "../"))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, UpIcon, NULL);
    else if (*perms == 'l')
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, LinkIcon, NULL);
    else if ((buffer[strlen(buffer) - 1] == '/') || (*perms == 'd'))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, FolderIcon, NULL);
    else if (strchr(perms, 'x'))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, ExecIcon, NULL);
    else if (strstr(buffer, ".rpm"))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, RedhatIcon, NULL);
    else if (strstr(buffer, ".gz") || strstr(buffer, ".zip") ||
             strstr(buffer, ".tgz") || strstr(buffer, ".z") ||
             strstr(buffer, ".deb") || strstr(buffer, ".bz2"))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, ArchiveIcon, NULL);
    else if (strstr(buffer, "readme") || strstr(buffer, ".txt") ||
             strstr(buffer, ".doc"))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, DocIcon, NULL);
    else if (strstr(buffer, ".htm") || strstr(buffer, ".shtml"))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, HtmlIcon, NULL);
    else if (strstr(buffer, ".gif") || strstr(buffer, ".jpeg") ||
             strstr(buffer, ".jpg") || strstr(buffer, ".xpm") ||
             strstr(buffer, ".png") || strstr(buffer, ".xcf"))
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, PaintIcon, NULL);
    else
        gtk_clist_set_pixmap(GTK_CLIST(widget), row, 0, FileIcon, NULL);
}
