#!/usr/bin/perl
#
# $RCSfile: lycos.pl,v $
# $Description: This script does a search on the ftpsearch.lycos.com and
#               returns the list of sites, paths, sizes and locations $
# $Library: search$
# $Revision: 1.3 $
# $Author: sandy $
# $Log: lycos.pl,v $
# Revision 1.3  1999/02/13 04:47:54  sandy
# Added the GNU license to all files and cleaned up the headers.
#
# -------------------------------------------------------------------
#  Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
# 
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
# 
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
# 
#  You should have received a copy of the GNU Library General Public
#  License along with this library; if not, write to the
#  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#  Boston, MA 02111-1307, USA.
# 
# $Id: lycos.pl,v 1.3 1999/02/13 04:47:54 sandy Exp $

use strict;

################## Configurable parameters ####################

# Host that will do the search for us.
my $host="ftpsearch.lycos.com";

# Default number of maximum hits to return
my $default_hits=50;

# URL path required to send to the host to get it to do the searches for us.
# The __FILE__ is replaced by the file that we are looking for.

my $urlpath="/cgi-bin/search?form=medium&query=__FILE__&doit=Search&type=Exact+search&hits=__HITS__&matches=&hitsprmatch=&limdom=&limpath=&f1=Count&f2=Size&f3=Host&f4=Date&f5=Path&f6=-&header=none&sort=none&;trlen=64";

#################### End Of Configuration ########################

sub TCP { join("", getprotobyname('tcp')); }
sub SOCK_STREAM { 1; }
sub AF_INET { 2; }
sub PF_INET { &AF_INET; }

# issues an HTTP GET request across the network and returns the resulting
# document on stdout. command line switches specify the server and document,
# as well as any other request arguments that are needed.


sub fetchdata {
  my( $server, $port, $file ) = @_;
  my @Headers = ("User-Agent", "vcs-get/0.1");
  my $document = "$file";
  my( $dummy, @addrs );

  if ($server =~ /^[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+$/) {
    @addrs = pack('C4', split(/\./,$server));
  } else {
    ($dummy,$dummy,$dummy,$dummy, @addrs) = gethostbyname($server);
  }
  my $remote = pack("S n a4 x8", &AF_INET, $port, $addrs[0]);
  socket(S, &PF_INET, &SOCK_STREAM, &TCP) || die "socket: $!";
  connect(S, $remote) || die "connect: $!";
  select(S); $| = 1;
  select(STDOUT); $| = 1;

  my $request = "GET $document HTTP/1.0\r\n";
  while ($#Headers > 0) {
    $request = $request . "$Headers[0]: $Headers[1]\r\n";
    shift(@Headers); shift(@Headers);
  }
  $request = $request . "\r\n";
  print(S $request);

  my $big = 1024*1024;
  my $state = 0;

  my $response = "";
  my ( $data, $len );
  while ($len = sysread(S, $data, $big)) {
	#Store the entire thing in a big string and parse it later.
	$response .= $data;
  }  
  close(S);
	
  return $response;
}

sub searchx
{
	my @retval = undef;
	open( NP, "< xyz" );
	while(<NP>) {
	   push ( @retval, "$_" );
	}
	close(NP);
	return @retval;
}

sub search
{
	my( $file, $num_hits ) = @_;

	my @retval = undef;

	$num_hits = $default_hits unless( $num_hits );

	# Create the search string to send to the ftpsearch engine.
	$urlpath =~ s/__FILE__/$file/g;

	# Plug in the number of hits.
	$urlpath =~ s/__HITS__/$num_hits/g;

	#Go get the data we need.
	my $r = &fetchdata( $host, 80, $urlpath );

	#Parse the output returned and retrieve only the lines we need.
	my @lines = split( /\n/, $r );

	my( $line );
	foreach $line (@lines) {

		#Remove all the <> stuff.
		$line =~ s/<[^>]*>//g;
		#remove the spaces in the front.
		$line =~ s/^\s+//;

		my @f = split( /\s+/, $line );
		if( $#f >= 6 && $f[0] =~ /^\d+$/ ) {
		   #printf ( "$f[2]|$f[6]|$f[1]|$f[3] $f[4] $f[5]\n" );
		   push ( @retval, "$f[2]|$f[6]|$f[1]|$f[3] $f[4] $f[5]" );
			
		}
	}

	return @retval;
}

__END__

# Main function stays out and simply parses the output of the url.. #
if( ! $ARGV[0] ) {
    die "usage: ftpsearch.pl filename [num-hits]";
}

if( $ARGV[1] =~ /\d+/ ) {
    $default_hits=$ARGV[1];
} 

&search( $ARGV[0] );
