#ifndef DAEMON_CLIENTS_H
#define DAEMON_CLIENTS_H

#include <sys/socket.h>
#include <sys/un.h>

#include "global.h"

#define MAX_CLIENTS		100

int DefaultClientSocket;
int NetClientSocket;

typedef struct _clientInfo {
    char Name[256];
    int Socket;
    BOOL Connected;
    BOOL NeedPassword;
    time_t ConnectionTime;
    char LastCmd[256];
    char Activity[256];
    ServerInfo *Server;
    int EventMask; // events to notify the client of
    struct _sockInfo *ControlSocket; // for FTP commands
    struct _sockInfo *DataSocket;
    struct _clientInfo *Next;
    struct _clientInfo *Prev;
} ClientInfo;
    
ClientInfo *FirstClient;
int ClientCount;

void CheckClientSockets(void);
void ClearClient(ClientInfo *client);
BOOL SetUpClientSocket(ClientInfo *client);
BOOL ReadClientCommands(ClientInfo *client);
BOOL ParseClientCommand(ClientInfo *client);
void DisconnectClient(ClientInfo *client);
int SendEvent(int event_id, const char *event_string);

void GetClientInfo(char *info_buffer, int buffer_length);

#endif
