#ifndef DAEMON_TRANSFER_H
#define DAEMON_TRANSFER_H

#include "global.h"
#include "buffer.h"

#define RESPONSE_MAX	8192
#define DATA_MAX	8192

#define FTP_ERROR_START	400

typedef struct _sockInfo {
    int FileDes;
    BOOL Connected;
    BOOL Connecting; 
    struct sockaddr_in Name;
    char HostName[256];
    char LastCmd[256];
    char *CmdResponse; /* malloc'd later! */
    char *DataBuf;     /* malloc'd later! */
    int DataLength;
    int DataWritten;
    int LastError;
    BOOL Transferring;
    BOOL MoreResponse;
    BOOL Eof;
} SockInfo;

extern int SocketCount;

BOOL ConnectMutexLocked;
MUTEX(ConnectMutex)

int TransferData(SockInfo *read_socks[], int read_sock_count,
                 SockInfo *write_socks[], int write_sock_count, int timeout);

void InitNetworking(void);
int sock_CreateNetSocket(int port);
int sock_SetSocketPid(int fd);
int sock_CreateDefaultSocket(void);
int sock_DestroyDefaultSocket(void);
int sock_DestroyNetSocket(int net_fd);
int Connect(const char *host, int port, char *activity, SockInfo **new_socket);
SockInfo *DataConnect(SockInfo *sock);
SockInfo *CreateSocket(void);
void FreeSocket(SockInfo **sock);

BOOL CancelTransfer(SockInfo *sock, const char *protocol);
BOOL Disconnect(SockInfo *sock, BOOL quick);
BOOL DataDisconnect(SockInfo *sock);
BOOL HttpDisconnect(SockInfo *sock);

int NetWrite(SockInfo *sock, const char *string, ...);
BOOL GetResponseLine(SockInfo *sock, char *buffer, int buffer_size);
int GetResponse(SockInfo *sock, char *response_buffer, int response_max);

#endif
