#ifndef DARXITE_H
#define DARXITE_H

// The top-level include for the Darxite project.

// Contains #defines, functions, etc. provided by the library which
// the daemon and all clients should be aware of.
// If you want to know what the stuff in this file means, read the file
// "develop.txt" in the root of the Darxite tree.

#define RELEASE_NAME "Agrajag"
#define RELEASE_VER  "0.4"

#include <includes.h> // needed for functions below

// some useful defines

#ifndef TRUE
#  define TRUE 1
#endif

#ifndef FALSE
#  define FALSE 0
#endif

#ifndef BOOL
  typedef unsigned char BOOL;
#endif

// returns the last character in a string
#define lastchr(x) (x[strlen(x) - 1])

// clears an array (NOT a pointer)
#define memclr(x) memset(x, 0, sizeof(x))

// copies one string into another safely - NOTE that
// the destination string must be an array previously zeroed
#define safecpy(x,y) strncpy(x, y, sizeof(x) - 1)

enum _dxErrors {
    // library error numbers
    DX_LIB_OK = 0,
    DX_LIB_TIMEOUT,
    DX_LIB_MORE_DATA,
    DX_LIB_ERROR,
    DX_LIB_DISCONNECTED,
    // events are 8xx
    DX_FILE_COMPLETION = 800,
    DX_CONFIG_RELOADED,
    DX_ERROR_EVENT,
    DX_REDIRECT_EVENT,
    DX_EXIT_EVENT,
    DX_NEW_FILE_EVENT,
    // responses are 85x+
    DX_FILE_STATUS = 850,
    DX_FAST_FILE_STATUS,
    DX_FILE_COUNT,
    // error numbers are 9xx
    DX_OK = 900,
    DX_ERROR,
    DX_E_BAD_COMMAND,
    DX_E_NETWORK,
    DX_E_DISCONNECTED,
    DX_E_FTP,
    DX_E_SOCKET,
    DX_E_LOOKUP,
    DX_E_CONNECT,
    DX_E_PASSWORD,
    DX_E_MORE_DATA
};

// Global variables, flags, etc.
char DX_HomeDir[256], DX_ProgDir[256];
char DX_OutputDir[256], DX_SpoolDir[256];
char DX_EMailAddress[256], DX_OutputToFile[256];
char DX_OutputToProgram[256], DX_FileLogName[256];
char DX_ProxyHostName[256], DX_DisconnectCommand[256];
int DX_MinRxBeforeSwitching, DX_TimeBeforeSwitching;
BOOL DX_EnableMirrors, DX_EnableSpooling;
BOOL DX_EnableReadingServerDB, DX_EnableWritingServerDB;
BOOL DX_EnableRenaming, DX_EnableOpenLocalFile;
BOOL DX_EnableErrorLogging, DX_EnableFileLogging;
BOOL DX_LeaveCompleteFiles, DX_ClearFileLogOnExit;
BOOL DX_DisconnectOnCompletion;
BOOL DX_DetectPrematureCompletion;
int DX_MassiveLimit, DX_MassiveMaxConnections;
BOOL DX_EnableMassiveDownload, DX_EnableMassiveAutoMirror;
int DX_MassiveConnectAgainLimit;
int DX_SleepInterval, DX_ListenPort;
int DX_ProxyPort, DX_MaxSimDownloads;
int DX_RemoveCompletedTime;
int DX_BufferSize;

// array of extensions (including .s) followed by program to run
char *DX_FileType[2][100];
int DX_FileTypeCount;

BOOL DX_QuietExit;
int DX_errno;

#define DEFAULT_SOCKET_FILE	"/tmp/darxsock"

#ifdef __cplusplus
extern "C" {
#endif

// Just a simple function to test the library :)

void DX_SayHello(void);

int DX_SetSocketPid(int fd);
int DX_ConnectClient(const char *name);
int DX_ConnectRemoteClient(const char *host, int port, const char *password,
                           const char *name);
int DX_DisconnectClient(int fd);

const char *DX_GlobalConfigPath(void);
const char *DX_BinPath(void);
void DX_ReadConfigFiles(void);
int DX_GetResponse(int fd, char *response, int response_max, int timeout);

typedef struct _dX_ClientInfo {
    char *Name;
    char *Path;
    char *Type;
    char *Description;
    struct _dX_ClientInfo *Next;
    struct _dX_ClientInfo *Prev;
} DX_ClientInfo;

int DX_ReadClientDB(DX_ClientInfo **client_list);
int DX_FindClients(const char *name, const char *type,
                   DX_ClientInfo *search_clients,
                   DX_ClientInfo **found_clients);
void DX_FreeClientList(DX_ClientInfo *client_list);

char *DX_CodeFromActivity(char *activity);
char *DX_ActivityFromCode(char *code);
    
int DX_ParseFileLogLine(const char *log_line, char *date, int date_max,
                        char *time, int time_max, char *protocol,
                        char *server, int server_max, char *path,
                        int path_max, char *local_path, int local_path_max,
                        int *current_size, int *total_size, int *total_time,
                        int *rate_overall, char *reason, int reason_max,
                        char *file_id);

int DX_ParseFileStatus(const char *status_line, char *protocol,
                       char *server, int server_max, char *path,
                       int path_max, char *local_path, int local_path_max,
                       int *current_size, int *total_size, int *total_time,
                       int *rate_overall, char *activity, int activity_max,
                       char *file_id);

int DX_ParseFileCount(const char *count_line, int *transfer_size,
                      int *total_size, int *transfer_count, int *total_count);

int DX_ParseFastFileStatus(const char *status_line, char *file_id,
                            int *current_size, int *total_size,
                            int *total_time, int *rate_overall,
                            char *activity);

int DX_ParseRedirectionEvent(const char *redirect_line, char *old_url,
                             int old_max, char *new_url, int new_max);
    
int DX_ParseUrl(const char *url, char *protocol, char *server,
                int server_max, char *path, int path_max);
char *DX_ReadFileLine(char *s, int size, FILE *stream);
char *DX_StripComments(char *line);
char *DX_GetNextField(char *line);

char *DX_StripControlChars(char *url);

/* util.c stuff */
#include <library/util.h>

#ifdef __cplusplus
}
#endif

#endif
