// Error logging facilities

#include "error.h"
#include <string.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <stdlib.h>

#define ERROR_FILE "lib-errors.txt"
static int did_header = 0;

void DX_Init_Logging()
{
}

static void dl_error_exit()
{
    dl_error(E_TRACE, "===End of error log===");
}

#ifdef LOGGING
static void dl_error_file(const char *error_str)
{
    static BOOL first_call = 0;
    char buffer[256];
    FILE *error_file;
    static char StartDir[256];

    if(!first_call) {
	first_call = TRUE;
	
	getcwd(StartDir, 256);
	unlink(ERROR_FILE);
	error_file = open(ERROR_FILE, O_RDWR|O_CREAT|O_TRUNC, 0644);

	if (error_file == -1)
	{
	    fprintf(stderr, "Couldn't open error log file!");
	    return;
	}

	close(error_file);
    }
    
    sprintf(buffer, "%s/%s", StartDir, ERROR_FILE);
    error_file = fopen(buffer, "a");
    if (error_file)
    {
        fputs(error_text, error_file);
        fclose(error_file);
    }
}
#else
static void dl_error_file(const char *error_str) { }
#endif

void dl_error(int level, const char *error_str, ...)
{
    va_list ap;
    char error_text[2048], print_text[2048];
#ifdef LOGGING
    char buffer[256];
    FILE *error_file;
#endif

    if (error_str == NULL)
        return;
   
    if(!did_header) {
	/* recurse to drop in the header */
	did_header = 1;
	dl_error(E_TRACE, "===Start of LIBRARY error log===");

	/* schedule the footer */
	atexit(dl_error_exit);
    }
    
    va_start(ap, error_str);
    vsnprintf(error_text, sizeof(error_text) - 1, error_str, ap);
    va_end(ap);

    strcat(error_text, "\n");
    dl_error_file(error_text);

    snprintf(print_text, sizeof(print_text), "\x1B[1mDX\x1B[0m: %s",
             error_text);
    if (level == E_INFO)
        printf(print_text);
    
    if (level < E_INFO)
        fprintf(stderr, print_text);
    
    if (level <= E_FAIL)
        exit(1);
}
