#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <getopt.h>
#include <gtk/gtk.h>
#include <sys/types.h>

#include "gfcc.h"

#include "Pics/open.xpm"
#include "Pics/open-system.xpm"
#include "Pics/save.xpm"
#include "Pics/export.xpm"
#include "Pics/export-grey.xpm"
#include "Pics/masq.xpm"
#include "Pics/apply.xpm"
#include "Pics/newchain.xpm"

#include "Pics/open-grey.xpm"
#include "Pics/save-grey.xpm"
#include "Pics/apply-grey.xpm"

#define NORM_KEY "norm"
#define GREY_KEY "grey"

#define WINDOWWIDTH 700
#define WINDOWHEIGHT 570

GtkWidget *notebook;
static void main_menu(GtkWidget *vbox);
static void toolbar_menu(GtkWidget *vbox);
static void exit_tryhelp(gchar *prgname);
static void about_window();

typedef struct _toolbar {
	char *label;
	char **pixmap;
	char **grey_pixmap;
	char *tooltip;
	void (*callback)();
	gpointer data;
	GtkWidget **store_to;
} ToolBar;

typedef struct _activator {
	GtkWidget **widget;
	int (*activator)();
} Activator;

GtkWidget *save_button;
GtkWidget *load_button;
GtkWidget *export_button;
GtkWidget *new_chain_button;
GtkWidget *load_system_button;
GtkWidget *masq_button;
GtkWidget *apply_button;

const ToolBar toolbardef[] = {
{ "Save", save_xpm, save_grey_xpm, "Save rules to file", save_to_file, NULL, &save_button },
{ "Load", open_xpm, open_grey_xpm, "Load rules from a file", load_from_file, NULL, &load_button },
{ " System ", open_system_xpm, open_grey_xpm, "Load rules from system", load_from_system, NULL, &load_system_button },
{ " Export ", export_xpm, export_grey_xpm, "Export this rule to bash shell script", export_to_file, NULL, &export_button },
{ "", NULL, NULL, NULL, NULL, NULL },
{ " New chain ", newchain, open_grey_xpm, "Create New chain", edit_chain_window, NEW, &new_chain_button },
{ "", NULL, NULL, NULL, NULL, NULL },
{ "Masq", masq_xpm, open_grey_xpm, "Masquerading list", masq_list, NULL, &masq_button },
{ "", NULL, NULL, NULL, NULL, NULL },
{ "Apply", apply_xpm, apply_grey_xpm, "Apply to system", save_fw_data, NULL, &apply_button },
{ NULL, NULL, NULL, NULL, NULL, NULL }
};

static GtkItemFactoryEntry menu_items[] = {
  { "/_File",			NULL,	NULL, 0, "<Branch>" },
  { "/File/Load from _File",	"<control>F",	load_from_file, 0, NULL },
  { "/File/Load from System",	NULL,	load_from_system, 0, NULL },
  { "/File/Save",		"<control>S",	save_to_file, 0, NULL },
  { "/File/Save as",		NULL,	save_as_to_file, 0, NULL },
  { "/File/Export",		NULL,	export_to_file, 0, NULL },
  { "/_File/sep1",		NULL,	NULL, 0, "<Separator>" },
  { "/File/_Quit",		"<control>Q",	program_quit, 0, NULL },
  { "/Sys_tem",			NULL,	NULL, 0, "<Branch>" },
  { "/System/New chain",	NULL,	edit_chain_window, 0, NULL },
  { "/System/Clear system rule",NULL,	dialog_clear_system, 0, NULL },
  { "/System/Apply to system",	NULL,	save_fw_data, 0, NULL },
  { "/System/Masquerading list",NULL,	masq_list, 0, NULL },
  { "/H_ost",			NULL,	NULL, 0, "<Branch>" },
  { "/Host/Edit host&network",	NULL,	call_select_host_window, 0, NULL },
  { "/Host/Reload host&network",NULL,	get_host_name, 0, NULL },
  { "/_Help",			NULL,	NULL, 0, "<LastBranch>" },
  { "/_Help/About",		NULL,	about_window, 0, NULL },
};

const gchar *help[] = {
	"",
	"Usage : gfcc [-sfc] [file]",
	"",
	"",
	" --silent  -s file : silent mode, read data from file and set",
	" --file    -f file : read data from file",
	" --clear   -c      : clear the system rules and chains",
	" --help    -h      : this message",
	"       No arg      : read from system",
	"",
	NULL,
};

GtkWidget *window;

int main (int argc, char *argv[])
{
	GtkWidget *vbox;
	GtkWidget *table;
	gchar *filename = NULL, procipchains[64], full_filename[128];
	struct option opts[] = {
		{ "silent", 1, 0, 's' },
		{ "file", 1, 0, 'f' },
		{ "clear", 1, 0, 'c' },
		{ "help", 0, 0, 'h' },
		{ 0 }
	};
	int ch;

	if(geteuid()) {
		fprintf(stderr, "Run as root !!!.\n");
		exit(1);
	}
	sprintf(procipchains, "/proc/net/%s", IP_FW_PROC_CHAIN_NAMES);
	if(access(procipchains, R_OK) < 0) {
		fprintf(stderr, "Your kernel doesn't support ipchains"
		                " or proc file system\n");
		exit(2);
	}

	while((ch = getopt_long(argc, argv, "s:f:ch", opts, NULL)) != -1) {
		switch(ch) {
		case 's':
			if(filename)
				exit_tryhelp(argv[0]);
			filename = optarg;
			if(!filename)
				filename = GFCC_HOME"/system.rule";
			get_fw_data(filename, 1);
			exit(0);
		case 'f':
			if(filename)
				exit_tryhelp(argv[0]);
			filename = optarg;
			break;
		case 'c':
			if(!clear_system())
				printf("%s\n", ipfwc_strerror(errno));
			exit(0);
		case 'h':
		default :
			exit_tryhelp(argv[0]);
		}
	}
	if(!filename && argc > 1)
		filename = argv[1];

#if defined(__GLIBC__) && __GLIBC__ == 2
	if(getenv("LANG"))
		gtk_set_locale();
#endif
	gtk_rc_add_default_file(GFCC_HOME"/gtkrc");
	gtk_init (&argc, &argv);

	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize( GTK_WIDGET (window), WINDOWWIDTH, WINDOWHEIGHT);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT (window), "destroy",
		(GtkSignalFunc) program_quit, NULL);
	gtk_signal_connect(GTK_OBJECT (window), "delete_event",
		(GtkSignalFunc) program_quit, NULL);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	main_menu(vbox);
	toolbar_menu(vbox); 
	
	table = gtk_table_new(1,1,FALSE);
	gtk_container_add(GTK_CONTAINER(vbox), table);

	gtk_container_set_border_width(GTK_CONTAINER(table), 10);
	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
	gtk_table_attach_defaults(GTK_TABLE(table), notebook, 0,1,0,1);
	gtk_widget_show(notebook);
	
	get_service_name();
	get_proto_name();
	get_host_name();

	if(filename && filename[0] != '/') {
		getcwd(full_filename, sizeof(full_filename));
		strcat(full_filename, "/");
		strcat(full_filename, filename);
		filename = full_filename;
	}
	get_fw_data(filename, 0);
	
	gtk_widget_show(table);
	gtk_widget_show(vbox);
	gtk_widget_show(window);
	
	chdir(GFCC_HOME"/rules");

	gtk_main ();

	return 0;
}

static void main_menu(GtkWidget *vbox)
{
	GtkWidget *menu_bar;
	int nmenu_items = sizeof(menu_items)/sizeof(menu_items[0]);
	GtkItemFactory *item_factory;
	GtkAccelGroup *accel_group;
	
	accel_group = gtk_accel_group_new();
	item_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>",
			accel_group);
	gtk_item_factory_create_items(item_factory, nmenu_items,
			menu_items, NULL);
	gtk_accel_group_attach(accel_group, GTK_OBJECT(window));

	menu_bar = gtk_item_factory_get_widget(item_factory, "<main>");

	gtk_box_pack_start(GTK_BOX(vbox), menu_bar, FALSE, FALSE, 2);
	gtk_widget_show(menu_bar);
}

static void toolbar_menu(GtkWidget *vbox)
{
	GtkWidget *toolbar;
	int i;
	
	toolbar = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_BOTH);
	gtk_box_pack_start(GTK_BOX(vbox), toolbar, FALSE, FALSE, 2);
	gtk_widget_show(toolbar);
	gtk_widget_realize(toolbar);
	
	gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
	for(i=0; toolbardef[i].label; i++) {
		if(!strlen(toolbardef[i].label)) {
			gtk_toolbar_append_space(GTK_TOOLBAR(toolbar));
		} else {
			GtkWidget *gtkpix = NULL, *gtkpix_grey = NULL;
			GtkWidget *tb_item;

			if(toolbardef[i].pixmap) {
				gtkpix = new_pixmap(toolbar,
						toolbardef[i].pixmap);
				gtk_widget_show(gtkpix);
				gtkpix_grey = new_pixmap(toolbar,
						toolbardef[i].grey_pixmap);
				gtk_widget_show(gtkpix_grey);
			}
			tb_item = gtk_toolbar_append_item(GTK_TOOLBAR(toolbar),
					toolbardef[i].label,
					toolbardef[i].tooltip,
					"Private",
					gtkpix,
					toolbardef[i].callback,
					toolbardef[i].data);
			gtk_object_set_data(GTK_OBJECT(tb_item),
					NORM_KEY, gtkpix);
			gtk_object_set_data(GTK_OBJECT(tb_item),
					GREY_KEY, gtkpix_grey);

			*toolbardef[i].store_to = tb_item;
		}
	}
}

static void exit_tryhelp(gchar *prgname)
{
	gint i;
	
	for(i=0; help[i]; i++) {
		fprintf(stderr, "%s\n", help[i]);
	}
	
	exit(1);
}

static void about_window()
{
	gchar buf[128];
	
	sprintf(buf, "%s\n\n"
		     "http://icarus.autostock.co.kr\n"
		     "Koo Kyoseon: icarus@autostock.co.kr", PACKAGE_VERSION);
	dialog_window(buf, NULL);
}
