/*
 connect.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"

gint connection_timetag;
time_t connected_at, server_time_diff;

static GList *connlist;
static gint init_state;
static gint selected;

void callback_connectiontime(CALLBACK_DATA *data)
{
    init_state = 1;

    if (data->status == 0)
    {
        /* Old server, didn't understand us.. */
        connected_at = (time_t) 0;
        callback_err = 1;
        return;
    }
    connected_at = (time_t) data->u.digit;
    callback_err = 0;
}

static void callback_connectionlist(CALLBACK_DATA *data)
{
    if (data->status == 0)
    {
        /* Server is really messed up if we ever get here :) */
        callback_err = 1;
        return;
    }

    callback_err = 0;
    if (data->u.list.type == LIST_END)
    {
        /* List finished */
        init_state = 2;
        return;
    }

    if (data->u.list.type == LIST_ITEM)
    {
	if ((autodial_isp != NULL && g_strcasecmp(data->u.list.data, autodial_isp) == 0) ||
	    (selected == -1 && g_strcasecmp(data->u.list.data, defaultisp) == 0))
	{
            /* this is the autodial / last dialed isp, set it as default */
	    selected = g_list_length(connlist);
	}
	connlist = g_list_append(connlist, g_strdup(data->u.list.data));
    }
}

static GtkWidget *add_new_connection(gchar *name, gchar *info, gchar *addrs, gchar *users)
{
    GtkWidget *li;
    GString *str;

    str = g_string_new(name);
    if (info != NULL) g_string_sprintfa(str, " (%s)", info);

    li = gtk_list_item_new_with_label(str->str);
    gtk_widget_show(li);

    g_string_free(str, TRUE);

    gtk_object_set_data(GTK_OBJECT(li), "name", name);
    if (info != NULL) gtk_object_set_data(GTK_OBJECT(li), "info", info);
    if (addrs != NULL) gtk_object_set_data(GTK_OBJECT(li), "addrs", addrs);
    if (users != NULL) gtk_object_set_data(GTK_OBJECT(li), "users", users);

    return li;
}

static void callback_connectioninfo(CALLBACK_DATA *data)
{
    static gchar *name, *info, *addrs, *users;
    gchar *str;

    if (data->status == 0)
    {
        /* Old server, didn't understand us.. */
        callback_err = 1;
        return;
    }

    callback_err = 0;
    switch (data->u.list.type)
    {
        case LIST_START:
            name = g_strdup(connlist->data);
            info = addrs = users = NULL;
            break;

        case LIST_END:
            g_free(connlist->data);
            connlist->data = add_new_connection(name, info, addrs, users);

            if (connlist->next != NULL)
                mserver_connectinfo(connlist->next->data, callback_connectioninfo);
            if (connlist->next == NULL || callback_err)
                init_state = 4;
            else
                connlist = connlist->next;
            break;

        case LIST_ITEM:
            str = data->u.list.data;
            if (strncmp(str, "INFO: ", 6) == 0)
                info = g_strdup(str+6);
            else if (strncmp(str, "VALID ADDERSSES: ", 17) == 0)
                addrs = g_strdup(str+17);
            else if (strncmp(str, "VALID USERS: ", 13) == 0)
                users = g_strdup(str+13);
            break;
    }
}

static int timefunc_initialize(void)
{
    /* First wait for READY.. */
    if (!ready) return 1;

    switch (init_state)
    {
        case 0:
            mserver_connectiontime(callback_connectiontime);
            break;
	case 1:
	    selected = -1;
            mserver_list_connections(callback_connectionlist);
            break;
        case 2:
            connlist = g_list_first(connlist);
            if (connlist != NULL)
                mserver_connectinfo((gchar *) connlist->data, callback_connectioninfo);
            if (connlist == NULL || callback_err)
            {
                GList *tmp;

                for (tmp = g_list_first(connlist); tmp != NULL; tmp = tmp->next)
                {
                    GtkWidget *li;

                    li = add_new_connection(tmp->data, NULL, NULL, NULL);
                    g_free(tmp->data);
                    tmp->data = li;
                }
                init_state = 3;
            }
            break;
        case 3:
            mserver_status(callback_status);
            init_state = 4;
            break;
        case 4:
	    gtk_list_append_items(GTK_LIST(GTK_COMBO(combo)->list), g_list_first(connlist));
	    if (selected != -1)
		gtk_list_select_item(GTK_LIST(GTK_COMBO(combo)->list), selected);
            connection_timetag = gtk_timeout_add(1000, (GtkFunction) timefunc_running, NULL);
            return 0;
    }
    return 1;
}

void menu_connect(void)
{
    if (mserver_connected())
    {
        masqerror(_("You are already connected"));
        return;
    }
    if (*masqhost == '\0')
    {
        masqerror(_("No server address set - set it from preferences"));
        return;
    }

    if (mserver_connect(masqhost, masqport))
    {
        set_dial_sensitive(TRUE, FALSE);
        set_connection_sensitive(TRUE);
        init_state = 0; connlist = NULL;
        connection_timetag = gtk_timeout_add(10, (GtkFunction) timefunc_initialize, NULL);
        if (autosenduser) menu_changeuser();
    }
}
