/*
 gmasqdialer.c : GMasqDialer

    Copyright (C) 1998-1999 Timo Sirainen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gmasqdialer.h"
#include "tux-anim.xpm"

#ifdef HAVE_GNOME_PANEL
#include <applet-widget.h>
gboolean applet_running;
static gboolean panel_vertical;
static gboolean panel_tiny;
static gint panel_size;

#ifdef SIZE_TINY
/* New gnome panel can change it's size on the fly */
#  define GNOME_PANEL_NEW
#endif
#endif

gchar *autodial_isp;
gboolean callback_err;
GtkWidget *window;
GtkWidget *combo, *statusbar, *connlabel;

static GtkWidget *anim_da;
static GdkPixmap *anim_pixmap;
static GdkBitmap *anim_mask;
static gint anim_frame, anim_frames, anim_tag;

static GtkWidget *dialbutton, *hangbutton;

#ifdef HAVE_GNOME_PANEL
GtkWidget *appletlabel;

static GtkWidget *applet;
static gboolean mainwin_hidden;
#endif

GnomeUIInfo server_menu[] = {
#define SERVER_CONNECT_POS 0
    { GNOME_APP_UI_ITEM, N_("Connect"), NULL, menu_connect, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
#define SERVER_DISCONNECT_POS 1
    { GNOME_APP_UI_ITEM, N_("Disconnect"), NULL, menu_disconnect, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
#define SERVER_INFO_POS 2
    { GNOME_APP_UI_ITEM, N_("Information"), NULL, menu_serverinfo, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
#define SERVER_CHUSER_POS 3
    { GNOME_APP_UI_ITEM, N_("Change user"), NULL, menu_changeuser, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
    { GNOME_APP_UI_ITEM, N_("Preferences"), NULL, menu_setup, NULL, NULL,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 0, 0, NULL },
    { GNOME_APP_UI_ITEM, N_("Quit"), NULL, menu_quit, NULL, NULL,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'X', GDK_CONTROL_MASK, NULL },
    { GNOME_APP_UI_ENDOFINFO }
};

GnomeUIInfo connection_menu[] = {
#define CONNECTION_DIAL_POS 0
    { GNOME_APP_UI_ITEM, N_("Dial"), NULL, menu_dial, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
#define CONNECTION_HANGUP_POS 1
    { GNOME_APP_UI_ITEM, N_("Hang Up"), NULL, menu_hangup, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
#define CONNECTION_INFO_POS 2
    { GNOME_APP_UI_ITEM, N_("Information"), NULL, menu_conninfo, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, 0, 0, 0, NULL },
    { GNOME_APP_UI_ENDOFINFO }
};

GnomeUIInfo help_menu[] = {
    { GNOME_APP_UI_ITEM, N_("About..."), NULL, menu_about, NULL, NULL,
      GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0,
      NULL },
#ifdef HAVE_GNOME
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_HELP("gmasqdialer"),
#endif
    { GNOME_APP_UI_ENDOFINFO }
};

GnomeUIInfo main_menu[] = {
    { GNOME_APP_UI_SUBTREE, N_("Server"), NULL, server_menu, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
    { GNOME_APP_UI_SUBTREE, N_("Connection"), NULL, connection_menu, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
    { GNOME_APP_UI_SUBTREE, N_("Help"), NULL, help_menu, NULL, NULL,
      GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
    { GNOME_APP_UI_ENDOFINFO }
};

void masqerror(char *str)
{
    GtkWidget *dialog;
    GtkWidget *label;

#ifdef HAVE_GNOME
    dialog = gnome_dialog_new(_("Error"), GNOME_STOCK_BUTTON_CLOSE, NULL);
    gnome_dialog_button_connect_object(GNOME_DIALOG(dialog), 0,
                                       GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));
    label = gtk_label_new(str);
    gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dialog)->vbox), label, TRUE, TRUE, 0);
#else
    GtkWidget *vbox;
    GtkWidget *button;

    dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_container_border_width(GTK_CONTAINER(dialog), 5);
    gtk_signal_connect(GTK_OBJECT(dialog), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(dialog), vbox);

    button = gtk_button_new_with_label("Close");
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(dialog));

    gtk_box_pack_end(GTK_BOX(vbox), button, FALSE, FALSE, 10);
    label = gtk_label_new(str);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
#endif

    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
    gtk_widget_show_all(dialog);
}

#ifdef HAVE_GNOME_PANEL
static void applet_connected(void)
{
    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                          "hangup",
                                          GNOME_STOCK_MENU_PREF,
                                          _("Hang Up"),
                                          (AppletCallbackFunc) menu_hangup,
                                          NULL);
    if (mainwin_hidden)
	applet_hidemain();
    else
	applet_showmain();
}

static void applet_disconnected(void)
{
    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                          "dial",
                                          GNOME_STOCK_MENU_PREF,
                                          _("Dial"),
                                          (AppletCallbackFunc) menu_dial,
                                          NULL);
    if (mainwin_hidden)
	applet_hidemain();
    else
	applet_showmain();
}
#endif

void set_dial_sensitive(int dial, int hangup)
{
    gtk_widget_set_sensitive(connection_menu[CONNECTION_DIAL_POS].widget, dial);
    gtk_widget_set_sensitive(connection_menu[CONNECTION_HANGUP_POS].widget, hangup);
    gtk_widget_set_sensitive(dialbutton, dial);
    gtk_widget_set_sensitive(hangbutton, hangup);
#ifdef HAVE_GNOME_PANEL
    if (applet_running)
    {
	applet_widget_unregister_callback(APPLET_WIDGET(applet), "dial");
	applet_widget_unregister_callback(APPLET_WIDGET(applet), "hangup");
	if (hangup)
	    applet_connected();
	else if (dial)
	    applet_disconnected();
    }
#endif
}

void set_connection_sensitive(gint connected)
{
    gtk_widget_set_sensitive(server_menu[SERVER_CONNECT_POS].widget, !connected);
    gtk_widget_set_sensitive(server_menu[SERVER_DISCONNECT_POS].widget, connected);
    gtk_widget_set_sensitive(server_menu[SERVER_INFO_POS].widget, connected);
    gtk_widget_set_sensitive(server_menu[SERVER_CHUSER_POS].widget, connected);
    gtk_widget_set_sensitive(connection_menu[CONNECTION_INFO_POS].widget, connected);
}

gint timefunc_running(void)
{
    static gint n = 0;
    static gint netload = 1;

    if (++n == 3)
    {
        /* check if connection is still on */
        n = 0;
        if (!ready) return 1;
        mserver_status(callback_status);
    }

    if (connected_at > 0)
    {
        /* update connect time */
        time_t conntime;
        GString *str;

	conntime = time(NULL)-connected_at+server_time_diff;
        str = g_string_new(NULL);
        g_string_sprintf(str, "%02ld:%02ld:%02ld", conntime / 3600, (conntime / 60) % 60, conntime % 60);
#ifdef HAVE_GNOME_PANEL
        if (appletlabel != NULL) gtk_label_set(GTK_LABEL(appletlabel), str->str);
#endif
        g_string_prepend(str, _("Connected "));
        gtk_label_set(GTK_LABEL(connlabel), str->str);
        g_string_free(str, TRUE);

        if (ready && netload)
        {
            mserver_netload(callback_netload);
            if (callback_err)
            {
                /* Too old server for this.. */
                netload = 0;
            }
        }
    }
    else if (maxcps != -1)
    {
	/* connected, get connection time.. */
        mserver_connectiontime(callback_connectiontime);
    }

    return 1;
}

void menu_quit(void)
{
    if (!mserver_connected())
        gtk_main_quit();
    else
    {
        quit_after_disconnect = TRUE;
        menu_disconnect();
    }
}

void menu_about(void)
{
    GtkWidget *about;

#ifdef HAVE_GNOME
    const gchar *authors[] = { "Timo Sirainen <cras@irccrew.org>", NULL };

    about = gnome_about_new(PACKAGE, VERSION,
                            /* copyright notice */
                            "(C) 1998-1999 Timo Sirainen",
                            authors,
                            /* comments */
                            "Gnomified masqdialer",
                            NULL);
#else
    GtkWidget *vbox, *label, *button;

    about = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_container_border_width(GTK_CONTAINER(about), 5);
    gtk_signal_connect(GTK_OBJECT(about), "delete_event",
                       GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(about), vbox);

    button = gtk_button_new_with_label(_("Close"));
    gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                              GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(about));

    gtk_box_pack_end(GTK_BOX(vbox), button, FALSE, FALSE, 10);
    label = gtk_label_new(PACKAGE" "VERSION" for GTK+\n\n(C) 1998-1999 Timo Sirainen");
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
#endif
    gtk_widget_show_all(about);
}

#ifdef HAVE_GNOME_PANEL
static void panel_redraw(GtkWidget *applet)
{
    GtkWidget *table, *frame;

    /* destroy old netload pixmaps */
    frame = gtk_object_get_data(GTK_OBJECT(applet), "outputframe");
    if (frame != NULL)
    {
	netload_pixmap_destroy(&paneloutput);
	gtk_widget_destroy(frame);
    }
    frame = gtk_object_get_data(GTK_OBJECT(applet), "inputframe");
    if (frame != NULL)
    {
	netload_pixmap_destroy(&panelinput);
	gtk_widget_destroy(frame);
    }

    table = gtk_object_get_data(GTK_OBJECT(applet), "table");
    if (panel_show_output)
    {
        frame = gtk_frame_new(NULL);
	gtk_object_set_data(GTK_OBJECT(applet), "outputframe", frame);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
        if (panel_size >= 48)
            gtk_table_attach_defaults(GTK_TABLE(table), frame, 1, 2, 1, 2);
        else
	{
	    if (panel_vertical)
		gtk_table_attach_defaults(GTK_TABLE(table), frame, 0, 1, 3, 4);
	    else
		gtk_table_attach_defaults(GTK_TABLE(table), frame, 3, 4, 0, 1);
	}

	if (panel_size == 24)
	    netload_pixmap_new(frame, &paneloutput, 18, 18);
	else if (panel_size == 48)
	    netload_pixmap_new(frame, &paneloutput, 19, 19);
	else if (panel_size == 64)
	    netload_pixmap_new(frame, &paneloutput, 27, 40);
	else
	    netload_pixmap_new(frame, &paneloutput, 35, 55);
	gtk_widget_show_all(frame);
    }

    if (panel_show_input)
    {
        frame = gtk_frame_new(NULL);
	gtk_object_set_data(GTK_OBJECT(applet), "inputframe", frame);
        gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
        if (panel_size >= 48)
            gtk_table_attach_defaults(GTK_TABLE(table), frame, 0, 1, 1, 2);
	else
	{
	    if (panel_vertical)
		gtk_table_attach_defaults(GTK_TABLE(table), frame, 0, 1, 2, 3);
	    else
		gtk_table_attach_defaults(GTK_TABLE(table), frame, 2, 3, 0, 1);
	}

	if (panel_size == 24)
	    netload_pixmap_new(frame, &panelinput, 18, 18);
	else if (panel_size == 48)
	    netload_pixmap_new(frame, &panelinput, 19, 19);
	else if (panel_size == 64)
	    netload_pixmap_new(frame, &panelinput, 27, 40);
	else
	    netload_pixmap_new(frame, &panelinput, 35, 55);
	gtk_widget_show_all(frame);
    }
}

static void applet_change_orient(GtkWidget *applet, PanelOrientType orient)
{
    panel_vertical = orient == ORIENT_LEFT || orient == ORIENT_RIGHT;
    if (panel_size <= 48)
	panel_size = panel_tiny && !panel_vertical ? 24 : 48;

    panel_redraw(applet);
}

#ifdef GNOME_PANEL_NEW
static void applet_change_size(GtkWidget *applet, PanelSizeType size)
{
    panel_tiny = FALSE;
    switch (size)
    {
        case SIZE_TINY:
	    panel_size = panel_vertical ? 48 : 24;
	    panel_tiny = TRUE;
            break;
        case SIZE_STANDARD:
            panel_size = 48;
            break;
        case SIZE_LARGE:
            panel_size = 64;
            break;
        case SIZE_HUGE:
            panel_size = 80;
            break;
    }

    panel_redraw(applet);
}
#endif

void applet_showmain(void)
{
    gtk_widget_show(window);
    mainwin_hidden = FALSE;

    applet_widget_unregister_callback(APPLET_WIDGET(applet), "hidewindow");
    applet_widget_unregister_callback(APPLET_WIDGET(applet), "showwindow");
    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                          "hidewindow",
                                          GNOME_STOCK_MENU_CLOSE,
                                          _("Hide main window"),
                                          (AppletCallbackFunc) applet_hidemain,
                                          NULL);
}

static void applet_togglemain( GtkWidget *widget, GdkEventButton *ev, gpointer data )
{
    if( ev == NULL )
	return;

    if( ev->button != 1 || ev->type != GDK_2BUTTON_PRESS )
	return;

    if (mainwin_hidden == FALSE)
        applet_hidemain();
    else
        applet_showmain();
}

gint applet_hidemain(void)
{
    gtk_widget_hide(window);
    mainwin_hidden = TRUE;

    applet_widget_unregister_callback(APPLET_WIDGET(applet), "hidewindow");
    applet_widget_unregister_callback(APPLET_WIDGET(applet), "showwindow");
    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                          "showwindow",
                                          GNOME_STOCK_MENU_NEW,
                                          _("Show main window"),
                                          (AppletCallbackFunc) applet_showmain,
                                          NULL);
    return TRUE;
}

static gint applet_save_session(void)
{
    return FALSE;
}

void create_applet(void)
{
    GtkWidget *frame, *table;

    applet = applet_widget_new(PACKAGE);
    if (applet == NULL)
        g_error("Can't create applet, try --no-applet option.\n");

    gtk_widget_set_events( applet, gtk_widget_get_events( applet ) |
	               GDK_BUTTON_PRESS_MASK | GDK_EXPOSURE_MASK );
    gtk_signal_connect(GTK_OBJECT(applet), "destroy",
                       (GtkSignalFunc) menu_quit, NULL);
    gtk_signal_connect(GTK_OBJECT(applet), "button_press_event",
                       (GtkSignalFunc) applet_togglemain, NULL);


    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    applet_widget_add(APPLET_WIDGET (applet), frame);

    table = gtk_table_new(2, 2, FALSE);
    gtk_object_set_data(GTK_OBJECT(applet), "table", table);
    gtk_container_add(GTK_CONTAINER(frame), table);

    if (!panel_show_label)
        appletlabel = NULL;
    else
    {
        appletlabel = gtk_label_new(_("No conn."));
        gtk_table_attach_defaults(GTK_TABLE(table), appletlabel, 0, 2, 0, 1);
    }
    gtk_widget_show_all(applet);

    gtk_signal_connect(GTK_OBJECT(applet), "save_session",
                       GTK_SIGNAL_FUNC(applet_save_session), NULL);
    gtk_signal_connect(GTK_OBJECT(applet), "change_orient",
                       GTK_SIGNAL_FUNC(applet_change_orient), NULL);
#ifdef GNOME_PANEL_NEW
    gtk_signal_connect(GTK_OBJECT(applet), "change_size",
		       GTK_SIGNAL_FUNC(applet_change_size), NULL);
#endif

    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                          "about",
                                          GNOME_STOCK_MENU_ABOUT,
                                          _("About"),
                                          (AppletCallbackFunc) menu_about,
                                          NULL);

    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
                                          "preferences",
                                          GNOME_STOCK_MENU_PREF,
                                          _("Preferences"),
                                          (AppletCallbackFunc) menu_setup,
					  NULL);
}
#endif

static void animation_load(void)
{
    gint width;

    gtk_widget_realize(anim_da);
    anim_pixmap = gdk_pixmap_create_from_xpm_d(anim_da->window, &anim_mask, NULL, tux_anim_xpm);
    width = 720;

    anim_frames = width / 48;
    anim_frame = 0;
}

static gint animation_next_frame(GtkWidget *da)
{
    if (++anim_frame == anim_frames)
	anim_frame = 0;

    gtk_widget_draw(da, NULL);
    return 1;
}

static gint animation_icon_expose(GtkWidget *da)
{
    gdk_draw_pixmap(da->window, da->style->black_gc,
		    anim_pixmap, anim_frame * 48,
		    0, 0, 0, 48, 48);
    return TRUE;
}

void animation_start(void)
{
    gtk_widget_show(anim_da);
    anim_tag = gtk_timeout_add(100, (GtkFunction) animation_next_frame, anim_da);

    gtk_label_set(GTK_LABEL(connlabel), _("Dialing.."));
}

void animation_stop(void)
{
    if (anim_tag != -1)
    {
	gtk_widget_hide(anim_da);
	gtk_timeout_remove(anim_tag);

	gtk_label_set(GTK_LABEL(connlabel), _("Not connected"));
	anim_tag = -1;
    }
}

int main (int argc, char *argv[])
{
#ifdef HAVE_GNOME
    struct poptOption options[] = {
        POPT_AUTOHELP
#ifdef HAVE_GNOME_PANEL
	{ "no-applet", '\0', POPT_ARG_NONE, NULL, 0, NULL, N_("Don't run as applet") },
#endif
	{ "dial", 'd', POPT_ARG_STRING, &autodial_isp, 0, N_("Automatically dial to ISP"), N_("ISP") },
        { NULL, '\0', 0, NULL }
    };
#endif
    GtkWidget *table, *mainvbox, *vbox, *hbox;
    GtkWidget *frame, *label, *popup;
#ifdef HAVE_GNOME_PANEL
    gint num;
#endif

#ifdef ENABLE_NLS
    /* initialize the i18n stuff */
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);
#endif
    autodial_isp = NULL;

#ifdef HAVE_GNOME_PANEL
    applet_running = TRUE;
    for (num = 1; num < argc; num++)
        if (strcmp(argv[num], "--no-applet") == 0)
        {
            applet_running = FALSE;
            break;
        }

    if (applet_running)
        applet_widget_init(PACKAGE, VERSION, argc, argv, options, 0, NULL);
    else
        gnome_init_with_popt_table(PACKAGE, VERSION, argc, argv, options, 0, NULL);
#elif defined (HAVE_GNOME)
    gnome_init_with_popt_table(PACKAGE, VERSION, argc, argv, options, 0, NULL);
#else
    gtk_init(&argc, &argv);
#endif

    setup_init();
    protocol_init();
    netload_init();

    window = gnome_app_new(PACKAGE, PACKAGE);

#ifdef HAVE_GNOME_PANEL
    if (applet_running)
    {
        create_applet();
        gtk_signal_connect_object(GTK_OBJECT (window), "delete_event",
                                  GTK_SIGNAL_FUNC(applet_hidemain), GTK_OBJECT(window));
    }
    else
#endif
        gtk_signal_connect_object(GTK_OBJECT (window), "delete_event",
                                  GTK_SIGNAL_FUNC(menu_quit), GTK_OBJECT(window));

    /* menubar / popup menu */
    if (show_menubar)
	gnome_app_create_menus_with_data (GNOME_APP(window), main_menu, window);
    else
    {
	popup = gnome_popup_menu_new(main_menu);
	gnome_popup_menu_attach(popup, window, window);
    }
    gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);

    mainvbox = gtk_vbox_new(FALSE, 0);
    gnome_app_set_contents(GNOME_APP(window), mainvbox);

    table = gtk_table_new(4, 5, FALSE);
    gtk_container_border_width(GTK_CONTAINER(table), 5);
    gtk_box_pack_start(GTK_BOX(mainvbox), table, TRUE, TRUE, 0);

    /* status bar */
    statusbar = gtk_statusbar_new();
    gtk_statusbar_push(GTK_STATUSBAR(statusbar), 1, "");
    gtk_box_pack_start(GTK_BOX(mainvbox), statusbar, FALSE, FALSE, 0);

    /* connect box */
    combo = gtk_combo_new();
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo)->entry), FALSE);
    gtk_table_attach_defaults(GTK_TABLE(table), combo, 0, 1, 0, 1);

    /* connected label */
    connlabel = gtk_label_new(_("Not connected"));
    gtk_table_attach_defaults(GTK_TABLE(table), connlabel, 0, 1, 1, 2);

    /* sent/received labels */
    vbox = gtk_vbox_new(FALSE, 0);
    gtk_table_attach_defaults(GTK_TABLE(table), vbox, 0, 2, 2, 5);

    output.label = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(vbox), output.label, FALSE, FALSE, 0);

    input.label = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(vbox), input.label, FALSE, FALSE, 0);

    /* Connect-animation */
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);

    anim_tag = -1;
    anim_da = gtk_drawing_area_new();
    gtk_drawing_area_size(GTK_DRAWING_AREA(anim_da), 48, 48);
    gtk_signal_connect(GTK_OBJECT(anim_da), "expose_event",
		       GTK_SIGNAL_FUNC(animation_icon_expose), NULL);
    gtk_box_pack_start(GTK_BOX(hbox), anim_da, TRUE, FALSE, 0);
    animation_load();

    /* dial / hangup buttons */
    vbox = gtk_vbox_new(FALSE, 10);
    gtk_container_border_width(GTK_CONTAINER(vbox), 8);
    gtk_table_attach(GTK_TABLE(table), vbox, 1, 2, 0, 2, 0, GTK_FILL | GTK_EXPAND, 0, 0);

    dialbutton = gtk_button_new_with_label(_("Dial"));
    gtk_signal_connect (GTK_OBJECT (dialbutton), "clicked",
                        GTK_SIGNAL_FUNC(menu_dial), window);
    gtk_box_pack_start(GTK_BOX(vbox), dialbutton, TRUE, TRUE, 0);
    hangbutton = gtk_button_new_with_label(_("Hang up"));
    gtk_signal_connect (GTK_OBJECT (hangbutton), "clicked",
                        GTK_SIGNAL_FUNC(menu_hangup), window);
    gtk_box_pack_start(GTK_BOX(vbox), hangbutton, TRUE, TRUE, 0);

    /* finally net load meters */
    vbox = gtk_vbox_new(FALSE, 0);
    gtk_table_attach_defaults(GTK_TABLE(table), vbox, 2, 3, 0, 4);

    label = gtk_label_new(_("output"));
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

    netload_pixmap_new(frame, &output, NETLOAD_WIDTH, NETLOAD_HEIGHT);

    label = gtk_label_new(_("input"));
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
    gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);

    netload_pixmap_new(frame, &input, NETLOAD_WIDTH, NETLOAD_HEIGHT);

    set_dial_sensitive(FALSE, FALSE);
    set_connection_sensitive(FALSE);
    if (autoconnect || autodial_isp != NULL) menu_connect();
    if (autodial_isp != NULL) menu_dial();
    gtk_widget_show_all(mainvbox);

#ifdef HAVE_GNOME_PANEL
    if (!applet_running)
	gtk_widget_show(window);
    else
    {
	if (show_mainwin_at_start)
	    applet_showmain();
        else
            applet_hidemain();
    }
#else
    gtk_widget_show(window);
#endif
    gtk_widget_hide(input.label);
    gtk_widget_hide(output.label);
    gtk_widget_hide(anim_da);

#ifdef HAVE_GNOME_PANEL
    if (applet_running)
        applet_widget_gtk_main();
    else
#endif
        gtk_main ();

    return 0;
}
