#ifndef __GMASQDIALER_H
#define __GMASQDIALER_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <unistd.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_GNOME
#include <gnome.h>
#ifdef HAVE_GNOME_PANEL
extern gboolean applet_running;
extern GtkWidget *appletlabel;
#endif
#else
#include "gnome-stuff.h"
#endif

enum
{
    LIST_START,
    LIST_ITEM,
    LIST_END,
};

typedef struct
{
    gchar *connection;
    gint bps;
}
CALLBACK_CONNECTION_DATA;

typedef struct
{
    gint type;
    gchar *data;
}
CALLBACK_LIST_DATA;

typedef struct
{
    gint status;

    union
    {
        CALLBACK_CONNECTION_DATA connection;
        CALLBACK_LIST_DATA list;
        gchar *text;
        glong digit;
    } u;
}
CALLBACK_DATA;

typedef void (*CALLBACK_FUNC)(CALLBACK_DATA *data);

extern gboolean callback_err;
extern GtkWidget *combo, *statusbar, *connlabel;
extern gchar *autodial_isp;

#ifdef HAVE_GNOME_PANEL
gint applet_hidemain(void);
void applet_showmain(void);
#endif

void animation_start(void);
void animation_stop(void);

void masqerror(gchar *str);
void set_dial_sensitive(gint dial, gint hangup);
void set_connection_sensitive(gint connected);
void status_connection_lost(void);

int timefunc_running(void);

void menu_connect(void);
void menu_disconnect(void);
void menu_serverinfo(void);
void menu_changeuser(void);
void menu_setup(void);
void menu_quit(void);
void menu_dial(void);
void menu_conninfo(void);
void menu_hangup(void);
void menu_about(void);

#include "network.h"
#include "protocol.h"
#include "setup.h"
#include "connect.h"
#include "disconnect.h"
#include "netload.h"
#include "changeuser.h"
#include "status.h"

#endif
