/* Gnomba
 * Copyright (C) 1999 Gnomba Team
 *
 * browser.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option) 
 * any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "config.h"
#include <gnome.h>

#include "browser.h"
#include "net.h"
#include "error.h"
#include "smbwrap.h"
#include <errno.h>
#include <sys/stat.h>

#include "images/workgroup.xpm"
#include "images/machine.xpm"
#include "images/network.xpm"
#include "images/share.xpm"
#include "images/printer.xpm"

/* strucutre passed around when using pop-up password screens */
typedef struct _PWInfo {

  machineNode *info;
  GtkWidget *username;
  GtkWidget *passwd;
  GtkWidget *mount;

} PWInfo;

void doShareScan(machineNode * info);



void closePrompt(GtkWidget * widget, gpointer * gp)
{
  gtk_widget_destroy(GTK_WIDGET(gp));
}


gint findcompare(gconstpointer a, gconstpointer b)
{

  machineNode *mn;
  gchar *lbl;
  gint found;

  if ((a == NULL) || (b == NULL))
    return -1;
  mn = (machineNode *) a;
  lbl = (gchar *) b;

  if (mn->workgroupName != NULL) {
    found = strcmp(mn->workgroupName, lbl);
    if (found == 0)
      return found;
  }
  if (mn->machineName != NULL) {
    found = strcmp(mn->machineName, lbl);
    if (found == 0)
      return found;
  }
  if (mn->shareName != NULL) {
    found = strcmp(mn->shareName, lbl);
    if (found == 0)
      return found;
  }
  return (-1);

}



void find_cb(GtkWidget * widget, gpointer data)
{

  GtkCTreeNode *tmpn;

  /*need to prompt for string */
  tmpn = gtk_ctree_find_by_row_data_custom(GTK_CTREE(workgrouplist), NULL, gtk_entry_get_text(GTK_ENTRY(data)), findcompare);

  didFind = TRUE;
  gtk_ctree_select(GTK_CTREE(workgrouplist), tmpn);

}



void doFind()
{


  GtkWidget *windowPrompt;
  GtkWidget *label;
  GtkWidget *txtFind;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *buttonOK;
  GtkWidget *buttonCancel;

  windowPrompt = gnome_app_new("Find Dialog", _("Find Dialog"));
  gtk_window_set_modal(GTK_WINDOW(windowPrompt), TRUE);
  gtk_window_set_position(GTK_WINDOW(windowPrompt), GTK_WIN_POS_MOUSE);

  vbox = gtk_vbox_new(FALSE, 0);
  gnome_app_set_contents(GNOME_APP(windowPrompt), vbox);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  label = gtk_label_new(_("Find:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, GNOME_PAD_SMALL);

  txtFind = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), txtFind, FALSE, FALSE, GNOME_PAD_SMALL);
  gtk_widget_show(hbox);
  gtk_widget_show(label);
  gtk_widget_show(txtFind);


  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  buttonOK = gtk_button_new_with_label(_("Ok"));

  gtk_box_pack_start(GTK_BOX(hbox), buttonOK, TRUE, TRUE, GNOME_PAD_SMALL);

  gtk_signal_connect(GTK_OBJECT(buttonOK), "clicked",
		     GTK_SIGNAL_FUNC(find_cb), txtFind);
  gtk_signal_connect(GTK_OBJECT(buttonOK), "clicked",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);

  buttonCancel = gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(hbox), buttonCancel, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_signal_connect(GTK_OBJECT(buttonCancel), "clicked",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);


  gtk_widget_show(hbox);
  gtk_widget_show(buttonOK);
  gtk_widget_show(buttonCancel);

  gtk_widget_show(vbox);
  gtk_widget_show(windowPrompt);

  gtk_widget_grab_default(buttonOK);
  gtk_widget_grab_focus(txtFind);

}

void updatePW(GtkWidget * w, gpointer * data)
{

  machineNode *tmp;
  PWInfo *pwi;

  pwi = (PWInfo *) data;

  tmp = pwi->info;

  if (tmp->username != NULL) {
    g_free(tmp->username);
    tmp->username = NULL;
  }
  tmp->username = (gchar *)
    g_malloc(sizeof(gchar) * (strlen(gtk_entry_get_text(GTK_ENTRY(pwi->username))) + 1));
  strcpy(tmp->username, gtk_entry_get_text(GTK_ENTRY(pwi->username)));

  if (tmp->passwd != NULL) {
    g_free(tmp->passwd);
    tmp->passwd = NULL;
  }
  tmp->passwd =
    g_malloc(sizeof(gchar) * (strlen(gtk_entry_get_text(GTK_ENTRY(pwi->passwd))) + 1));
  strcpy(tmp->passwd, gtk_entry_get_text(GTK_ENTRY(pwi->passwd)));

  /*we should free this, right? */
  g_free(pwi);

  doShareScan(tmp);

}


void passwordPrompt(machineNode * tmp)
{

  GtkWidget *windowPrompt;
  GtkWidget *label;
  GtkWidget *txtUsername;
  GtkWidget *txtPasswd;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *buttonOK;
  GtkWidget *buttonCancel;
  PWInfo *pwi;

  /*create window which prompts for username and password */
  /*ok button will call updatePW */

  /* gnome_app_new(appname,title) only title nedds translation */

  windowPrompt = gnome_app_new("Authenticate", _("Authenticate"));
  gtk_window_set_modal(GTK_WINDOW(windowPrompt), TRUE);
  gtk_window_set_position(GTK_WINDOW(windowPrompt), GTK_WIN_POS_MOUSE);

  vbox = gtk_vbox_new(FALSE, 0);
  gnome_app_set_contents(GNOME_APP(windowPrompt), vbox);

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  label = gtk_label_new(_("Username:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, GNOME_PAD_SMALL);

  txtUsername = gtk_entry_new();
  if (tmp->username != NULL)
    gtk_entry_set_text(GTK_ENTRY(txtUsername), tmp->username);
  gtk_box_pack_start(GTK_BOX(hbox), txtUsername, FALSE, FALSE, GNOME_PAD_SMALL);
  gtk_widget_show(hbox);
  gtk_widget_show(label);
  gtk_widget_show(txtUsername);


  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  label = gtk_label_new(_("Password:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, GNOME_PAD_SMALL);

  txtPasswd = gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(txtPasswd), FALSE);
  gtk_box_pack_start(GTK_BOX(hbox), txtPasswd, FALSE, FALSE, GNOME_PAD_SMALL);
  gtk_widget_show(hbox);
  gtk_widget_show(label);
  gtk_widget_show(txtPasswd);


  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  buttonOK = gtk_button_new_with_label(_("Ok"));

  gtk_box_pack_start(GTK_BOX(hbox), buttonOK, TRUE, TRUE, GNOME_PAD_SMALL);
  pwi = g_malloc(sizeof(PWInfo));
  pwi->username = txtUsername;
  pwi->passwd = txtPasswd;
  pwi->info = tmp;

  gtk_signal_connect(GTK_OBJECT(buttonOK), "clicked",
		     GTK_SIGNAL_FUNC(updatePW), pwi);
  gtk_signal_connect(GTK_OBJECT(buttonOK), "clicked",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);

  buttonCancel = gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(hbox), buttonCancel, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_signal_connect(GTK_OBJECT(buttonCancel), "clicked",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);


  gtk_widget_show(hbox);
  gtk_widget_show(buttonOK);
  gtk_widget_show(buttonCancel);

  gtk_widget_show(vbox);
  gtk_widget_show(windowPrompt);

  gtk_widget_grab_default(buttonOK);


  if (DefaultUser && *DefaultUser) {
    gtk_widget_grab_focus(txtPasswd);
    gtk_signal_connect_object(GTK_OBJECT(txtPasswd), "activate",
			      GTK_SIGNAL_FUNC(gtk_window_activate_default),
			      GTK_OBJECT(windowPrompt));
  } else {
    gtk_widget_grab_focus(txtUsername);
    gtk_signal_connect_object(GTK_OBJECT(txtUsername), "activate",
			      GTK_SIGNAL_FUNC(gtk_window_activate_default),
			      GTK_OBJECT(windowPrompt));
  }



}

void doShareScan(machineNode * info)
{

  GdkCursor *cursor;
  gint res;

  g_return_if_fail(info);

  cursor = gdk_cursor_new(GDK_WATCH);
  gdk_window_set_cursor(window->window, cursor);
  gdk_cursor_destroy(cursor);
  while (gtk_events_pending())
    gtk_main_iteration();


  res = getShareList(info);
  cursor = gdk_cursor_new(GDK_TOP_LEFT_ARROW);
  gdk_window_set_cursor(window->window, cursor);
  gdk_cursor_destroy(cursor);

  if (res == 0)			/* we succeeded */
    info->scanned = TRUE;

  if ((res == -5) && (!NoAuthentication))	/*if the user doesn't want to see a password prompt, just give up */
    passwordPrompt(info);
}


/******************MOUNTING CODE*********************	*/

/*used to get and place text when using the "browse" button */
typedef struct _browseinfo {
  GtkWidget *text;
  GtkWidget *window;
} browseinfo;


void browse_select(GtkWidget * w, browseinfo * data)
{

  gtk_entry_set_text(GTK_ENTRY(data->text),
	 gtk_file_selection_get_filename(GTK_FILE_SELECTION(data->window)));
  gtk_object_destroy(GTK_OBJECT(data->window));
  g_free(data);
}

void browse_cb(GtkWidget * w, gpointer data)
{
  GtkWidget *window;
  browseinfo *bi;

  g_return_if_fail(data);
  window = gtk_file_selection_new(_("Select Mount Point"));
  gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(window));
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(window), "destroy",
		     GTK_SIGNAL_FUNC(gtk_widget_destroyed),
		     &window);

  bi = g_malloc(sizeof(browseinfo));
  bi->text = (GtkWidget *) data;
  bi->window = window;

  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window)->ok_button),
		  "clicked", GTK_SIGNAL_FUNC(browse_select), (gpointer) bi);
  gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(window)->cancel_button),
	"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));

  if (gtk_entry_get_text(GTK_ENTRY(data)) != NULL)
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(window),
				    gtk_entry_get_text(GTK_ENTRY(data)));

  gtk_widget_show(window);
  gtk_grab_add(window);


}

static void guesttoggle_cb(GtkWidget * widget, gpointer data)
{

  PWInfo *pwi;

  g_return_if_fail(data);

  if (laststate == TRUE)
    laststate = FALSE;
  else
    laststate = TRUE;

  pwi = (PWInfo *) data;

  gtk_widget_set_sensitive(pwi->username, laststate);
  gtk_widget_set_sensitive(pwi->passwd, laststate);

}

void tryMount();


void createDir(gchar * dir)
{

  gchar *cmd = (gchar *) NULL;
  g_return_if_fail(dir);

  if (debug)
    g_print("create dir for //%s/%s\n", currnode->machineName, currnode->shareName);

  cmd = g_malloc(sizeof(gchar) * (13 + strlen(dir)));
  sprintf(cmd, "mkdir -p \"%s\"", dir);

  if (debug)
    g_print("exec:%s\n", cmd);
  if (system(cmd))
    ShowError(_("Could not create mount point!"));
  else {
    if (debug)
      g_print("about to launch trymount\n");
    tryMount();
    currnode->mountCreated = 1;
  }
  g_free(cmd);
}

void createPromptReply_cb(gint reply, gpointer data)
{

  g_return_if_fail(data);
  if (!reply)
    createDir((gchar *) data);
}

void createPrompt(gchar * dir)
{

  g_return_if_fail(dir);

  if (SilentlyCreateMountPoint)
    createDir(dir);
  else {
    GtkWidget *dialog;
    gchar *question;

    question = g_malloc(strlen(_("Directory %s doesn't exist ! Create it ?")) + strlen(dir));
    sprintf(question, _("Directory %s doesn't exist ! Create it ?"), dir);
    dialog = gnome_question_dialog_modal(question, createPromptReply_cb, (gpointer) dir);
    gtk_window_set_position(&(GNOME_DIALOG(dialog)->window), GTK_WIN_POS_MOUSE);
    g_free((gpointer) question);
  }
}


void updateMount(GtkWidget * w, gpointer * data)
{
  machineNode *tmp;
  PWInfo *pwi;
  struct stat st_buf;
  int stat_err = 0;

  if (debug)
    printf("Entered into updateMount\n");

  pwi = (PWInfo *) data;
  g_return_if_fail(pwi);

  tmp = pwi->info;

  if (tmp->username != NULL) {
    g_free(tmp->username);
    tmp->username = NULL;
  }
  tmp->username =
    g_malloc(sizeof(gchar) * (strlen(gtk_entry_get_text(GTK_ENTRY(pwi->username))) + 1));
  strcpy(tmp->username, gtk_entry_get_text(GTK_ENTRY(pwi->username)));

  if (tmp->passwd != NULL) {
    g_free(tmp->passwd);
    tmp->passwd = NULL;
  }
  tmp->passwd =
    g_malloc(sizeof(gchar) * (strlen(gtk_entry_get_text(GTK_ENTRY(pwi->passwd))) + 1));
  strcpy(tmp->passwd, gtk_entry_get_text(GTK_ENTRY(pwi->passwd)));


  if (tmp->mountClean != NULL) {
    g_free(tmp->mountClean);
    tmp->mountClean = NULL;
  }
		
	if (tmp->mountName != NULL) {
		g_free(tmp->mountName);
		tmp->mountName = NULL;
	}
	
  tmp->mountName =
    g_malloc(sizeof(gchar) * (strlen(gtk_entry_get_text(GTK_ENTRY(pwi->mount))) + 1));
  strcpy(tmp->mountName, gtk_entry_get_text(GTK_ENTRY(pwi->mount)));
	
	tmp->mountClean = makeClean(tmp->mountName);
	if (debug) g_print("mountClean=>>%s<<\n",tmp->mountName);
	
/* Check if mount point exist */
  if ((stat_err = stat(tmp->mountName, &st_buf))) {

    if (debug)
      g_print("Dir stat: ret=%d  err=%d\n", stat_err, errno);

    if (errno == ENOENT) {
      createPrompt(tmp->mountName);
    } else
      switch (errno) {
      case ENOTDIR:
	ShowError(_("The mount point you specify is not a directory"));
	break;
      case ELOOP:
	ShowError(_("Too many symbolic links in the path"));
	break;
      case EACCES:
	ShowError(_("You don't have enough privileges to access this directory"));
	break;
      case ENAMETOOLONG:
	ShowError(_("The directory name is too long"));
	break;
      default:
	/* Do nothing wondering it will be ok */
	if (debug)
	  g_print("Unexpected error while Dir stat: ret=%d  err=%d\n", stat_err, errno);
      }
  } else {
    g_free(pwi);

    if (debug)
      printf("about to launch trymount\n");
    tryMount();
  }
}

void mountShareCmd()
{
  docmd = 1;
  mountShare(0);
}

void mountShare(int mode)
{				/* 0 = new, 1 = edit */

  GtkWidget *windowPrompt;
  GtkWidget *label;
  GtkWidget *txtUsername;
  GtkWidget *txtPasswd;
  GtkWidget *txtMount;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *buttonOK;
  GtkWidget *buttonCancel;
  GtkWidget *chkbox;
  PWInfo *pwi;
  machineNode *tmp;
  GtkWidget *cmdbrowse;

  if (currnode == NULL)
    return;
  if (currnode->shareName == NULL)
    return;
  if ((currnode->mountName != NULL) && (mode == 0)) {

    printf(_("mounted on:>%s<\n"), currnode->mountName);
    ShowError(_("Already Mounted"));
    return;
  }
  if ((currnode->typeName != NULL) && (!strcmp(currnode->typeName, "Printer"))) {
    ShowError("Can't mount a printer");
    return;
  }
  tmp = currnode;

  /*ok if we have autmount on, then we are going to try that first */
  if ((AutoMount) && (domnt)) {
    domnt = 0;
    tmp->mountName = (gchar *) g_malloc(sizeof(gchar) * strlen(DefaultMount) + strlen(tmp->shareName) + 3);
    sprintf(tmp->mountName, "%s/%s", DefaultMount, tmp->shareName);
    tmp->mountClean = makeClean(tmp->mountName);
		laststate = TRUE;		/*tell it to try user level auth if it can */
    tryMount();
    return;
  }
  /* create and launch window to prompt for mount point. */
  /* set to call updateMount on "OK"                            */

  /*create window which prompts for mount point username and password */
  /*ok button will call updatePW */

  /* gnome_app_new(appname,title) only title nedds translation */

  windowPrompt = gnome_app_new("MountPoint", _("Select Mount Point"));
  gtk_window_set_modal(GTK_WINDOW(windowPrompt), TRUE);

  vbox = gtk_vbox_new(FALSE, 0);
  gnome_app_set_contents(GNOME_APP(windowPrompt), vbox);

/** Mount point **/

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  label = gtk_label_new(_("Mount Point:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, GNOME_PAD_SMALL);

  txtMount = gtk_entry_new();
  if (tmp->mountName != NULL)
    gtk_entry_set_text(GTK_ENTRY(txtMount), tmp->mountName);
  gtk_box_pack_start(GTK_BOX(hbox), txtMount, FALSE, FALSE, GNOME_PAD_SMALL);

  cmdbrowse = gtk_button_new_with_label("...");
  gtk_signal_connect(GTK_OBJECT(cmdbrowse), "clicked",
		     (GtkSignalFunc) browse_cb, txtMount);
  gtk_box_pack_start(GTK_BOX(hbox), cmdbrowse, FALSE, FALSE, GNOME_PAD_SMALL);

  gtk_widget_show(hbox);
  gtk_widget_show(label);
  gtk_widget_show(txtMount);
  gtk_widget_show(cmdbrowse);

/** Password Toggle **/

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  chkbox = gtk_check_button_new_with_label(_("Provide share level authentication"));
  gtk_box_pack_start(GTK_BOX(hbox), chkbox, FALSE, FALSE, GNOME_PAD_SMALL);

  gtk_widget_show(hbox);
  gtk_widget_show(chkbox);

/** Username prompt **/

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  label = gtk_label_new(_("Username:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, GNOME_PAD_SMALL);

  txtUsername = gtk_entry_new();
  if (tmp->username != NULL)
    gtk_entry_set_text(GTK_ENTRY(txtUsername), tmp->username);
  gtk_box_pack_start(GTK_BOX(hbox), txtUsername, FALSE, FALSE, GNOME_PAD_SMALL);
  gtk_widget_show(hbox);
  gtk_widget_show(label);
  gtk_widget_show(txtUsername);

/** Password Prompt **/

  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  label = gtk_label_new(_("Password:"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, GNOME_PAD_SMALL);

  txtPasswd = gtk_entry_new();
  gtk_entry_set_visibility(GTK_ENTRY(txtPasswd), FALSE);
  if (tmp->passwd != NULL)
    gtk_entry_set_text(GTK_ENTRY(txtPasswd), tmp->passwd);
  gtk_box_pack_start(GTK_BOX(hbox), txtPasswd, FALSE, FALSE, GNOME_PAD_SMALL);
  gtk_widget_show(hbox);
  gtk_widget_show(label);
  gtk_widget_show(txtPasswd);


  pwi = g_malloc(sizeof(PWInfo));
  pwi->username = txtUsername;
  pwi->passwd = txtPasswd;
  pwi->info = tmp;
  pwi->mount = txtMount;

/*this has to wait till now cause we need the pwi */

  gtk_signal_connect(GTK_OBJECT(chkbox), "clicked",
		     (GtkSignalFunc) guesttoggle_cb, pwi);

  if (tmp->username == NULL)
    laststate = FALSE;
  else
    laststate = TRUE;
  GTK_TOGGLE_BUTTON(chkbox)->active = laststate;
  gtk_widget_set_sensitive(txtUsername, laststate);
  gtk_widget_set_sensitive(txtPasswd, laststate);


/** Buttons **/
  hbox = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, GNOME_PAD_SMALL);

  buttonOK = gtk_button_new_with_label(_("Ok"));

  gtk_box_pack_start(GTK_BOX(hbox), buttonOK, TRUE, TRUE, GNOME_PAD_SMALL);

  gtk_signal_connect(GTK_OBJECT(buttonOK), "clicked",
		     GTK_SIGNAL_FUNC(updateMount), pwi);
  gtk_signal_connect(GTK_OBJECT(buttonOK), "clicked",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);


  gtk_signal_connect(GTK_OBJECT(txtMount), "activate",
		     GTK_SIGNAL_FUNC(updateMount), pwi);
  gtk_signal_connect(GTK_OBJECT(txtMount), "activate",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);


  buttonCancel = gtk_button_new_with_label(_("Cancel"));
  gtk_box_pack_start(GTK_BOX(hbox), buttonCancel, TRUE, TRUE, GNOME_PAD_SMALL);
  gtk_signal_connect(GTK_OBJECT(buttonCancel), "clicked",
		     GTK_SIGNAL_FUNC(closePrompt), windowPrompt);


  gtk_widget_show(hbox);
  gtk_widget_show(buttonOK);
  gtk_widget_show(buttonCancel);

  gtk_widget_show(vbox);
  gtk_widget_show(windowPrompt);

  gtk_widget_grab_default(buttonOK);
  gtk_widget_grab_focus(txtMount);

}

void tryMount()
{

  GdkCursor *cursor;
  gint res;
  mountedSmbfs *curr = rootMounted;

  cursor = gdk_cursor_new(GDK_WATCH);
  gdk_window_set_cursor(window->window, cursor);
  gdk_cursor_destroy(cursor);
  while (gtk_events_pending())
    gtk_main_iteration();

  res = doMount();
  cursor = gdk_cursor_new(GDK_TOP_LEFT_ARROW);
  gdk_window_set_cursor(window->window, cursor);
  gdk_cursor_destroy(cursor);

  if (res == -3) {
    mountShare(1);
    return;
  }
  if (res == -5) {
    mountShare(1);
    return;
  }
  /*we succeded, but we want to suppress the popup */
  if (res != -7)
    ShowError("Mount Succedded!");

  gtk_ctree_node_set_text(GTK_CTREE(workgrouplist), gtk_ctree_find_by_row_data(GTK_CTREE(workgrouplist), NULL, currnode), 2, currnode->mountName);
  if (curr) {
    while (curr->next)
      curr = curr->next;
    curr->next = g_malloc(sizeof(mountedSmbfs));
    curr = curr->next;
    curr->next = (mountedSmbfs *) NULL;
  } else {
    rootMounted = curr = g_malloc(sizeof(mountedSmbfs));
    curr->next = (mountedSmbfs *) NULL;
  }
  curr->machineName = g_strdup(currnode->machineName);
  curr->shareName = g_strdup(currnode->shareName);
  curr->mountName = g_strdup(currnode->mountName);
}


/* *******************END MOUNTING CODE ***************** */

static void workgroupSelect(GtkCTree * ctree, GtkCTreeNode * node, gint column, gpointer * data)
{
  machineNode *tmp;
	gchar * tmsg;
	
  if (didFind == TRUE) {
    didFind = FALSE;
    return;
  }
  tmp = gtk_ctree_node_get_row_data(ctree, node);
  currnode = tmp;
  if (tmp == NULL)
    return;
  if (tmp->machineName != NULL) {
		tmsg = g_malloc(sizeof(gchar) * (strlen(tmp->machineName) + strlen(tmp->ip) + 5));
		sprintf(tmsg, "%s at %s", tmp->machineName, tmp->ip);
		setStatusbar(tmsg);
		g_free(tmsg);
	}

	if (tmp->scanned == TRUE)
    return;
  if (tmp->shareName != NULL)
    return;
  doShareScan(tmp);
}


static void clist_click_column(GtkCList * clist, gint column, gpointer data)
{

  if (column != clist->sort_column)
    gtk_clist_set_sort_column(clist, column);
  else {
    if (clist->sort_type == GTK_SORT_ASCENDING)
      clist->sort_type = GTK_SORT_DESCENDING;
    else
      clist->sort_type = GTK_SORT_ASCENDING;
  }
  gtk_clist_sort(clist);
}


void sortList()
{

  GtkCList *clist;

  clist = GTK_CLIST(workgrouplist);

  if (clist->sort_type == GTK_SORT_ASCENDING)
    clist->sort_type = GTK_SORT_DESCENDING;
  else
    clist->sort_type = GTK_SORT_ASCENDING;

  gtk_ctree_sort_node(GTK_CTREE(workgrouplist), gtk_ctree_find_by_row_data(GTK_CTREE(workgrouplist), NULL, currnode));

}


static GnomeUIInfo unmounted_disc_popup_menu[] =
{
  GNOMEUIINFO_ITEM_NONE(N_("Browse In GMC"), N_("Browse the current share in gmc"), browseShare),
  GNOMEUIINFO_ITEM_NONE(N_("Mount"), N_("Mount"), mountShare),
  GNOMEUIINFO_ITEM_NONE(N_("Mount with command"), N_("Mount with default command"), mountShareCmd),
  GNOMEUIINFO_END
};

static GnomeUIInfo mounted_disc_popup_menu[] =
{
  GNOMEUIINFO_ITEM_NONE(N_("UnMount"), N_("UnMount"), unmountShare),
  GNOMEUIINFO_END
};

static GnomeUIInfo printer_popup_menu[] =
{
  GNOMEUIINFO_ITEM_NONE(N_("Add as network printer"), N_("Add the printer as a network printer"), addNetworkPrinter),
  GNOMEUIINFO_ITEM_NONE(N_("Add as SMB printer"), N_("Add as a samba printer"), addSmbPrinter),
  GNOMEUIINFO_ITEM_NONE(N_("Remove"), N_("Remove printer"), removePrinter),
  GNOMEUIINFO_END
};


static GnomeUIInfo machine_popup_menu[] =
{
GNOMEUIINFO_ITEM_NONE(N_("Refresh"), N_("Refresh Share List"), refreshList),
  GNOMEUIINFO_ITEM_NONE(N_("Sort"), N_("Sort List"), sortList),
  GNOMEUIINFO_END
};

static GnomeUIInfo workgroup_popup_menu[] =
{
  GNOMEUIINFO_ITEM_NONE(N_("Sort"), N_("Sort List"), sortList),
  GNOMEUIINFO_END
};



/*this is where we deal with double clicks or right clicks, both of which only mean something if we are on a share */


gint buttonEvent(GtkWidget * widget, GdkEventButton * event)
{
  gint row, column;
  machineNode *mn;
  GtkCTreeNode *ctn;
  GtkWidget *popup;

  if ((event->type == GDK_2BUTTON_PRESS) && (event->button == 1)) {

    if (AutoMount) {
      gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y,
				   &row, &column);
      mn = gtk_clist_get_row_data(GTK_CLIST(widget), row);
      if (mn == NULL)
	return TRUE;
      if (mn->shareName == NULL)
	return TRUE;

      currnode = mn;
      domnt = 1;
      mountShareCmd();
    }
    return TRUE;
  }
  if ((event->type == GDK_BUTTON_PRESS) && (event->button == 3)) {

    gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y,
				 &row, &column);
    mn = gtk_clist_get_row_data(GTK_CLIST(widget), row);

    ctn = gtk_ctree_node_nth(GTK_CTREE(widget), row);
    gtk_ctree_select(GTK_CTREE(widget), ctn);

    if ((mn == NULL) || (mn->machineName == NULL)) {
      popup = gnome_popup_menu_new(workgroup_popup_menu);
    } else if (mn->shareName == NULL) {
      if (debug)
        g_print("pop up menu, machine:%s\n", mn->machineName);
      popup = gnome_popup_menu_new(machine_popup_menu);
    } else {
      if (debug)
	      g_print("pop up menu, share:%s\n", mn->shareName);
      if (mn->shareType == GNOMBA_SHARE_TYPE_DISC)
	popup = gnome_popup_menu_new(mn->mountName ? mounted_disc_popup_menu : unmounted_disc_popup_menu);
      else if (mn->shareType == GNOMBA_SHARE_TYPE_PRINTER)
	popup = gnome_popup_menu_new(printer_popup_menu);
    }
    gnome_popup_menu_do_popup(popup, NULL, NULL, NULL, NULL);

    return TRUE;
  }
  return FALSE;
}


void createBrowser(GtkWidget * frame)
{
  GtkWidget *hbox;
  gchar *listTitles[3];
  GdkColor transparent;

  network_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &network_mask,
						&transparent, network_xpm);
  workgroup_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &workgroup_mask,
					       &transparent, workgroup_xpm);
  machine_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &machine_mask,
						&transparent, machine_xpm);
  share_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &share_mask,
					      &transparent, share_xpm);
  printer_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &printer_mask,
						&transparent, printer_xpm);

  listTitles[0] = g_malloc(sizeof(gchar) * 16);
  listTitles[0] = _("Workgroup Name\0");
  listTitles[1] = g_malloc(sizeof(gchar) * 8);
  listTitles[1] = _("Comment\0");
  listTitles[2] = g_malloc(sizeof(gchar) * 12);
  listTitles[2] = _("Mount Point\0");

  hbox = gtk_hbox_new(FALSE, 0);
  workgrouplist = gtk_ctree_new_with_titles(3, 0, listTitles);
  gtk_signal_connect(GTK_OBJECT(workgrouplist), "tree_select_row",
		     (GtkSignalFunc) workgroupSelect, NULL);
  gtk_signal_connect(GTK_OBJECT(workgrouplist), "click_column",
		     (GtkSignalFunc) clist_click_column, NULL);

  workgroupframe = gtk_scrolled_window_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(workgroupframe), workgrouplist);
  gtk_box_pack_start(GTK_BOX(hbox), workgroupframe, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(workgroupframe),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_AUTOMATIC);

  gtk_signal_connect(GTK_OBJECT(workgrouplist), "button_press_event",
		     (GtkSignalFunc) buttonEvent, NULL);

  gtk_widget_show(workgroupframe);
  gtk_widget_show(workgrouplist);

  gtk_box_pack_start(GTK_BOX(frame), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);

}

/*
 * Local Variables:
 * mode:C
 * c-indent-level:2
 * End:
 */
